/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetEncounterContextPlugin;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventManagerAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.events.RecentUnrestEvent;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseEventPlugin
implements CampaignEventPlugin,
CampaignEventListener {
    private String id = Misc.genUID();
    protected String eventType;
    protected CampaignEventTarget eventTarget;
    protected MarketAPI market;
    protected SectorEntityToken entity;
    protected FactionAPI faction;
    protected String statModId;
    protected boolean started;
    protected MemoryAPI memory = null;
    protected float startProbability;

    @Override
    public void init(String eventType, CampaignEventTarget eventTarget) {
        this.init(eventType, eventTarget, true);
    }

    public void init(String eventType, CampaignEventTarget eventTarget, boolean addListener) {
        this.eventType = eventType;
        this.eventTarget = eventTarget;
        this.setTarget(eventTarget);
        this.statModId = this.market == null ? String.valueOf(eventType) + "_" + Misc.genUID() : String.valueOf(eventType) + "_" + this.market.getId() + "_" + Misc.genUID();
        if (addListener) {
            Global.getSector().addListener(this);
        }
    }

    public void setTarget(CampaignEventTarget eventTarget) {
        this.eventTarget = eventTarget;
        if (eventTarget.getEntity() != null) {
            this.market = eventTarget.getEntity().getMarket();
            this.faction = eventTarget.getFaction();
            this.entity = eventTarget.getEntity();
        }
    }

    protected String getLoggingId() {
        if (this.market != null) {
            return "[" + this.market.getName() + "]";
        }
        if (this.eventTarget != null && this.eventTarget.getEntity() != null) {
            return "[" + this.eventTarget.getEntity().getName() + "]";
        }
        return "[" + this.eventType + "]";
    }

    @Override
    public void cleanup() {
        Global.getSector().removeListener(this);
    }

    @Override
    public void startEvent() {
        this.startEvent(false);
    }

    public void startEvent(boolean addListener) {
        this.started = true;
        if (addListener) {
            Global.getSector().addListener(this);
        }
    }

    protected boolean isEventStarted() {
        return this.started;
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public CampaignEventTarget getEventTarget() {
        return this.eventTarget;
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    @Override
    public String getStageIdForLikely() {
        return null;
    }

    @Override
    public String getStageIdForPossible() {
        return null;
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        RepLevel level;
        HashMap<String, String> tokens = new HashMap<String, String>();
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        tokens.put("$playerName", Global.getSector().getCharacterData().getName());
        PersonAPI playerPerson = Global.getSector().getPlayerPerson();
        if (playerPerson != null) {
            if (playerPerson.isMale()) {
                tokens.put("$playerHisOrHer", "his");
                tokens.put("$PlayerHisOrHer", "His");
                tokens.put("$playerHimOrHer", "him");
                tokens.put("$PlayerHimOrHer", "Him");
                tokens.put("$playerHeOrShe", "he");
                tokens.put("$PlayerHeOrShe", "He");
            } else {
                tokens.put("$playerHisOrHer", "her");
                tokens.put("$PlayerHisOrHer", "Her");
                tokens.put("$playerHimOrHer", "her");
                tokens.put("$PlayerHimOrHer", "Her");
                tokens.put("$playerHeOrShe", "she");
                tokens.put("$PlayerHeOrShe", "She");
            }
        }
        MarketAPI market = this.market;
        SectorEntityToken entity = this.entity;
        FactionAPI faction = this.faction;
        if (this.getEventTarget() != null) {
            market = this.getEventTarget().getMarket();
            entity = this.getEventTarget().getEntity();
            faction = this.getEventTarget().getFaction();
        }
        if (entity != null) {
            tokens.put("$name", entity.getName());
        }
        if (market != null) {
            if (market.getPrimaryEntity().hasTag("station")) {
                tokens.put("$onOrAt", "at");
            } else {
                tokens.put("$onOrAt", "on");
            }
            tokens.put("$market", market.getName());
            tokens.put("$marketFaction", market.getFaction().getDisplayName());
            tokens.put("$MarketFaction", Misc.ucFirst(market.getFaction().getDisplayName()));
            tokens.put("$TheMarketFaction", Misc.ucFirst(market.getFaction().getDisplayNameWithArticle()));
            tokens.put("$theMarketFaction", market.getFaction().getDisplayNameWithArticle());
            if (this.eventTarget.getLocation() instanceof StarSystemAPI) {
                tokens.put("$marketSystem", ((StarSystemAPI)this.eventTarget.getLocation()).getBaseName());
            } else {
                tokens.put("$marketSystem", "hyperspace");
            }
            level = playerFleet.getFaction().getRelationshipLevel(market.getFaction());
            tokens.put("$factionStanding", level.getDisplayName().toLowerCase());
            tokens.put("$FactionStanding", Misc.ucFirst(level.getDisplayName()));
        }
        if (faction != null) {
            level = playerFleet.getFaction().getRelationshipLevel(faction);
            tokens.put("$factionStanding", level.getDisplayName().toLowerCase());
            tokens.put("$FactionStanding", Misc.ucFirst(level.getDisplayName()));
        }
        if (playerFleet != null) {
            String fleetOrShip = "fleet";
            if (playerFleet.getFleetData().getMembersListCopy().size() == 1) {
                fleetOrShip = "ship";
                if (playerFleet.getFleetData().getMembersListCopy().get(0).isFighterWing()) {
                    fleetOrShip = "fighter wing";
                }
            }
            tokens.put("$playerShipOrFleet", fleetOrShip);
        }
        if (faction != null) {
            String factionName = faction.getEntityNamePrefix();
            if (factionName == null || factionName.isEmpty()) {
                factionName = faction.getDisplayName();
            }
            tokens.put("$factionIsOrAre", faction.getDisplayNameIsOrAre());
            tokens.put("$faction", factionName);
            tokens.put("$ownerFaction", factionName);
            tokens.put("$marketFaction", factionName);
            tokens.put("$Faction", Misc.ucFirst(factionName));
            tokens.put("$OwnerFaction", Misc.ucFirst(factionName));
            tokens.put("$MarketFaction", Misc.ucFirst(factionName));
            tokens.put("$theFaction", faction.getDisplayNameWithArticle());
            tokens.put("$theOwnerFaction", faction.getDisplayNameWithArticle());
            tokens.put("$theMarketFaction", faction.getDisplayNameWithArticle());
            tokens.put("$TheFaction", Misc.ucFirst(faction.getDisplayNameWithArticle()));
            tokens.put("$TheOwnerFaction", Misc.ucFirst(faction.getDisplayNameWithArticle()));
            tokens.put("$TheMarketFaction", Misc.ucFirst(faction.getDisplayNameWithArticle()));
            tokens.put("$factionLong", faction.getDisplayNameLong());
            tokens.put("$FactionLong", Misc.ucFirst(faction.getDisplayNameLong()));
            tokens.put("$theFactionLong", faction.getDisplayNameLongWithArticle());
            tokens.put("$TheFactionLong", Misc.ucFirst(faction.getDisplayNameLongWithArticle()));
        }
        return tokens;
    }

    public static void addFactionNameTokens(Map<String, String> tokens, String prefix, FactionAPI faction) {
        if (faction != null) {
            String factionName = faction.getEntityNamePrefix();
            if (factionName == null || factionName.isEmpty()) {
                factionName = faction.getDisplayName();
            }
            String prefixUC = Misc.ucFirst(prefix);
            tokens.put("$" + prefix + "Faction", factionName);
            tokens.put("$" + prefixUC + "Faction", Misc.ucFirst(factionName));
            tokens.put("$the" + prefixUC + "Faction", faction.getDisplayNameWithArticle());
            tokens.put("$The" + prefixUC + "Faction", Misc.ucFirst(faction.getDisplayNameWithArticle()));
            tokens.put("$" + prefix + "FactionLong", faction.getDisplayNameLong());
            tokens.put("$" + prefixUC + "FactionLong", Misc.ucFirst(faction.getDisplayNameLong()));
            tokens.put("$the" + prefixUC + "FactionLong", faction.getDisplayNameLongWithArticle());
            tokens.put("$The" + prefixUC + "FactionLong", Misc.ucFirst(faction.getDisplayNameLongWithArticle()));
            tokens.put("$" + prefix + "FactionIsOrAre", faction.getDisplayNameIsOrAre());
        }
    }

    public static void addPersonTokens(Map<String, String> tokens, String prefix, PersonAPI person) {
        if (person != null) {
            tokens.put("$" + prefix + "Name", person.getName().getFullName());
            tokens.put("$" + prefix + "LastName", person.getName().getLast());
            tokens.put("$" + prefix + "FirstName", person.getName().getFirst());
            tokens.put("$" + prefix + "Rank", person.getRank().toLowerCase());
            tokens.put("$" + Misc.ucFirst(prefix) + "Rank", Misc.ucFirst(person.getRank()));
            tokens.put("$" + prefix + "Post", person.getPost().toLowerCase());
            tokens.put("$" + Misc.ucFirst(prefix) + "Post", Misc.ucFirst(person.getPost()));
            if (person.isMale()) {
                tokens.put("$" + prefix + "HisOrHer", "his");
                tokens.put("$" + Misc.ucFirst(prefix) + "HisOrHer", "His");
                tokens.put("$" + prefix + "HimOrHer", "him");
                tokens.put("$" + Misc.ucFirst(prefix) + "HimOrHer", "Him");
                tokens.put("$" + prefix + "HeOrShe", "he");
                tokens.put("$" + Misc.ucFirst(prefix) + "HeOrShe", "He");
            } else {
                tokens.put("$" + prefix + "HisOrHer", "her");
                tokens.put("$" + Misc.ucFirst(prefix) + "HisOrHer", "Her");
                tokens.put("$" + prefix + "HimOrHer", "her");
                tokens.put("$" + Misc.ucFirst(prefix) + "HimOrHer", "Her");
                tokens.put("$" + prefix + "HeOrShe", "she");
                tokens.put("$" + Misc.ucFirst(prefix) + "HeOrShe", "She");
            }
        }
    }

    @Override
    public MessagePriority getWarningWhenLikelyPriority() {
        return null;
    }

    @Override
    public MessagePriority getWarningWhenPossiblePriority() {
        return null;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public void setParam(Object param) {
    }

    public String getTargetName() {
        if (this.eventTarget.getEntity() != null) {
            return String.valueOf(this.eventTarget.getEntity().getName()) + " (" + this.eventTarget.getLocation().getName() + ")";
        }
        return this.eventTarget.getLocation().getName();
    }

    public static MarketAPI findNearestMarket(MarketAPI from, MarketFilter filter) {
        float minDist = Float.MAX_VALUE;
        MarketAPI result = null;
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            float dist;
            if (market == from || !((dist = Misc.getDistance(market.getLocationInHyperspace(), from.getLocationInHyperspace())) < minDist) || filter != null && !filter.acceptMarket(market)) continue;
            minDist = dist;
            result = market;
        }
        return result;
    }

    public static List<MarketAPI> findMatchingMarkets(MarketFilter filter) {
        ArrayList<MarketAPI> result = new ArrayList<MarketAPI>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (filter != null && !filter.acceptMarket(market)) continue;
            result.add(market);
        }
        return result;
    }

    public void increaseRecentUnrest(float stabilityChange) {
        if (stabilityChange <= 0.0f) {
            return;
        }
        CampaignEventManagerAPI manager = Global.getSector().getEventManager();
        RecentUnrestEvent event = (RecentUnrestEvent)manager.getOngoingEvent(this.eventTarget, "recent_unrest");
        if (event == null) {
            event = (RecentUnrestEvent)manager.startEvent(this.eventTarget, "recent_unrest", null);
        }
        event.increaseStabilityPenalty((int)stabilityChange);
    }

    @Override
    public void reportPlayerMarketTransaction(PlayerMarketTransaction transaction) {
    }

    @Override
    public void reportFleetDespawned(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
    }

    @Override
    public void reportFleetJumped(CampaignFleetAPI fleet, SectorEntityToken from, JumpPointAPI.JumpDestination to) {
    }

    @Override
    public void reportFleetReachedEntity(CampaignFleetAPI fleet, SectorEntityToken entity) {
    }

    @Override
    public boolean allowMultipleOngoingForSameTarget() {
        return false;
    }

    @Override
    public String[] getHighlights(String stageId) {
        return null;
    }

    @Override
    public Color[] getHighlightColors(String stageId) {
        String[] highlights = this.getHighlights(stageId);
        if (highlights != null) {
            Color c = Global.getSettings().getColor("buttonShortcut");
            Object[] colors = new Color[highlights.length];
            Arrays.fill(colors, c);
            return colors;
        }
        return null;
    }

    public void addTokensToList(List<String> list, String ... keys) {
        Map<String, String> tokens = this.getTokenReplacements();
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (tokens.containsKey(key)) {
                list.add(tokens.get(key));
            }
            ++n2;
        }
    }

    @Override
    public String getEventName() {
        return "BaseEventPlugin.getEventName()";
    }

    @Override
    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.EVENT;
    }

    protected MessagePriority getDefaultPriority() {
        MessagePriority priority = MessagePriority.SECTOR;
        switch (this.market.getSize()) {
            case 1: 
            case 2: 
            case 3: {
                priority = MessagePriority.SYSTEM;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                priority = MessagePriority.CLUSTER;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                priority = MessagePriority.SECTOR;
            }
        }
        return priority;
    }

    @Override
    public List<String> getRelatedCommodities() {
        return null;
    }

    @Override
    public List<CampaignEventPlugin.PriceUpdatePlugin> getPriceUpdates() {
        return null;
    }

    @Override
    public void reportShownInteractionDialog(InteractionDialogAPI dialog) {
    }

    @Override
    public void reportPlayerOpenedMarket(MarketAPI market) {
    }

    @Override
    public String getCurrentMessageIcon() {
        return null;
    }

    @Override
    public String getCurrentImage() {
        return null;
    }

    @Override
    public String getEventIcon() {
        return null;
    }

    @Override
    public boolean showAllMessagesIfOngoing() {
        return true;
    }

    @Override
    public void reportPlayerReputationChange(String faction, float delta) {
    }

    @Override
    public void reportPlayerEngagement(EngagementResultAPI result) {
    }

    @Override
    public void reportFleetSpawned(CampaignFleetAPI fleet) {
    }

    @Override
    public void reportPlayerOpenedMarketAndCargoUpdated(MarketAPI market) {
    }

    @Override
    public void reportEncounterLootGenerated(FleetEncounterContextPlugin plugin, CargoAPI loot) {
    }

    @Override
    public void reportPlayerClosedMarket(MarketAPI market) {
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        return true;
    }

    @Override
    public MemoryAPI getMemory() {
        return this.memory;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = Misc.genUID();
        }
        return this.id;
    }

    public String getStatModId() {
        return this.statModId;
    }

    @Override
    public void reportPlayerReputationChange(PersonAPI person, float delta) {
    }

    @Override
    public void reportPlayerActivatedAbility(AbilityPlugin ability, Object param) {
    }

    @Override
    public void reportPlayerDeactivatedAbility(AbilityPlugin ability, Object param) {
    }

    @Override
    public void reportBattleFinished(CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }

    @Override
    public void setProbability(float p) {
        this.startProbability = p;
    }

    @Override
    public boolean useEventNameAsId() {
        return false;
    }

    @Override
    public boolean showLatestMessageIfOngoing() {
        return true;
    }

    @Override
    public void reportPlayerDumpedCargo(CargoAPI cargo) {
    }

    @Override
    public void reportPlayerDidNotTakeCargo(CargoAPI cargo) {
    }

    @Override
    public void reportEconomyMonthEnd() {
    }

    @Override
    public void reportEconomyTick(int iterIndex) {
    }

    public static interface MarketFilter {
        public boolean acceptMarket(MarketAPI var1);
    }
}

