/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestEvent
extends BaseEventPlugin {
    private float elapsedDays = 0.0f;
    private CampaignEventTarget eventTarget;
    private boolean started = false;
    private int stage = 0;
    private String type;

    @Override
    public void init(String type, CampaignEventTarget eventTarget) {
        this.type = type;
        this.eventTarget = eventTarget;
    }

    @Override
    public void startEvent() {
        this.started = true;
    }

    @Override
    public void advance(float amount) {
        if (Global.getSector().isPaused()) {
            return;
        }
        if (!this.started) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsedDays += days;
        if (this.elapsedDays > 0.0f && this.stage == 0) {
            System.out.println("Test event reporting stage start");
            Global.getSector().reportEventStage(this, "start", MessagePriority.SECTOR);
            ++this.stage;
        }
        if (this.elapsedDays > 1.0f && this.stage == 1) {
            System.out.println("Test event reporting stage warning_relief");
            Global.getSector().reportEventStage(this, "warning_relief", MessagePriority.SECTOR);
            ++this.stage;
        }
        if (this.elapsedDays > 2.0f && this.stage == 2) {
            System.out.println("Test event reporting stage relief_sent");
            Global.getSector().reportEventStage(this, "relief_sent", MessagePriority.SYSTEM);
            ++this.stage;
        }
        if (this.elapsedDays > 3.0f && this.stage == 3) {
            System.out.println("Test event reporting stage relief_arrived");
            Global.getSector().reportEventStage(this, "relief_arrived", MessagePriority.SYSTEM);
            ++this.stage;
        }
    }

    @Override
    public boolean isDone() {
        return this.elapsedDays > 15.0f || this.stage >= 4;
    }

    @Override
    public CampaignEventTarget getEventTarget() {
        return this.eventTarget;
    }

    @Override
    public String getEventType() {
        return this.type;
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("$market", this.eventTarget.getEntity().getName());
        if (this.eventTarget.getLocation() instanceof StarSystemAPI) {
            map.put("$marketSystem", String.valueOf(((StarSystemAPI)this.eventTarget.getLocation()).getBaseName()) + " star system");
        } else {
            map.put("$marketSystem", "hyperspace");
        }
        map.put("$targetFaction", this.eventTarget.getEntity().getFaction().getDisplayName());
        map.put("$reliefSystem", "Askonia");
        map.put("$reliefEntity", "Volturn");
        return map;
    }

    @Override
    public MessagePriority getWarningWhenPossiblePriority() {
        return MessagePriority.SECTOR;
    }

    @Override
    public MessagePriority getWarningWhenLikelyPriority() {
        return MessagePriority.SECTOR;
    }

    @Override
    public String getStageIdForLikely() {
        return "likely";
    }

    @Override
    public String getStageIdForPossible() {
        return "possible";
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void setParam(Object param) {
    }

    @Override
    public boolean allowMultipleOngoingForSameTarget() {
        return false;
    }

    @Override
    public Color[] getHighlightColors(String stageId) {
        return null;
    }

    @Override
    public String[] getHighlights(String stageId) {
        return null;
    }
}

