/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.impl.campaign.events.PriceUpdate;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.SaveableIterator;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TradeInfoUpdateEvent
extends BaseEventPlugin {
    public static final float TIMEOUT = 30.0f;
    public static Logger log = Global.getLogger(TradeInfoUpdateEvent.class);
    private IntervalUtil remoteTracker;
    private IntervalUtil localTracker;
    private TimeoutTracker<String> sinceLastLocalReport = new TimeoutTracker();
    private TimeoutTracker<String> sinceLastRemoteReport = new TimeoutTracker();
    private List<CampaignEventPlugin.PriceUpdatePlugin> updatesForNextReport = new ArrayList<CampaignEventPlugin.PriceUpdatePlugin>();
    private SectorEntityToken commRelayForNextReport = null;
    private SaveableIterator<StarSystemAPI> starSystemIter = null;
    private CampaignEventTarget tempTarget;

    @Override
    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        this.remoteTracker = new IntervalUtil(0.5f, 1.5f);
        this.localTracker = new IntervalUtil(0.5f, 1.5f);
    }

    @Override
    public void startEvent() {
        super.startEvent();
    }

    @Override
    public void advance(float amount) {
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.sinceLastLocalReport.advance(days);
        this.sinceLastRemoteReport.advance(days);
        this.localTracker.advance(days);
        if (this.localTracker.intervalElapsed()) {
            this.checkLocalPrices();
        }
        this.remoteTracker.advance(days);
        if (this.remoteTracker.intervalElapsed()) {
            this.checkRemotePrices();
        }
    }

    private void checkRemotePrices() {
        boolean hasIntel;
        if (this.starSystemIter == null || !this.starSystemIter.hasNext()) {
            ArrayList<StarSystemAPI> systems = new ArrayList<StarSystemAPI>(Global.getSector().getStarSystems());
            Collections.shuffle(systems);
            this.starSystemIter = new SaveableIterator<StarSystemAPI>(systems);
            float size = systems.size();
            float interval = 45.0f / size;
            this.remoteTracker.setInterval(interval * 0.75f, interval * 1.25f);
        }
        if (!this.starSystemIter.hasNext()) {
            return;
        }
        StarSystemAPI system = this.starSystemIter.next();
        List<SectorEntityToken> relays = system.getEntitiesWithTag("comm_relay");
        List<SectorEntityToken> withIntel = Global.getSector().getIntel().getCommSnifferLocations();
        SectorEntityToken relay = null;
        for (SectorEntityToken curr : relays) {
            if (!withIntel.contains(curr)) continue;
            relay = curr;
            break;
        }
        boolean bl = hasIntel = relay != null;
        if (relay == null && relays.size() > 0) {
            relay = relays.get(new Random().nextInt(relays.size()));
        }
        if (relay == null) {
            return;
        }
        String id = relay.getContainingLocation().getId();
        if (this.sinceLastRemoteReport.contains(id)) {
            return;
        }
        List<PriceUpdate> list = this.getPriceUpdatesFor(system);
        if (!list.isEmpty()) {
            this.commRelayForNextReport = relay;
            if (hasIntel) {
                this.pickUpdatesFrom(system, list, PickMode.REMOTE_WITH_INTEL);
                if (!this.updatesForNextReport.isEmpty()) {
                    this.sinceLastRemoteReport.set(id, 30.0f);
                }
            } else {
                this.pickUpdatesFrom(system, list, PickMode.REMOTE);
                if (!this.updatesForNextReport.isEmpty()) {
                    this.sinceLastRemoteReport.set(id, 30.0f);
                }
            }
        }
    }

    private void checkLocalPrices() {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (playerFleet.isInHyperspace() || playerFleet.getContainingLocation() == null) {
            return;
        }
        String id = playerFleet.getContainingLocation().getId();
        if (this.sinceLastLocalReport.contains(id)) {
            return;
        }
        List<PriceUpdate> list = this.getPriceUpdatesFor(playerFleet.getContainingLocation());
        if (!list.isEmpty()) {
            this.pickUpdatesFrom(playerFleet.getContainingLocation(), list, PickMode.LOCAL);
            if (!this.updatesForNextReport.isEmpty()) {
                this.sinceLastLocalReport.set(id, 30.0f);
            }
        }
    }

    private void pickUpdatesFrom(LocationAPI system, List<PriceUpdate> updates, PickMode mode) {
        float numMarkets = 0.0f;
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.getContainingLocation() != system) continue;
            numMarkets += 1.0f;
        }
        int max = 0;
        switch (mode) {
            case LOCAL: {
                max = (int)Math.max(2.0f, numMarkets) + 1;
                break;
            }
            case REMOTE: {
                max = (int)Math.max(1.0f, numMarkets - 2.0f);
                break;
            }
            case REMOTE_WITH_INTEL: {
                max = (int)Math.max(1.0f, numMarkets);
            }
        }
        if (max > 5) {
            max = 5;
        }
        if (max < 1) {
            max = 1;
        }
        log.info((Object)"");
        log.info((Object)"");
        log.info((Object)("Picking " + max + " updates"));
        WeightedRandomPicker<PriceUpdate> picker = new WeightedRandomPicker<PriceUpdate>();
        List<CampaignEventPlugin.PriceUpdatePlugin> known = this.getPlayerKnownUpdates();
        for (PriceUpdate pu : updates) {
            float weight = this.getWeightFor(pu, known);
            if (weight <= 0.0f) continue;
            log.info((Object)(String.valueOf(pu.getCommodity().getCommodity().getName()) + "(" + pu.getCommodity().getMarket().getName() + "): weight " + weight));
            picker.add(pu, weight);
        }
        log.info((Object)"");
        this.updatesForNextReport.clear();
        int i = 0;
        while (i < max) {
            PriceUpdate update = (PriceUpdate)picker.pick();
            if (update != null) {
                log.info((Object)("Picked " + update.getCommodity().getCommodity().getName() + "(" + update.getCommodity().getMarket().getName() + ")"));
                this.updatesForNextReport.add(update);
                picker.remove(update);
            }
            ++i;
        }
    }

    private void pickAllRelevantFromMarket(MarketAPI market, List<PriceUpdate> updates) {
        log.info((Object)"Picking market updates");
        this.updatesForNextReport.clear();
        List<CampaignEventPlugin.PriceUpdatePlugin> known = this.getPlayerKnownUpdates();
        for (PriceUpdate update : updates) {
            if (!this.shouldUpdateLocally(update, known)) continue;
            log.info((Object)("Adding " + update.getCommodity().getCommodity().getName() + "(" + update.getCommodity().getMarket().getName() + ")"));
            this.updatesForNextReport.add(update);
        }
    }

    private List<PriceUpdate> getPriceUpdatesFor(LocationAPI system) {
        ArrayList<PriceUpdate> updates = new ArrayList<PriceUpdate>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.getContainingLocation() != system) continue;
            updates.addAll(this.getUpdatesFor(market));
        }
        return updates;
    }

    private List<PriceUpdate> getUpdatesFor(MarketAPI market) {
        ArrayList<PriceUpdate> updates = new ArrayList<PriceUpdate>();
        if (!market.isInEconomy()) {
            return updates;
        }
        for (CommodityOnMarketAPI com : market.getAllCommodities()) {
            PriceUpdate update;
            float volumeFactor;
            if (com.isNonEcon() || com.isPersonnel() || (volumeFactor = com.getStockpile() + com.getDemand().getDemandValue()) < 50.0f || !(update = new PriceUpdate(com)).isSignificant()) continue;
            updates.add(update);
        }
        return updates;
    }

    private float getWeightFor(CampaignEventPlugin.PriceUpdatePlugin update, List<CampaignEventPlugin.PriceUpdatePlugin> known) {
        CommodityOnMarketAPI com = update.getCommodity();
        MarketAPI market = update.getMarket();
        float volumeFactor = com.getStockpile() + com.getDemand().getDemandValue();
        if (volumeFactor == 0.0f) {
            return 0.0f;
        }
        volumeFactor = (float)Math.sqrt(volumeFactor);
        if (update.getType() == CampaignEventPlugin.PriceUpdatePlugin.PriceType.NORMAL) {
            volumeFactor *= 0.25f;
        }
        float numCheap = 0.0f;
        float numExpensive = 0.0f;
        float numNormal = 0.0f;
        CampaignClockAPI clock = Global.getSector().getClock();
        float daysSinceLastSame = Float.MAX_VALUE;
        int numSeenSkipped = 0;
        HashSet<CommodityOnMarketAPI> seen = new HashSet<CommodityOnMarketAPI>();
        for (CampaignEventPlugin.PriceUpdatePlugin curr : known) {
            float priceDiff;
            CommodityOnMarketAPI currCom = curr.getCommodity();
            if (currCom == null) continue;
            if (seen.contains(currCom)) {
                ++numSeenSkipped;
                continue;
            }
            seen.add(currCom);
            if (!currCom.getId().equals(com.getId())) continue;
            if (currCom == com && (priceDiff = Math.abs(curr.getDemandPrice() + curr.getSupplyPrice() - update.getDemandPrice() - update.getSupplyPrice())) < 0.2f * (curr.getDemandPrice() + curr.getSupplyPrice())) {
                daysSinceLastSame = clock.getElapsedDaysSince(curr.getTimestamp());
            }
            switch (curr.getType()) {
                case CHEAP: {
                    numCheap += 1.0f;
                    break;
                }
                case EXPENSIVE: {
                    numExpensive += 1.0f;
                    break;
                }
                case NORMAL: {
                    numNormal += 1.0f;
                }
            }
        }
        if (daysSinceLastSame < 30.0f) {
            return 0.0f;
        }
        if (update.getType() == CampaignEventPlugin.PriceUpdatePlugin.PriceType.NORMAL) {
            if (numExpensive + numCheap == 0.0f) {
                return 0.0f;
            }
            if (numCheap == 0.0f && update.getAvailable() <= 10.0f) {
                return 0.0f;
            }
            if (numExpensive == 0.0f && update.getDemand() <= 10.0f) {
                return 0.0f;
            }
        }
        float total = numCheap + numExpensive + numNormal;
        float weightMult = 1.0f;
        if (total <= 0.0f) {
            total = 1.0f;
        }
        switch (update.getType()) {
            case CHEAP: {
                weightMult = 1.0f + 3.0f * Math.max(0.0f, numNormal + numExpensive - numCheap) / total;
                break;
            }
            case EXPENSIVE: {
                weightMult = 1.0f + 3.0f * Math.max(0.0f, numNormal + numCheap - numExpensive) / total;
                if (com.isFuel() || com.isPersonnel() || com.getId().equals("supplies")) break;
                CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                float f = playerFleet.getCargo().getQuantity(CargoAPI.CargoItemType.RESOURCES, com.getId()) / Math.max(playerFleet.getCargo().getMaxCapacity(), 1.0f);
                weightMult *= 1.0f + 2.0f * f;
                break;
            }
            case NORMAL: {
                weightMult = 1.0f + 1.0f * Math.max(0.0f, numCheap + numExpensive - numNormal) / total;
            }
        }
        return volumeFactor * weightMult;
    }

    private boolean shouldUpdateLocally(PriceUpdate update, List<CampaignEventPlugin.PriceUpdatePlugin> known) {
        if (!update.isSignificant()) {
            return false;
        }
        CommodityOnMarketAPI com = update.getCommodity();
        MarketAPI market = com.getMarket();
        StarSystemAPI system = market.getStarSystem();
        CampaignClockAPI clock = Global.getSector().getClock();
        float daysSinceLastSame = Float.MAX_VALUE;
        int numSeenSkipped = 0;
        HashSet<CommodityOnMarketAPI> seen = new HashSet<CommodityOnMarketAPI>();
        CampaignEventPlugin.PriceUpdatePlugin mostRecent = null;
        for (CampaignEventPlugin.PriceUpdatePlugin curr : known) {
            CommodityOnMarketAPI currCom = curr.getCommodity();
            if (currCom == null) continue;
            if (seen.contains(currCom)) {
                ++numSeenSkipped;
                continue;
            }
            seen.add(currCom);
            if (!currCom.getId().equals(com.getId()) || currCom != com) continue;
            mostRecent = curr;
            float priceDiff = Math.abs(curr.getDemandPrice() + curr.getSupplyPrice() - update.getDemandPrice() - update.getSupplyPrice());
            if (!(priceDiff < 0.2f * (curr.getDemandPrice() + curr.getSupplyPrice()))) break;
            daysSinceLastSame = clock.getElapsedDaysSince(curr.getTimestamp());
            break;
        }
        if (daysSinceLastSame < 5.0f) {
            return false;
        }
        if (update.getType() != CampaignEventPlugin.PriceUpdatePlugin.PriceType.NORMAL) {
            return true;
        }
        return mostRecent != null;
    }

    private List<CampaignEventPlugin.PriceUpdatePlugin> getPlayerKnownUpdates() {
        CampaignClockAPI clock = Global.getSector().getClock();
        ArrayList<CampaignEventPlugin.PriceUpdatePlugin> updates = new ArrayList<CampaignEventPlugin.PriceUpdatePlugin>();
        return updates;
    }

    @Override
    public void reportPlayerOpenedMarket(MarketAPI market) {
        this.getLocalUpdates(market);
    }

    @Override
    public void reportPlayerClosedMarket(MarketAPI market) {
        this.getLocalUpdates(market);
    }

    protected void getLocalUpdates(MarketAPI market) {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        List<PriceUpdate> list = this.getUpdatesFor(market);
        this.tempTarget = new CampaignEventTarget(market);
        this.market = market;
        if (!list.isEmpty()) {
            this.pickAllRelevantFromMarket(market, list);
            this.updatesForNextReport.isEmpty();
        }
        this.tempTarget = null;
        this.market = null;
    }

    @Override
    public List<CampaignEventPlugin.PriceUpdatePlugin> getPriceUpdates() {
        return this.updatesForNextReport;
    }

    @Override
    public List<String> getRelatedCommodities() {
        return super.getRelatedCommodities();
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        List<CampaignEventPlugin.PriceUpdatePlugin> updates;
        Map<String, String> map = super.getTokenReplacements();
        if (this.commRelayForNextReport != null) {
            map.put("$relayName", this.commRelayForNextReport.getName());
            if (this.commRelayForNextReport.isInHyperspace()) {
                map.put("$fromSystem", "hyperspace");
            } else {
                map.put("$fromSystem", ((StarSystemAPI)this.commRelayForNextReport.getContainingLocation()).getBaseName());
            }
        }
        if ((updates = this.getPriceUpdates()) != null && !updates.isEmpty()) {
            String priceList = "Price information updated for: ";
            for (CampaignEventPlugin.PriceUpdatePlugin update : updates) {
                CommodityOnMarketAPI com = update.getCommodity();
                priceList = String.valueOf(priceList) + com.getCommodity().getName() + " (" + com.getMarket().getName() + "), ";
            }
            priceList = priceList.substring(0, priceList.length() - 2);
            priceList = String.valueOf(priceList) + ".";
            map.put("$priceList", priceList);
        }
        return map;
    }

    @Override
    public String[] getHighlights(String stageId) {
        return null;
    }

    @Override
    public Color[] getHighlightColors(String stageId) {
        return super.getHighlightColors(stageId);
    }

    @Override
    public CampaignEventTarget getEventTarget() {
        if (this.tempTarget != null) {
            return this.tempTarget;
        }
        return super.getEventTarget();
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public String getEventName() {
        return "Trade info update";
    }

    @Override
    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.DO_NOT_SHOW_IN_MESSAGE_FILTER;
    }

    @Override
    public boolean showAllMessagesIfOngoing() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PickMode {
        LOCAL,
        REMOTE,
        REMOTE_WITH_INTEL;

    }
}

