/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events.nearby;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CargoPodsEntityPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.CargoPods;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;

public class DistressCallNormalAssignmentAI
extends BaseAssignmentAI {
    protected StarSystemAPI system;
    protected SectorEntityToken jumpPoint;
    protected float elapsed = 0.0f;
    protected float dur = 30.0f + (float)Math.random() * 20.0f;
    protected boolean contactedPlayer = false;

    public DistressCallNormalAssignmentAI(CampaignFleetAPI fleet, StarSystemAPI system, SectorEntityToken jumpPoint) {
        this.fleet = fleet;
        this.system = system;
        this.jumpPoint = jumpPoint;
        this.giveInitialAssignments();
    }

    protected void giveInitialAssignments() {
        this.fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, this.jumpPoint, 30.0f);
    }

    protected void pickNext() {
        this.fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, this.jumpPoint, 30.0f);
    }

    public void advance(float amount) {
        SectorEntityToken.VisibilityLevel level;
        super.advance(amount);
        if (!this.fleet.getMemoryWithoutUpdate().contains("$distress")) {
            Misc.giveStandardReturnToSourceAssignments(this.fleet);
            this.fleet.removeScript(this);
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        boolean playerNearby = Misc.getDistanceToPlayerLY(this.fleet) <= 3.0f;
        this.elapsed += days;
        if (this.elapsed >= this.dur - 10.0f) {
            boolean seesPlayer = false;
            if (playerNearby) {
                SectorEntityToken.VisibilityLevel level2 = this.fleet.getVisibilityLevelOfPlayerFleet();
                seesPlayer |= level2 == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS;
                seesPlayer |= level2 == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS;
            }
            if (!seesPlayer) {
                DistressCallNormalAssignmentAI.undistress(this.fleet);
                int crewToLeave = (int)(this.fleet.getFleetData().getMinCrew() * 0.5f);
                DistressCallNormalAssignmentAI.scuttleShips(this.fleet, crewToLeave);
                DistressCallNormalAssignmentAI.leaveCrewInPods(this.fleet, crewToLeave);
            }
        }
        if (this.fleet.isInCurrentLocation() && !this.contactedPlayer && (level = this.fleet.getVisibilityLevelOfPlayerFleet()) != SectorEntityToken.VisibilityLevel.NONE && level != SectorEntityToken.VisibilityLevel.SENSOR_CONTACT) {
            this.contactedPlayer = true;
            this.fleet.clearAssignments();
            this.fleet.addAssignment(FleetAssignment.INTERCEPT, (SectorEntityToken)Global.getSector().getPlayerFleet(), 30.0f, "approaching your fleet");
        }
    }

    public static void leaveCrewInPods(CampaignFleetAPI fleet, int crew) {
        CustomCampaignEntityAPI pods = Misc.addCargoPods(fleet.getContainingLocation(), fleet.getLocation());
        CargoPodsEntityPlugin plugin = (CargoPodsEntityPlugin)pods.getCustomPlugin();
        plugin.setExtraDays(100.0f);
        pods.getCargo().addCrew(crew);
        CargoPods.stabilizeOrbit(pods, false);
    }

    public static void undistress(SectorEntityToken fleet) {
        MemoryAPI memory = fleet.getMemoryWithoutUpdate();
        memory.unset("$distress");
        memory.unset("$cfai_noJump");
        Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$missionImportant", "distress", false, 1000.0f);
    }

    public static void scuttleShips(CampaignFleetAPI fleet, int crewFreed) {
        ArrayList<FleetMemberAPI> members = new ArrayList<FleetMemberAPI>(fleet.getFleetData().getMembersListCopy());
        float scuttledCrewRoom = 0.0f;
        int i = members.size() - 1;
        while (i >= 0 && scuttledCrewRoom < (float)crewFreed) {
            FleetMemberAPI member = (FleetMemberAPI)members.get(i);
            fleet.removeFleetMemberWithDestructionFlash(member);
            scuttledCrewRoom += member.getMinCrew();
            --i;
        }
    }
}

