/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.util.IntervalUtil;

public abstract class BaseRouteFleetManager
implements EveryFrameScript,
RouteManager.RouteFleetSpawner {
    protected IntervalUtil interval;

    public BaseRouteFleetManager(float minInterval, float maxInterval) {
        this.interval = new IntervalUtil(minInterval, maxInterval);
    }

    protected abstract String getRouteSourceId();

    protected abstract int getMaxFleets();

    protected abstract void addRouteFleetIfPossible();

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.interval.advance(days);
        if (this.interval.intervalElapsed()) {
            String id = this.getRouteSourceId();
            int max = this.getMaxFleets();
            int curr = RouteManager.getInstance().getNumRoutesFor(id);
            if (curr >= max) {
                return;
            }
            this.addRouteFleetIfPossible();
        }
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }
}

