/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FactionDoctrineAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class FleetParamsV3 {
    public MarketAPI source;
    public Vector2f locInHyper;
    public float quality;
    public String factionId;
    public String fleetType;
    public float combatPts;
    public float freighterPts;
    public float tankerPts;
    public float transportPts;
    public float linerPts;
    public float utilityPts;
    public int maxShipSize = 1000;
    public int minShipSize = 0;
    public float qualityMod = 0.0f;
    public Float qualityOverride = null;
    public Integer averageSMods = null;
    public boolean withOfficers = true;
    public Boolean ignoreMarketFleetSizeMult = null;
    public Boolean onlyApplyFleetSizeToCombatShips = null;
    public Boolean doNotPrune = null;
    public Boolean doNotAddShipsBeforePruning = null;
    public FactionAPI.ShipPickMode modeOverride = null;
    public int officerLevelBonus = 0;
    public int officerNumberBonus = 0;
    public Integer maxOfficersToAdd = null;
    public float officerNumberMult = 1.0f;
    public int officerLevelLimit = 0;
    public int commanderLevelLimit = 0;
    public Random random = null;
    public PersonAPI commander;
    public Boolean noCommanderSkills;
    public Boolean forceAllowPhaseShipsEtc;
    public Boolean treatCombatFreighterSettingAsFraction;
    public FactionDoctrineAPI doctrineOverride = null;
    public Long timestamp;
    public Integer maxNumShips;
    public Boolean onlyRetainFlagship;
    public String flagshipVariantId;
    public ShipVariantAPI flagshipVariant;
    public HubMissionWithTriggers.OfficerQuality aiCores = null;
    public boolean doNotIntegrateAICores = false;
    public transient FactionAPI.ShipPickMode mode;
    public transient boolean banPhaseShipsEtc;
    public transient Boolean blockFallback = null;
    public Boolean allWeapons = null;

    public FleetParamsV3(MarketAPI source, Vector2f locInHyper, String factionId, Float qualityOverride, String fleetType, float combatPts, float freighterPts, float tankerPts, float transportPts, float linerPts, float utilityPts, float qualityMod) {
        if (source != null) {
            this.init(source, fleetType, factionId, combatPts, freighterPts, tankerPts, transportPts, linerPts, utilityPts, qualityMod);
            if (factionId != null) {
                this.factionId = factionId;
            }
            this.qualityOverride = qualityOverride;
            this.locInHyper = locInHyper;
        } else {
            this.init(locInHyper, factionId, qualityOverride, fleetType, combatPts, freighterPts, tankerPts, transportPts, linerPts, utilityPts, qualityMod);
        }
    }

    public FleetParamsV3() {
    }

    public FleetParamsV3(Vector2f locInHyper, String factionId, Float qualityOverride, String fleetType, float combatPts, float freighterPts, float tankerPts, float transportPts, float linerPts, float utilityPts, float qualityMod) {
        this.init(locInHyper, factionId, qualityOverride, fleetType, combatPts, freighterPts, tankerPts, transportPts, linerPts, utilityPts, qualityMod);
    }

    public FleetParamsV3(MarketAPI source, String fleetType, float combatPts, float freighterPts, float tankerPts, float transportPts, float linerPts, float utilityPts, float qualityMod) {
        this.init(source, fleetType, null, combatPts, freighterPts, tankerPts, transportPts, linerPts, utilityPts, qualityMod);
    }

    public void init(MarketAPI source, String fleetType, String factionId, float combatPts, float freighterPts, float tankerPts, float transportPts, float linerPts, float utilityPts, float qualityMod) {
        this.init(source.getLocationInHyperspace(), null, null, fleetType, combatPts, freighterPts, tankerPts, transportPts, linerPts, utilityPts, qualityMod);
        this.factionId = source.getFactionId();
        if (factionId != null) {
            this.factionId = factionId;
        }
        this.source = source;
        this.timestamp = Global.getSector().getClock().getTimestamp();
        this.updateQualityAndProducerFromSourceMarket();
    }

    public void init(Vector2f locInHyper, String factionId, Float qualityOverride, String fleetType, float combatPts, float freighterPts, float tankerPts, float transportPts, float linerPts, float utilityPts, float qualityMod) {
        this.locInHyper = locInHyper;
        this.factionId = factionId;
        this.qualityOverride = qualityOverride;
        this.fleetType = fleetType;
        this.combatPts = combatPts;
        this.freighterPts = freighterPts;
        this.tankerPts = tankerPts;
        this.transportPts = transportPts;
        this.linerPts = linerPts;
        this.utilityPts = utilityPts;
        this.qualityMod = qualityMod;
    }

    public void setSource(MarketAPI source, boolean updateQuality) {
        this.source = source;
        if (updateQuality) {
            this.updateQualityAndProducerFromSourceMarket();
        }
    }

    public void updateQualityAndProducerFromSourceMarket() {
        if (this.source != null) {
            this.quality = Misc.getShipQuality(this.source, this.factionId);
        }
    }

    public float getTotalPts() {
        return this.combatPts + this.freighterPts + this.tankerPts + this.transportPts + this.linerPts + this.utilityPts;
    }
}

