/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.BaseRouteFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactory;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.fleets.MercAssignmentAIV2;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.SystemBountyManager;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.Random;

public class MercFleetManagerV2
extends BaseRouteFleetManager {
    public static final Integer ROUTE_PREPARE = 1;
    public static final Integer ROUTE_TRAVEL = 2;
    public static final Integer ROUTE_PATROL = 3;
    public static final Integer ROUTE_RETURN = 4;
    public static final Integer ROUTE_STAND_DOWN = 5;

    public MercFleetManagerV2() {
        super(0.5f, 1.5f);
    }

    protected void addRouteFleetIfPossible() {
        MarketAPI from = this.pickMarket();
        if (from == null) {
            return;
        }
        MarketAPI to = this.pickNearbyMarketToDefend(from);
        if (to == null) {
            return;
        }
        Long seed = new Random().nextLong();
        String id = this.getRouteSourceId();
        RouteManager.OptionalFleetData extra = new RouteManager.OptionalFleetData(from);
        RouteManager.RouteData route = RouteManager.getInstance().addRoute(id, from, seed, extra, this);
        float orbitDays = 2.0f + (float)Math.random() * 3.0f;
        float deorbitDays = 2.0f + (float)Math.random() * 3.0f;
        float patrolDays = 2.0f + (float)Math.random() * 3.0f;
        SectorEntityToken target = to.getPrimaryEntity();
        if ((float)Math.random() > 0.25f && to.getStarSystem() != null) {
            target = (float)Math.random() > 0.25f ? to.getStarSystem().getCenter() : to.getStarSystem().getHyperspaceAnchor();
        }
        if (from.getContainingLocation() == to.getContainingLocation() && !from.getContainingLocation().isHyperspace()) {
            route.addSegment(new RouteManager.RouteSegment(ROUTE_PREPARE, orbitDays, from.getPrimaryEntity()));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_PATROL, patrolDays, target));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_STAND_DOWN, deorbitDays, from.getPrimaryEntity()));
        } else {
            route.addSegment(new RouteManager.RouteSegment(ROUTE_PREPARE, orbitDays, from.getPrimaryEntity()));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_TRAVEL, from.getPrimaryEntity(), to.getPrimaryEntity()));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_PATROL, patrolDays, target));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_RETURN, to.getPrimaryEntity(), from.getPrimaryEntity()));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_STAND_DOWN, deorbitDays, from.getPrimaryEntity()));
        }
    }

    public FleetFactory.MercType pickFleetType(Random random) {
        WeightedRandomPicker<FleetFactory.MercType> picker = new WeightedRandomPicker<FleetFactory.MercType>(random);
        picker.add(FleetFactory.MercType.SCOUT, 10.0f);
        picker.add(FleetFactory.MercType.BOUNTY_HUNTER, 10.0f);
        picker.add(FleetFactory.MercType.PRIVATEER, 10.0f);
        picker.add(FleetFactory.MercType.PATROL, 10.0f);
        picker.add(FleetFactory.MercType.ARMADA, 3.0f);
        FleetFactory.MercType type = (FleetFactory.MercType)((Object)picker.pick());
        return type;
    }

    public CampaignFleetAPI spawnFleet(RouteManager.RouteData route) {
        Random random = route.getRandom();
        FleetFactory.MercType type = this.pickFleetType(random);
        float combat = 0.0f;
        float tanker = 0.0f;
        float freighter = 0.0f;
        String fleetType = type.fleetType;
        switch (type) {
            case SCOUT: {
                combat = Math.round(1.0f + random.nextFloat() * 2.0f);
                break;
            }
            case BOUNTY_HUNTER: 
            case PRIVATEER: {
                combat = Math.round(3.0f + random.nextFloat() * 2.0f);
                break;
            }
            case PATROL: {
                combat = Math.round(9.0f + random.nextFloat() * 3.0f);
                tanker = (float)Math.round(random.nextFloat()) * 5.0f;
                break;
            }
            case ARMADA: {
                combat = Math.round(10.0f + random.nextFloat() * 4.0f);
                tanker = (float)Math.round(random.nextFloat()) * 10.0f;
                freighter = (float)Math.round(random.nextFloat()) * 10.0f;
            }
        }
        FleetParamsV3 params = new FleetParamsV3(route.getMarket(), null, "independent", Float.valueOf(route.getQualityOverride().floatValue() + 0.2f), fleetType, combat *= 5.0f, freighter, tanker, 0.0f, 0.0f, 0.0f, 0.0f);
        params.timestamp = route.getTimestamp();
        params.random = random;
        CampaignFleetAPI fleet = FleetFactoryV3.createFleet(params);
        if (fleet == null || fleet.isEmpty()) {
            return null;
        }
        route.getMarket().getContainingLocation().addEntity(fleet);
        fleet.setFacing((float)Math.random() * 360.0f);
        fleet.setLocation(route.getMarket().getPrimaryEntity().getLocation().x, route.getMarket().getPrimaryEntity().getLocation().x);
        MercAssignmentAIV2 ai = new MercAssignmentAIV2(fleet, route);
        fleet.addScript(ai);
        return fleet;
    }

    protected MarketAPI pickMarket() {
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.isHidden() || market.getFactionId().equals("pirates") || market.getFaction().isHostileTo("independent") || !market.hasSpaceport() || market.getStarSystem() != null && market.getStarSystem().hasTag("system_cut_off_from_hyper") || market.getDaysInExistence() < Global.getSettings().getFloat("minMarketExistenceDaysForMercs") || (float)market.getSize() < Global.getSettings().getFloat("minMarketSizeForMercs")) continue;
            float mult = Misc.getSpawnChanceMult(market.getLocationInHyperspace());
            float w = market.getStabilityValue() + (float)market.getSize();
            picker.add(market, w *= mult);
        }
        return (MarketAPI)picker.pick();
    }

    protected MarketAPI pickNearbyMarketToDefend(MarketAPI source) {
        MarketAPI market2;
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>();
        for (MarketAPI market2 : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market2.getFaction().isHostileTo("independent") || market2.getStarSystem() == null || market2.isHidden() || market2.getStarSystem() != null && market2.getStarSystem().hasTag("system_cut_off_from_hyper")) continue;
            float dist = Misc.getDistance(market2.getLocationInHyperspace(), source.getLocationInHyperspace());
            if (dist < 1000.0f) {
                dist = 1000.0f;
            }
            float weight = 10000.0f / dist;
            if (SystemBountyManager.getInstance().isActive(market2)) {
                weight *= 5.0f;
            }
            picker.add(market2, weight);
        }
        market2 = (MarketAPI)picker.pick();
        return market2;
    }

    protected int getMaxFleets() {
        return (int)Global.getSettings().getFloat("maxMercFleets");
    }

    protected String getRouteSourceId() {
        return "mercs_global";
    }

    public void reportAboutToBeDespawnedByRouteManager(RouteManager.RouteData route) {
    }

    public boolean shouldCancelRouteAfterDelayCheck(RouteManager.RouteData route) {
        return false;
    }

    public boolean shouldRepeat(RouteManager.RouteData route) {
        return false;
    }
}

