/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.PersonalFleetScript;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import org.lwjgl.util.vector.Vector2f;

public class PersonalFleetOxanaHyder
extends PersonalFleetScript {
    public PersonalFleetOxanaHyder() {
        super(People.HYDER);
        this.setMinRespawnDelayDays(10.0f);
        this.setMaxRespawnDelayDays(20.0f);
    }

    public CampaignFleetAPI spawnFleet() {
        MarketAPI sindria = Global.getSector().getEconomy().getMarket("sindria");
        FleetCreatorMission m = new FleetCreatorMission(this.random);
        m.beginFleet();
        Vector2f loc = sindria.getLocationInHyperspace();
        m.triggerCreateFleet(HubMissionWithTriggers.FleetSize.HUGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "sindrian_diktat", "patrolLarge", loc);
        m.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.DEFAULT);
        m.triggerSetFleetCommander(this.getPerson());
        m.triggerSetFleetFaction("sindrian_diktat");
        m.triggerSetPatrol();
        m.triggerSetFleetMemoryValue("$sourceMarket", sindria);
        m.triggerFleetSetNoFactionInName();
        m.triggerPatrolAllowTransponderOff();
        m.triggerFleetSetName("Askonia System Defense Armada");
        m.triggerOrderFleetPatrol(sindria.getStarSystem());
        CampaignFleetAPI fleet = m.createFleet();
        fleet.removeScriptsOfClass(MissionFleetAutoDespawn.class);
        sindria.getContainingLocation().addEntity(fleet);
        fleet.setLocation(sindria.getPlanetEntity().getLocation().x, sindria.getPlanetEntity().getLocation().y);
        fleet.setFacing(this.random.nextFloat() * 360.0f);
        return fleet;
    }

    public boolean canSpawnFleetNow() {
        MarketAPI sindria = Global.getSector().getEconomy().getMarket("sindria");
        if (sindria == null || sindria.hasCondition("decivilized")) {
            return false;
        }
        return sindria.getFactionId().equals("sindrian_diktat");
    }

    public boolean shouldScriptBeRemoved() {
        return false;
    }
}

