/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.impl.campaign.fleets.BaseRouteFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.PilgrimageFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.Vector2f;

@Deprecated
public class PilgrimageFleetRouteManager
extends BaseRouteFleetManager
implements FleetEventListener {
    public static final Integer ROUTE_SRC_LOAD = 1;
    public static final Integer ROUTE_TRAVEL_DST = 2;
    public static final Integer ROUTE_DST_UNLOAD = 5;
    public static final Integer ROUTE_DST_LOAD = 6;
    public static final Integer ROUTE_TRAVEL_BACK_WS = 7;
    public static final Integer ROUTE_RESUPPLY_BACK_WS = 8;
    public static final Integer ROUTE_TRAVEL_SRC = 9;
    public static final Integer ROUTE_SRC_UNLOAD = 10;
    public static final String SOURCE_ID = "pilgrimage";
    public static Logger log = Global.getLogger(PilgrimageFleetRouteManager.class);
    protected TimeoutTracker<String> recentlySentPilgrims = new TimeoutTracker();
    protected List<SectorEntityToken> shrines = null;

    public PilgrimageFleetRouteManager() {
        super(1.0f, 14.0f);
    }

    protected Object readResolve() {
        if (this.recentlySentPilgrims == null) {
            this.recentlySentPilgrims = new TimeoutTracker();
        }
        return this;
    }

    public void advance(float amount) {
        if (this.shrines == null) {
            this.shrines = Global.getSector().getEntitiesWithTag("luddic_shrine");
        }
        super.advance(amount);
        float days = Global.getSector().getClock().convertToDays(amount);
        this.recentlySentPilgrims.advance(days);
    }

    protected String getRouteSourceId() {
        return SOURCE_ID;
    }

    protected int getMaxFleets() {
        int numMarkets = Global.getSector().getEconomy().getNumMarkets();
        int maxBasedOnMarkets = numMarkets * 1;
        return Math.min(maxBasedOnMarkets, Global.getSettings().getInt("maxPilgrimageFleets"));
    }

    protected void addRouteFleetIfPossible() {
        MarketAPI from = this.pickSourceMarket();
        SectorEntityToken to = this.pickDestShrine(from);
        if (from != null && to != null) {
            String factionId;
            PilgrimageFleetAssignmentAI.PilgrimageRouteData data = PilgrimageFleetRouteManager.createData(from, to);
            if (data == null) {
                return;
            }
            log.info((Object)("Added shrine pilgrimage fleet route from " + from.getName() + " to " + to.getName()));
            Long seed = Misc.genRandomSeed();
            String id = this.getRouteSourceId();
            RouteManager.OptionalFleetData extra = new RouteManager.OptionalFleetData(from);
            extra.factionId = factionId = from.getFactionId();
            RouteManager.RouteData route = RouteManager.getInstance().addRoute(id, from, seed, extra, this);
            route.setCustom(data);
            float orbitDays = data.size * (0.75f + (float)Math.random() * 0.5f);
            orbitDays *= 30.0f;
            if (orbitDays < 1.0f) {
                orbitDays = 1.0f;
            }
            if (orbitDays > 3.0f) {
                orbitDays = 3.0f;
            }
            route.addSegment(new RouteManager.RouteSegment(ROUTE_SRC_LOAD, orbitDays, from.getPrimaryEntity()));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_TRAVEL_DST, from.getPrimaryEntity(), to));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_DST_UNLOAD, orbitDays * 0.5f, to));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_DST_LOAD, orbitDays * 0.5f, to));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_TRAVEL_SRC, to, from.getPrimaryEntity()));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_SRC_UNLOAD, orbitDays, from.getPrimaryEntity()));
            this.recentlySentPilgrims.add(from.getId(), Global.getSettings().getFloat("minPilgrimSpawnIntervalPerMarket"));
        }
    }

    public MarketAPI pickSourceMarket() {
        WeightedRandomPicker<MarketAPI> markets = new WeightedRandomPicker<MarketAPI>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.isHidden() || !market.hasSpaceport() || this.recentlySentPilgrims.contains(market.getId()) || SharedData.getData().getMarketsWithoutTradeFleetSpawn().contains(market.getId())) continue;
            float distLY = Misc.getDistanceToPlayerLY(market.getPrimaryEntity());
            float mult = 1.0f - Math.min(0.99f, distLY / 10.0f);
            String fid = market.getFactionId();
            if ("luddic_church".equals(fid) || "luddic_path".equals(fid) || "knights_of_ludd".equals(fid)) {
                mult *= 10.0f;
            }
            markets.add(market, (float)market.getSize() * mult);
        }
        return (MarketAPI)markets.pick();
    }

    public SectorEntityToken pickDestShrine(MarketAPI from) {
        if (from == null) {
            return null;
        }
        WeightedRandomPicker<SectorEntityToken> picker = new WeightedRandomPicker<SectorEntityToken>();
        for (SectorEntityToken shrine : new ArrayList<SectorEntityToken>(this.shrines)) {
            boolean realMarket;
            if (!shrine.isAlive()) continue;
            MarketAPI market = shrine.getMarket();
            boolean bl = realMarket = market != null && !market.isPlanetConditionMarketOnly();
            if (realMarket && market.hasCondition("decivilized")) continue;
            float mult = 1.0f;
            if (realMarket) {
                mult = 10.0f * (float)market.getSize();
            }
            picker.add(shrine, mult);
        }
        return (SectorEntityToken)picker.pick();
    }

    public static PilgrimageFleetAssignmentAI.PilgrimageRouteData createData(MarketAPI from, SectorEntityToken to) {
        boolean realMarket;
        PilgrimageFleetAssignmentAI.PilgrimageRouteData data = new PilgrimageFleetAssignmentAI.PilgrimageRouteData();
        data.from = from;
        data.to = to;
        data.factionId = "luddic_church";
        MarketAPI market = to.getMarket();
        boolean bl = realMarket = market != null && !market.isPlanetConditionMarketOnly();
        if (realMarket && market.getFaction().isHostileTo(from.getFaction())) {
            if (market.getFaction().isHostileTo("independent")) {
                data.smuggling = true;
            } else {
                data.factionId = "independent";
            }
        }
        float sizeBasis = realMarket ? (float)(market.getSize() + from.getSize()) : (float)from.getSize() * 0.5f;
        data.size = sizeBasis / 40.0f;
        return data;
    }

    public boolean shouldCancelRouteAfterDelayCheck(RouteManager.RouteData route) {
        return false;
    }

    public CampaignFleetAPI spawnFleet(RouteManager.RouteData route) {
        CampaignFleetAPI fleet;
        Random random = new Random();
        if (route.getSeed() != null) {
            random = new Random(route.getSeed());
        }
        if ((fleet = PilgrimageFleetRouteManager.createPilgrimRouteFleet(route, random)) == null) {
            return null;
        }
        fleet.addEventListener(this);
        fleet.addScript(new PilgrimageFleetAssignmentAI(fleet, route));
        return fleet;
    }

    public static CampaignFleetAPI createPilgrimRouteFleet(RouteManager.RouteData route, Random random) {
        PilgrimageFleetAssignmentAI.PilgrimageRouteData data = (PilgrimageFleetAssignmentAI.PilgrimageRouteData)route.getCustom();
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        m.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.LOWER, data.factionId, "shrinePilgrims", data.from.getLocationInHyperspace());
        m.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.FC_ONLY, HubMissionWithTriggers.OfficerQuality.LOWER);
        m.triggerSetFleetSizeFraction(data.size * 0.5f * (0.5f + random.nextFloat() * 0.5f));
        m.triggerFleetSetNoFactionInName();
        m.triggerSetTraderFleet();
        m.triggerSetFleetComposition(0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        m.triggerSetFleetMemoryValue("$sourceMarket", data.from);
        m.triggerSetFleetMemoryValue("$destShrine", data.to.getId());
        m.triggerSetFleetMemoryValue("$shrinePilgrimFleet", true);
        CampaignFleetAPI fleet = m.createFleet();
        fleet.removeScriptsOfClass(MissionFleetAutoDespawn.class);
        return fleet;
    }

    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        RouteManager.RouteData route = RouteManager.getInstance().getRoute(this.getRouteSourceId(), fleet);
        if (route == null || !(route.getCustom() instanceof PilgrimageFleetAssignmentAI.PilgrimageRouteData)) {
            return;
        }
        if (route.isExpired()) {
            return;
        }
        if (!battle.isPlayerInvolved()) {
            return;
        }
        if (battle.getNonPlayerSideSnapshot().contains(fleet)) {
            PilgrimageFleetAssignmentAI.PilgrimageRouteData data = (PilgrimageFleetAssignmentAI.PilgrimageRouteData)route.getCustom();
            DelayedFleetEncounter e = new DelayedFleetEncounter(new Random(), "luddicPilgrims");
            e.setDelayShort();
            e.setLocationCoreOnly(true, "luddic_church");
            e.beginCreate();
            e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.DEFAULT, "luddic_church", "patrolMedium", new Vector2f());
            e.triggerSetFleetSizeFraction(Math.min(1.0f, data.size * 3.0f));
            e.autoAdjustFleetTypeName();
            e.triggerSetPatrol();
            e.triggerSetStandardAggroInterceptFlags();
            e.triggerSetFleetGenericHailPermanent("PilgrimRevengeHail");
            e.endCreate();
        }
    }

    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
    }

    public boolean shouldRepeat(RouteManager.RouteData route) {
        return false;
    }

    public void reportAboutToBeDespawnedByRouteManager(RouteManager.RouteData route) {
    }
}

