/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class RouteLocationCalculator {
    public static float getTravelDays(SectorEntityToken from, SectorEntityToken to) {
        float dist = 0.0f;
        if (from.getContainingLocation() != to.getContainingLocation()) {
            dist = Misc.getDistance(from.getLocationInHyperspace(), to.getLocationInHyperspace());
            if (!from.isInHyperspace()) {
                dist += 5000.0f;
            }
            if (!to.isInHyperspace()) {
                dist += 5000.0f;
            }
        } else {
            dist = Misc.getDistance(from, to);
            if (from.isSystemCenter() || to.isSystemCenter()) {
                dist = 0.0f;
            }
        }
        float travelTime = dist / 1500.0f;
        return travelTime;
    }

    public static void computeIntervalsAndSetLocation(CampaignFleetAPI fleet, float daysElapsed, float maxDays, boolean onlyComputeIntervals, TaskInterval[] intervals, SectorEntityToken ... sequence) {
        Object to2;
        TaskInterval t;
        float totalDays = 0.0f;
        float totalFraction = 0.0f;
        int i = 0;
        while (i < intervals.length) {
            t = intervals[i];
            if (t.type == IntervalType.TRAVEL_TIME) {
                float travelTime;
                SectorEntityToken from = sequence[i];
                to2 = sequence[i + 1];
                t.value = travelTime = RouteLocationCalculator.getTravelDays(from, (SectorEntityToken)to2);
            }
            if (t.type == IntervalType.FRACTION_OF_REMAINING) {
                totalFraction += t.value;
            } else {
                totalDays += t.value;
            }
            ++i;
        }
        if (totalFraction > 0.0f) {
            float remaining = maxDays - totalDays;
            TaskInterval[] travelTime = intervals;
            int to2 = intervals.length;
            int from = 0;
            while (from < to2) {
                t = travelTime[from];
                if (t.type == IntervalType.FRACTION_OF_REMAINING) {
                    t.value = Math.max(0.1f, t.value / totalFraction * remaining);
                }
                ++from;
            }
        }
        totalDays = 0.0f;
        to2 = intervals;
        int from = intervals.length;
        int t2 = 0;
        while (t2 < from) {
            TaskInterval t3 = to2[t2];
            totalDays += t3.value;
            ++t2;
        }
        if (totalDays > maxDays) {
            to2 = intervals;
            from = intervals.length;
            t2 = 0;
            while (t2 < from) {
                TaskInterval t4 = to2[t2];
                t4.value *= maxDays / totalDays;
                ++t2;
            }
        }
        float soFar = 0.0f;
        float progress = 0.0f;
        int index = 0;
        SectorEntityToken from2 = null;
        SectorEntityToken to3 = null;
        int i2 = 0;
        while (i2 < intervals.length) {
            float curr = intervals[i2].value;
            if (curr < 0.0f) {
                curr = 0.0f;
            }
            if (soFar + curr > daysElapsed && curr > 0.0f) {
                progress = (daysElapsed - soFar) / curr;
                if (progress < 0.0f) {
                    progress = 0.0f;
                }
                if (progress > 1.0f) {
                    progress = 1.0f;
                }
                from2 = sequence[index];
                to3 = sequence[index + 1];
                intervals[i2].value *= 1.0f - progress;
                break;
            }
            soFar += curr;
            intervals[i2].value = 0.0f;
            ++index;
            ++i2;
        }
        if (from2 == null) {
            index = intervals.length - 1;
            from2 = sequence[sequence.length - 2];
            to3 = sequence[sequence.length - 1];
            progress = 1.0f;
        }
        if (onlyComputeIntervals) {
            return;
        }
        RouteLocationCalculator.setLocation(fleet, progress, from2, to3);
    }

    public static int setLocation(CampaignFleetAPI fleet, float daysElapsed, float maxDays, int overflowIndex, boolean onlyAdjustIntervals, float[] intervals, SectorEntityToken ... sequence) {
        float total = 0.0f;
        float[] fArray = intervals;
        int n = intervals.length;
        int n2 = 0;
        while (n2 < n) {
            float curr = fArray[n2];
            total += curr;
            ++n2;
        }
        if (total != maxDays) {
            if (overflowIndex >= 0) {
                float extra = total - maxDays;
                int n3 = overflowIndex;
                intervals[n3] = intervals[n3] - extra;
                if (intervals[overflowIndex] <= 0.0f) {
                    total = maxDays - intervals[overflowIndex];
                    intervals[overflowIndex] = 0.0f;
                    int i = 0;
                    while (i < intervals.length) {
                        int n4 = i++;
                        intervals[n4] = intervals[n4] * (maxDays / total);
                    }
                }
            } else {
                int i = 0;
                while (i < intervals.length) {
                    int n5 = i++;
                    intervals[n5] = intervals[n5] * (maxDays / total);
                }
            }
        }
        float soFar = 0.0f;
        float progress = 0.0f;
        int index = 0;
        SectorEntityToken from = null;
        SectorEntityToken to = null;
        int i = 0;
        while (i < intervals.length) {
            float curr = intervals[i];
            if (curr < 0.0f) {
                curr = 0.0f;
            }
            if (soFar + curr > daysElapsed && curr > 0.0f) {
                progress = (daysElapsed - soFar) / curr;
                if (progress < 0.0f) {
                    progress = 0.0f;
                }
                if (progress > 1.0f) {
                    progress = 1.0f;
                }
                from = sequence[index];
                to = sequence[index + 1];
                int n6 = i;
                intervals[n6] = intervals[n6] * (1.0f - progress);
                break;
            }
            soFar += curr;
            intervals[i] = 0.0f;
            ++index;
            ++i;
        }
        if (from == null) {
            index = intervals.length - 1;
            from = sequence[sequence.length - 2];
            to = sequence[sequence.length - 1];
            progress = 1.0f;
        }
        if (onlyAdjustIntervals) {
            return index;
        }
        RouteLocationCalculator.setLocation(fleet, progress, from, to);
        return index;
    }

    /*
     * Unable to fully structure code
     */
    public static void setLocation(CampaignFleetAPI fleet, float progress, SectorEntityToken from, SectorEntityToken to) {
        block29: {
            block31: {
                block30: {
                    block28: {
                        if (progress < 0.0f) {
                            progress = 0.0f;
                        }
                        if (progress > 1.0f) {
                            progress = 1.0f;
                        }
                        if (to == null) {
                            to = from;
                        }
                        if (from == null) {
                            from = to;
                        }
                        if (from == null && to == null) {
                            return;
                        }
                        varianceMult = RouteLocationCalculator.getVarianceMult(progress);
                        forSystemCenterCheck = null;
                        conLoc = null;
                        loc = null;
                        if (from != to) break block28;
                        conLoc = from.getContainingLocation();
                        forSystemCenterCheck = from;
                        loc = !conLoc.isHyperspace() ? (progress > 0.03f ? Misc.getPointAtRadius(from.getLocation(), from.getRadius() + 100.0f + (float)Math.random() * 100.0f) : new Vector2f((ReadableVector2f)from.getLocation())) : Misc.getPointWithinRadius(from.getLocation(), 100.0f + 900.0f * varianceMult);
                        break block29;
                    }
                    if (!from.isInHyperspace() || !to.isInHyperspace()) break block30;
                    conLoc = from.getContainingLocation();
                    loc = Misc.interpolateVector(from.getLocation(), to.getLocation(), progress);
                    loc = Misc.getPointWithinRadius(loc, 100.0f + 900.0f * varianceMult);
                    break block29;
                }
                if (from.getContainingLocation() != to.getContainingLocation()) break block31;
                conLoc = from.getContainingLocation();
                if (from.isSystemCenter()) {
                    forSystemCenterCheck = from;
                }
                if (to.isSystemCenter()) {
                    forSystemCenterCheck = to;
                }
                loc = Misc.interpolateVector(from.getLocation(), to.getLocation(), progress);
                if (!(conLoc instanceof StarSystemAPI)) ** GOTO lbl-1000
                v0 = new Vector2f();
                if (Misc.getDistance(loc, v0) < 2000.0f) {
                    loc = Misc.getPointAtRadius(new Vector2f(), 2000.0f);
                } else lbl-1000:
                // 2 sources

                {
                    loc = Misc.getPointWithinRadius(loc, 100.0f + 900.0f * varianceMult);
                }
                break block29;
            }
            if (from.isInHyperspace() != to.isInHyperspace()) {
                inSystem = from;
                inHyper = to;
                p = progress;
                if (from.isInHyperspace()) {
                    inSystem = to;
                    inHyper = from;
                    p = 1.0f - progress;
                }
                jp = RouteLocationCalculator.findJumpPointToUse(fleet, inSystem);
                d1 = Misc.getDistance(inSystem, jp);
                d2 = Misc.getDistance(jp.getLocationInHyperspace(), inHyper.getLocation());
                if (d1 < 1.0f) {
                    d1 = 1.0f;
                }
                if (d2 < 1.0f) {
                    d2 = 1.0f;
                }
                if (p < (t = d1 / (d1 + d2))) {
                    conLoc = inSystem.getContainingLocation();
                    forSystemCenterCheck = inSystem;
                    loc = Misc.interpolateVector(inSystem.getLocation(), jp.getLocation(), p / t);
                    varianceMult = RouteLocationCalculator.getVarianceMult(p / t);
                } else {
                    conLoc = inHyper.getContainingLocation();
                    loc = Misc.interpolateVector(Misc.getSystemJumpPointHyperExitLocation(jp), inHyper.getLocation(), (p - t) / (1.0f - t));
                    varianceMult = RouteLocationCalculator.getVarianceMult((p - t) / (1.0f - t));
                }
                loc = Misc.getPointWithinRadius(loc, 100.0f + 900.0f * varianceMult);
            } else if (from.getContainingLocation() != to.getContainingLocation()) {
                jp1 = RouteLocationCalculator.findJumpPointToUse(fleet, from);
                jp2 = RouteLocationCalculator.findJumpPointToUse(fleet, to);
                d1 = Misc.getDistance(from, jp1);
                d2 = Misc.getDistance(Misc.getSystemJumpPointHyperExitLocation(jp1), Misc.getSystemJumpPointHyperExitLocation(jp1));
                d3 = Misc.getDistance(jp2, to);
                if (d1 < 1.0f) {
                    d1 = 1.0f;
                }
                if (d2 < 1.0f) {
                    d2 = 1.0f;
                }
                if (d3 < 1.0f) {
                    d3 = 1.0f;
                }
                t1 = d1 / (d1 + d2 + d3);
                t2 = (d1 + d2) / (d1 + d2 + d3);
                if (progress < t1) {
                    conLoc = from.getContainingLocation();
                    forSystemCenterCheck = from;
                    loc = Misc.interpolateVector(from.getLocation(), jp1.getLocation(), progress / t1);
                    varianceMult = RouteLocationCalculator.getVarianceMult(progress / t1);
                } else if (progress < t2) {
                    conLoc = Global.getSector().getHyperspace();
                    loc = Misc.interpolateVector(Misc.getSystemJumpPointHyperExitLocation(jp1), Misc.getSystemJumpPointHyperExitLocation(jp2), (progress - t1) / (t2 - t1));
                    varianceMult = RouteLocationCalculator.getVarianceMult((progress - t1) / (t2 - t1));
                } else {
                    conLoc = to.getContainingLocation();
                    forSystemCenterCheck = to;
                    loc = Misc.interpolateVector(jp2.getLocation(), to.getLocation(), (progress - t2) / (1.0f - t2));
                    varianceMult = RouteLocationCalculator.getVarianceMult((progress - t2) / (1.0f - t2));
                }
                loc = Misc.getPointWithinRadius(loc, 100.0f + 900.0f * varianceMult);
            }
        }
        if (forSystemCenterCheck != null && forSystemCenterCheck.isSystemCenter() && conLoc == forSystemCenterCheck.getContainingLocation()) {
            loc = Misc.getPointAtRadius(forSystemCenterCheck.getLocation(), forSystemCenterCheck.getRadius() + 3000.0f + (float)Math.random() * 2000.0f);
        }
        if (conLoc == null) {
            conLoc = from.getContainingLocation();
        }
        if (loc == null) {
            loc = new Vector2f((ReadableVector2f)from.getLocation());
        }
        if (fleet.getContainingLocation() != conLoc) {
            fleet.getContainingLocation().removeEntity(fleet);
            conLoc.addEntity(fleet);
        }
        fleet.setLocation(loc.x, loc.y);
    }

    public static float getVarianceMult(float p) {
        float varianceMult = 1.0f;
        if (p < 0.1f) {
            varianceMult = p / 0.1f;
        } else if (p > 0.9f) {
            varianceMult = (1.0f - p) / 0.1f;
        }
        return varianceMult;
    }

    public static JumpPointAPI findJumpPointToUse(CampaignFleetAPI fleet, SectorEntityToken from) {
        return RouteLocationCalculator.findJumpPointToUse(fleet.getFaction(), from);
    }

    public static JumpPointAPI findJumpPointToUse(FactionAPI faction, SectorEntityToken from) {
        float min = Float.MAX_VALUE;
        JumpPointAPI result = null;
        float fringeMax = 0.0f;
        JumpPointAPI fringe = null;
        LocationAPI location = from.getContainingLocation();
        List points = location.getEntities(JumpPointAPI.class);
        for (JumpPointAPI curr : points) {
            float dist = Misc.getDistance(from.getLocation(), curr.getLocation());
            if (dist < min) {
                min = dist;
                result = curr;
            }
            if (!((dist = Misc.getDistance(new Vector2f(), curr.getLocation())) > fringeMax)) continue;
            fringe = curr;
            fringeMax = dist;
        }
        if (from.getContainingLocation() instanceof StarSystemAPI) {
            boolean useFringeOnly;
            StarSystemAPI system = (StarSystemAPI)from.getContainingLocation();
            boolean bl = useFringeOnly = !RouteLocationCalculator.isInControlOfSystemOrEven(faction, system);
            if (useFringeOnly && fringe != null) {
                return fringe;
            }
        }
        return result;
    }

    public static boolean isInControlOfSystemOrEven(FactionAPI faction, StarSystemAPI system) {
        List<MarketAPI> markets = Misc.getMarketsInLocation(system);
        int hostileMax = 0;
        int ourMax = 0;
        for (MarketAPI market : markets) {
            if (market.getFaction().isHostileTo(faction)) {
                hostileMax = Math.max(hostileMax, market.getSize());
                continue;
            }
            if (market.getFaction() != faction) continue;
            ourMax = Math.max(ourMax, market.getSize());
        }
        boolean inControl = ourMax >= hostileMax;
        return inControl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IntervalType {
        DAYS,
        TRAVEL_TIME,
        FRACTION_OF_REMAINING;

    }

    public static class TaskInterval {
        public IntervalType type;
        public float value;

        public TaskInterval(IntervalType type, float value) {
            this.type = type;
            this.value = value;
        }

        public TaskInterval(IntervalType type) {
            this.type = type;
        }

        public static TaskInterval days(float days) {
            return new TaskInterval(IntervalType.DAYS, days);
        }

        public static TaskInterval travel() {
            return new TaskInterval(IntervalType.TRAVEL_TIME, 0.0f);
        }

        public static TaskInterval remaining(float fraction) {
            return new TaskInterval(IntervalType.FRACTION_OF_REMAINING, fraction);
        }
    }
}

