/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.impl.campaign.fleets.BaseRouteFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.fleets.misc.MiscAcademyFleetCreator;
import com.fs.starfarer.api.impl.campaign.fleets.misc.MiscFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.fleets.misc.MiscFleetCreatorPlugin;
import com.fs.starfarer.api.impl.campaign.fleets.misc.MiscPilgrimFleetCreator;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiscFleetRouteManager
extends BaseRouteFleetManager
implements FleetEventListener {
    public static List<MiscFleetCreatorPlugin> CREATORS = new ArrayList<MiscFleetCreatorPlugin>();
    public static final Integer ROUTE_SRC_LOAD;
    public static final Integer ROUTE_TRAVEL_DST;
    public static final Integer ROUTE_DST_UNLOAD;
    public static final Integer ROUTE_DST_LOAD;
    public static final Integer ROUTE_TRAVEL_BACK_WS;
    public static final Integer ROUTE_RESUPPLY_BACK_WS;
    public static final Integer ROUTE_TRAVEL_SRC;
    public static final Integer ROUTE_SRC_UNLOAD;
    public static final String SOURCE_ID = "misc_fleet_";
    public static Logger log;
    protected Map<String, TimeoutTracker<String>> recentlySent = new LinkedHashMap<String, TimeoutTracker<String>>();
    protected Random random = new Random();
    protected transient LinkedHashMap data = new LinkedHashMap();

    static {
        CREATORS.add(new MiscPilgrimFleetCreator());
        CREATORS.add(new MiscAcademyFleetCreator());
        ROUTE_SRC_LOAD = 1;
        ROUTE_TRAVEL_DST = 2;
        ROUTE_DST_UNLOAD = 5;
        ROUTE_DST_LOAD = 6;
        ROUTE_TRAVEL_BACK_WS = 7;
        ROUTE_RESUPPLY_BACK_WS = 8;
        ROUTE_TRAVEL_SRC = 9;
        ROUTE_SRC_UNLOAD = 10;
        log = Global.getLogger(MiscFleetRouteManager.class);
    }

    public MiscFleetRouteManager() {
        super(1.0f, 14.0f);
        float min = Global.getSettings().getFloatFromArray("miscSpawnInterval", 0);
        float max = Global.getSettings().getFloatFromArray("miscSpawnInterval", 1);
        this.interval = new IntervalUtil(min, max);
    }

    protected Object readResolve() {
        if (this.recentlySent == null) {
            this.recentlySent = new LinkedHashMap<String, TimeoutTracker<String>>();
        }
        if (this.data == null) {
            this.data = new LinkedHashMap();
        }
        return this;
    }

    public Random getRandom() {
        return this.random;
    }

    public TimeoutTracker<String> getTimeout(String creatorId) {
        TimeoutTracker<String> result = this.recentlySent.get(creatorId);
        if (result == null) {
            result = new TimeoutTracker();
            this.recentlySent.put(creatorId, result);
        }
        return result;
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        float days = Global.getSector().getClock().convertToDays(amount);
        for (TimeoutTracker<String> curr : this.recentlySent.values()) {
            curr.advance(days);
        }
    }

    @Override
    protected String getRouteSourceId() {
        return SOURCE_ID;
    }

    @Override
    protected int getMaxFleets() {
        int numMarkets = Global.getSector().getEconomy().getNumMarkets();
        int maxBasedOnMarkets = numMarkets * 1;
        return Math.min(maxBasedOnMarkets, Global.getSettings().getInt("maxMiscFleets"));
    }

    @Override
    protected void addRouteFleetIfPossible() {
        WeightedRandomPicker<MiscFleetCreatorPlugin> picker = new WeightedRandomPicker<MiscFleetCreatorPlugin>(this.random);
        for (MiscFleetCreatorPlugin curr : CREATORS) {
            int count = 0;
            for (RouteManager.RouteData route : RouteManager.getInstance().getRoutesForSource(this.getRouteSourceId())) {
                if (!(route.getCustom() instanceof MiscRouteData)) continue;
                MiscRouteData data = (MiscRouteData)route.getCustom();
                if (!curr.getId().equals(data.creatorId)) continue;
                ++count;
            }
            if (count >= curr.getMaxFleetsForThisCreator()) continue;
            picker.add(curr, curr.getFrequency());
        }
        MiscFleetCreatorPlugin creator = (MiscFleetCreatorPlugin)picker.pick();
        if (creator == null) {
            return;
        }
        MiscRouteData params = creator.createRouteParams(this, this.random);
        if (params != null) {
            MarketAPI from = params.from;
            SectorEntityToken to = params.to;
            log.info((Object)("Created misc [" + creator.getId() + "] " + from.getName() + " to " + to.getName()));
            Long seed = this.random.nextLong();
            String id = this.getRouteSourceId();
            RouteManager.OptionalFleetData extra = new RouteManager.OptionalFleetData(from);
            extra.factionId = params.factionId;
            RouteManager.RouteData route = RouteManager.getInstance().addRoute(id, from, seed, extra, this);
            route.setCustom(params);
            float orbitDays = params.size * (0.75f + this.random.nextFloat() * 0.5f);
            orbitDays *= 30.0f;
            if (orbitDays < 1.0f) {
                orbitDays = 1.0f;
            }
            if (orbitDays > 3.0f) {
                orbitDays = 3.0f;
            }
            route.addSegment(new RouteManager.RouteSegment(ROUTE_SRC_LOAD, orbitDays, from.getPrimaryEntity()));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_TRAVEL_DST, from.getPrimaryEntity(), to));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_DST_UNLOAD, orbitDays * 0.5f, to));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_DST_LOAD, orbitDays * 0.5f, to));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_TRAVEL_SRC, to, from.getPrimaryEntity()));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_SRC_UNLOAD, orbitDays, from.getPrimaryEntity()));
            float min = Global.getSettings().getFloatFromArray("miscSpawnTimeoutPerMarket", 0);
            float max = Global.getSettings().getFloatFromArray("miscSpawnTimeoutPerMarket", 1);
            float timeout = min + (max - min) * this.random.nextFloat();
            this.getTimeout(creator.getId()).add(from.getId(), timeout);
        }
    }

    @Override
    public boolean shouldCancelRouteAfterDelayCheck(RouteManager.RouteData route) {
        return false;
    }

    public static MiscFleetCreatorPlugin getCreator(String id) {
        for (MiscFleetCreatorPlugin curr : CREATORS) {
            if (!curr.getId().equals(id)) continue;
            return curr;
        }
        return null;
    }

    @Override
    public CampaignFleetAPI spawnFleet(RouteManager.RouteData route) {
        Random random = this.random;
        if (route.getSeed() != null) {
            random = new Random(route.getSeed());
        }
        MiscRouteData data = (MiscRouteData)route.getCustom();
        MiscFleetCreatorPlugin curr = MiscFleetRouteManager.getCreator(data.creatorId);
        if (curr != null) {
            CampaignFleetAPI fleet = curr.createFleet(this, route, random);
            if (fleet != null) {
                fleet.addEventListener(this);
                fleet.addScript(new MiscFleetAssignmentAI(fleet, route));
            }
            return fleet;
        }
        return null;
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        RouteManager.RouteData route = RouteManager.getInstance().getRoute(this.getRouteSourceId(), fleet);
        if (route == null || !(route.getCustom() instanceof MiscRouteData)) {
            return;
        }
        if (!battle.isPlayerInvolved()) {
            return;
        }
        MiscRouteData data = (MiscRouteData)route.getCustom();
        MiscFleetCreatorPlugin curr = MiscFleetRouteManager.getCreator(data.creatorId);
        if (curr != null) {
            curr.reportBattleOccurred(this, fleet, primaryWinner, battle);
        }
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        RouteManager.RouteData route = RouteManager.getInstance().getRoute(this.getRouteSourceId(), fleet);
        if (route == null || !(route.getCustom() instanceof MiscRouteData)) {
            return;
        }
        MiscRouteData data = (MiscRouteData)route.getCustom();
        MiscFleetCreatorPlugin curr = MiscFleetRouteManager.getCreator(data.creatorId);
        if (curr != null) {
            curr.reportFleetDespawnedToListener(this, fleet, reason, param);
        }
    }

    @Override
    public boolean shouldRepeat(RouteManager.RouteData route) {
        return false;
    }

    @Override
    public void reportAboutToBeDespawnedByRouteManager(RouteManager.RouteData route) {
    }

    public LinkedHashMap getData() {
        return this.data;
    }

    public static class MiscRouteData {
        public String creatorId;
        public boolean smuggling = false;
        public MarketAPI from;
        public SectorEntityToken to;
        public float size;
        public String factionId;
        public Object custom;

        public MiscRouteData(String creatorId) {
            this.creatorId = creatorId;
        }
    }
}

