/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.impl.campaign.ghosts.types.NoGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.types.ZigguratGhost;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class GhostFrequencies {
    public static String ZIGGURAT = "ziggurat";

    public static float getNoGhostFrequency(SensorGhostManager manager) {
        if (manager.isSpawnTriggeredBySensorBurst()) {
            return 0.0f;
        }
        float total = 0.0f;
        for (SensorGhostCreator c : SensorGhostManager.CREATORS) {
            if (c instanceof NoGhostCreator) continue;
            float f = c.getFrequency(manager);
            total += f;
        }
        float mult = 0.5f + GhostFrequencies.getCoreFactor() * 5.0f;
        return Math.max(10.0f, total) * mult;
    }

    public static float getChargerFrequency(SensorGhostManager manager) {
        return 10.0f * GhostFrequencies.getNotInCoreFactor() * GhostFrequencies.getSBFactor(manager, 1.0f, 2.0f);
    }

    public static float getEncounterTricksterFrequency(SensorGhostManager manager) {
        return 10.0f * GhostFrequencies.getNotInCoreFactor() * (0.5f + 0.5f * GhostFrequencies.getFringeFactor()) * GhostFrequencies.getSBFactor(manager, 1.0f, 2.0f);
    }

    public static float getEchoFrequency(SensorGhostManager manager) {
        return 5.0f * GhostFrequencies.getSBFactor(manager, 1.0f, 5.0f);
    }

    public static float getGuideFrequency(SensorGhostManager manager) {
        return 10.0f * GhostFrequencies.getNotInCoreFactor() * GhostFrequencies.getSBFactor(manager, 1.0f, 2.0f);
    }

    public static float getLeviathanCalfFrequency(SensorGhostManager manager) {
        return 5.0f * (GhostFrequencies.getNotInCoreFactor() + GhostFrequencies.getFringeFactor()) * GhostFrequencies.getSBFactor(manager, 1.0f, 0.0f);
    }

    public static float getLeviathanFrequency(SensorGhostManager manager) {
        return 5.0f * (GhostFrequencies.getNotInCoreFactor() + GhostFrequencies.getFringeFactor()) * GhostFrequencies.getSBFactor(manager, 1.0f, 0.0f);
    }

    public static float getMinnowFrequency(SensorGhostManager manager) {
        return 10.0f * GhostFrequencies.getNotInCoreFactor() * (0.5f + 0.5f * GhostFrequencies.getFringeFactor()) * GhostFrequencies.getSBFactor(manager, 1.0f, 0.0f);
    }

    public static float getRacerFrequency(SensorGhostManager manager) {
        return 10.0f * GhostFrequencies.getNotInCoreFactor();
    }

    public static float getRemnantFrequency(SensorGhostManager manager) {
        return 1.0f * GhostFrequencies.getFringeFactor();
    }

    public static float getRemoraFrequency(SensorGhostManager manager) {
        return 10.0f * GhostFrequencies.getNotInCoreFactor() * (0.25f + 0.75f * GhostFrequencies.getFringeFactor()) * GhostFrequencies.getSBFactor(manager, 1.0f, 4.0f);
    }

    public static float getShipFrequency(SensorGhostManager manager) {
        return 2.0f * GhostFrequencies.getFringeFactor();
    }

    public static float getStormcallerFrequency(SensorGhostManager manager) {
        return 5.0f * GhostFrequencies.getNotInCoreFactor() * (0.5f + 0.5f * GhostFrequencies.getFringeFactor()) * GhostFrequencies.getSBFactor(manager, 1.0f, 0.0f);
    }

    public static float getStormTricksterFrequency(SensorGhostManager manager) {
        return 5.0f * GhostFrequencies.getNotInCoreFactor() * (0.25f + 0.75f * GhostFrequencies.getFringeFactor()) * GhostFrequencies.getSBFactor(manager, 1.0f, 2.0f);
    }

    public static float getZigguratFrequency(SensorGhostManager manager) {
        if (manager.hasGhostOfClass(ZigguratGhost.class)) {
            return 0.0f;
        }
        String id = ZIGGURAT;
        boolean found = false;
        for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
            if (!member.getHullSpec().getBaseHullId().equals(id)) continue;
            found = true;
            break;
        }
        if (!found) {
            return 0.0f;
        }
        return 10000.0f;
    }

    public static float getFringeFactor() {
        Vector2f loc = Global.getSector().getPlayerFleet().getLocationInHyperspace();
        float sw = Global.getSettings().getFloat("sectorWidth");
        float sh = Global.getSettings().getFloat("sectorHeight");
        float f = 0.8f;
        float a = sw * 0.5f * f;
        float b = sh * 0.5f * f;
        float x = loc.x;
        float y = loc.y;
        float test = x * x / (a * a) + y * y / (b * b);
        float result = 0.0f;
        result = test >= 1.0f ? 1.0f : (test <= 0.75f ? 0.0f : (test - 0.75f) / 0.25f);
        return result;
    }

    public static float getSBFactor(SensorGhostManager manager, float factorIfNoBurst, float factorIfBurst) {
        if (manager.isSpawnTriggeredBySensorBurst()) {
            return factorIfBurst;
        }
        return factorIfNoBurst;
    }

    public static boolean isInsideCore() {
        return GhostFrequencies.getCoreFactor() >= 1.0f;
    }

    public static float getNotInFringeFactor() {
        return 1.0f - GhostFrequencies.getFringeFactor();
    }

    public static float getNotInCoreFactor() {
        return 1.0f - GhostFrequencies.getCoreFactor();
    }

    public static float getCoreFactor() {
        Vector2f loc = Global.getSector().getPlayerFleet().getLocationInHyperspace();
        Vector2f min = Misc.getCoreMin();
        Vector2f max = Misc.getCoreMax();
        Vector2f center = Misc.getCoreCenter();
        float f = 1.4f;
        float a = (max.x - min.x) * 0.5f * f;
        float b = (max.y - min.y) * 0.5f * f;
        float x = loc.x - center.x;
        float y = loc.y - center.y;
        float test = x * x / (a * a) + y * y / (b * b);
        float result = 0.0f;
        result = test >= 1.0f ? 0.0f : (test <= 0.75f ? 1.0f : 1.0f - (test - 0.75f) / 0.25f);
        return result;
    }
}

