/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.GhostFrequencies;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.impl.campaign.ghosts.types.LeviathanCalfGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.types.LeviathanGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.types.RemoraGhost;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeviathanGhostCreator
extends BaseSensorGhostCreator {
    @Override
    public List<SensorGhost> createGhost(SensorGhostManager manager) {
        if (!Global.getSector().getCurrentLocation().isHyperspace()) {
            return null;
        }
        float r = manager.getRandom().nextFloat();
        boolean withCalf = false;
        int numRemora = 0;
        if (r < 0.1f) {
            withCalf = true;
        } else if (r < 0.3f) {
            numRemora = 1 + manager.getRandom().nextInt(3);
        }
        ArrayList<SensorGhost> result = new ArrayList<SensorGhost>();
        LeviathanGhost g = new LeviathanGhost(manager, 0);
        if (g.isCreationFailed()) {
            return null;
        }
        result.add(g);
        if (withCalf) {
            LeviathanCalfGhost c = new LeviathanCalfGhost(manager, g.getEntity());
            result.add(c);
        }
        if (numRemora > 0) {
            int i = 0;
            while (i < numRemora) {
                RemoraGhost remora = new RemoraGhost(manager, g.getEntity(), 1000.0f);
                if (!remora.isCreationFailed()) {
                    result.add(remora);
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public float getFrequency(SensorGhostManager manager) {
        return GhostFrequencies.getLeviathanFrequency(manager);
    }

    @Override
    public boolean canSpawnWhilePlayerInOrNearSlipstream() {
        return true;
    }
}

