/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.GhostFrequencies;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.impl.campaign.ghosts.types.StormTricksterGhost;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StormTricksterGhostCreator
extends BaseSensorGhostCreator {
    @Override
    public List<SensorGhost> createGhost(SensorGhostManager manager) {
        if (!Global.getSector().getCurrentLocation().isHyperspace()) {
            return null;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        Vector2f loc = StormTricksterGhostCreator.findDeepHyperspaceArea(pf.getLocation(), 2000.0f, 3000.0f, 1500.0f, manager.getRandom());
        if (loc == null) {
            return null;
        }
        SectorEntityToken target = Global.getSector().getHyperspace().createToken(loc);
        ArrayList<SensorGhost> result = new ArrayList<SensorGhost>();
        StormTricksterGhost g = new StormTricksterGhost(manager, target);
        if (g.isCreationFailed()) {
            return null;
        }
        result.add(g);
        return result;
    }

    @Override
    public float getFrequency(SensorGhostManager manager) {
        return GhostFrequencies.getStormTricksterFrequency(manager);
    }
}

