/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.graid;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.graid.BaseGroundRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;

public class AICoreGroundRaidObjectivePluginImpl
extends BaseGroundRaidObjectivePluginImpl {
    public AICoreGroundRaidObjectivePluginImpl(MarketAPI market, String id, Industry source) {
        super(market, id);
        this.setSource(source);
    }

    public void setSource(Industry source) {
        super.setSource(source);
        MarketCMD.RaidDangerLevel level = this.getDangerLevel();
        int marines = level.marineTokens;
        if (source != null) {
            marines = source.adjustMarineTokensToRaidItem(this.id, null, marines);
        }
        this.setMarinesRequired(marines);
    }

    public float getQuantity(int marines) {
        return 1.0f;
    }

    public int getValue(int marines) {
        return (int)(this.getQuantity(marines) * this.getCommoditySpec().getBasePrice());
    }

    public int getCargoSpaceNeeded() {
        return (int)this.getCommoditySpec().getCargoSpace();
    }

    public int getFuelSpaceNeeded() {
        return 0;
    }

    public int getProjectedCreditsValue() {
        return (int)this.getCommoditySpec().getBasePrice();
    }

    public CommoditySpecAPI getCommoditySpec() {
        return Global.getSettings().getCommoditySpec(this.id);
    }

    public MarketCMD.RaidDangerLevel getDangerLevel() {
        MarketCMD.RaidDangerLevel level = this.getCommoditySpec().getBaseDanger();
        if (this.source != null) {
            level = this.source.adjustItemDangerLevel(this.id, null, level);
        }
        return level;
    }

    public float getQuantitySortValue() {
        CommoditySpecAPI spec = this.getCommoditySpec();
        float add = 0.0f;
        if (spec != null) {
            add = spec.getOrder();
        }
        return 1.0E7f + add;
    }

    public String getName() {
        return this.getCommoditySpec().getName();
    }

    public CargoStackAPI getStackForIcon() {
        CargoStackAPI stack = Global.getFactory().createCargoStack(CargoAPI.CargoItemType.RESOURCES, this.getId(), null);
        return stack;
    }

    public int performRaid(CargoAPI loot, Random random, float lootMult, TextPanelAPI text) {
        if (this.marinesAssigned <= 0) {
            return 0;
        }
        if (this.source != null && (this.getId() == null || this.getId().equals(this.source.getAICoreId()))) {
            this.source.setAICoreId(null);
        }
        loot.addCommodity(this.getId(), 1.0f);
        int xpGained = (int)(1.0f * this.getCommoditySpec().getBasePrice() * 0.2f);
        return xpGained;
    }

    public boolean hasTooltip() {
        return true;
    }

    public void createTooltip(TooltipMakerAPI t, boolean expanded) {
        float opad = 10.0f;
        float pad = 3.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color good = Misc.getPositiveHighlightColor();
        Description desc = Global.getSettings().getDescription(this.id, Description.Type.RESOURCE);
        t.addPara(desc.getText1FirstPara(), 0.0f);
        t.addPara("Base value: %s per unit", opad, h, Misc.getDGSCredits(this.getCommoditySpec().getBasePrice()));
    }
}

