/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.graid;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.SpecialItemSpecAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.graid.BaseGroundRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;

public class SpecialItemRaidObjectivePluginImpl
extends BaseGroundRaidObjectivePluginImpl {
    protected String data;

    public SpecialItemRaidObjectivePluginImpl(MarketAPI market, String id, String data, Industry source) {
        super(market, id);
        this.data = data;
        this.setSource(source);
    }

    public void setSource(Industry source) {
        super.setSource(source);
        MarketCMD.RaidDangerLevel level = this.getDangerLevel();
        int marines = level.marineTokens;
        if (source != null) {
            marines = source.adjustMarineTokensToRaidItem(this.id, this.data, marines);
        }
        this.setMarinesRequired(marines);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public float getQuantity(int marines) {
        return 1.0f;
    }

    public int getValue(int marines) {
        return (int)(this.getQuantity(marines) * this.getItemSpec().getBasePrice());
    }

    public int getCargoSpaceNeeded() {
        return (int)this.getItemSpec().getCargoSpace();
    }

    public int getFuelSpaceNeeded() {
        return 0;
    }

    public int getProjectedCreditsValue() {
        return (int)this.getItemSpec().getBasePrice();
    }

    public int getDeficitCaused() {
        return 0;
    }

    public SpecialItemSpecAPI getItemSpec() {
        return Global.getSettings().getSpecialItemSpec(this.id);
    }

    public MarketCMD.RaidDangerLevel getDangerLevel() {
        MarketCMD.RaidDangerLevel level = this.getItemSpec().getBaseDanger();
        if (this.source != null) {
            level = this.source.adjustItemDangerLevel(this.id, null, level);
        }
        return level;
    }

    public float getQuantitySortValue() {
        SpecialItemSpecAPI spec = this.getItemSpec();
        float add = 0.0f;
        if (spec != null) {
            add = spec.getOrder();
        }
        return 1.0E7f + add + 1000.0f;
    }

    public String getName() {
        return this.getItemSpec().getName();
    }

    public CargoStackAPI getStackForIcon() {
        CargoStackAPI stack = Global.getFactory().createCargoStack(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData(this.getId(), this.getData()), null);
        return stack;
    }

    public int performRaid(CargoAPI loot, Random random, float lootMult, TextPanelAPI text) {
        if (this.marinesAssigned <= 0) {
            return 0;
        }
        if (this.source != null) {
            SpecialItemData sid = this.source.getSpecialItem();
            if ((this.getId() == null || this.getId().equals(sid.getId())) && (this.getData() == null || this.getData().equals(sid.getData()))) {
                this.source.setSpecialItem(null);
            }
        }
        loot.addSpecial(new SpecialItemData(this.getId(), this.getData()), 1.0f);
        int xpGained = (int)(1.0f * this.getItemSpec().getBasePrice() * 0.2f);
        return xpGained;
    }

    public boolean hasTooltip() {
        return true;
    }

    public void createTooltip(TooltipMakerAPI t, boolean expanded) {
        float opad = 10.0f;
        float pad = 3.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color good = Misc.getPositiveHighlightColor();
        t.addPara(this.getItemSpec().getDescFirstPara(), 0.0f);
        t.addPara("Base value: %s per unit", opad, h, Misc.getDGSCredits(this.getItemSpec().getBasePrice()));
    }
}

