/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseMissionIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BreadcrumbSpecial;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzeEntityMissionIntel
extends BaseMissionIntel {
    public static Logger log = Global.getLogger(AnalyzeEntityMissionIntel.class);
    protected int reward;
    protected FactionAPI faction;
    protected MarketAPI market;
    protected SectorEntityToken entity;

    public AnalyzeEntityMissionIntel(SectorEntityToken entity) {
        this.entity = entity;
        WeightedRandomPicker<MarketAPI> marketPicker = new WeightedRandomPicker<MarketAPI>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.isHidden() || market.getFaction().isPlayerFaction()) continue;
            marketPicker.add(market, market.getSize());
        }
        this.market = (MarketAPI)marketPicker.pick();
        if (this.market == null) {
            this.endImmediately();
            return;
        }
        this.faction = this.market.getFaction();
        if (!this.market.getFaction().isHostileTo("independent") && (float)Math.random() > 0.67f) {
            this.faction = Global.getSector().getFaction("independent");
        }
        this.setDuration(Float.valueOf(120.0f));
        this.reward = (int)Misc.getDistance(new Vector2f(), entity.getLocationInHyperspace());
        this.reward = 20000 + this.reward / 10000 * 10000;
        if (this.reward < 10000) {
            this.reward = 10000;
        }
        log.info((Object)("Created AnalyzeEntityMissionIntel: " + entity.getName() + ", faction: " + this.faction.getDisplayName()));
        this.initRandomCancel();
        this.setPostingLocation(this.market.getPrimaryEntity());
        Global.getSector().getIntelManager().queueIntel(this);
    }

    @Override
    public void notifyPlayerAboutToOpenIntelScreen() {
        if (this.isPosted() && (!this.entity.isAlive() || this.entity.hasTag("non_clickable"))) {
            this.cancel();
        }
    }

    public SectorEntityToken getEntity() {
        return this.entity;
    }

    @Override
    protected BaseMissionIntel.MissionResult createAbandonedResult(boolean withPenalty) {
        if (withPenalty) {
            CoreReputationPlugin.MissionCompletionRep rep = new CoreReputationPlugin.MissionCompletionRep(0.05f, RepLevel.WELCOMING, -0.01f, RepLevel.INHOSPITABLE);
            ReputationActionResponsePlugin.ReputationAdjustmentResult result = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_FAILURE, (Object)rep, null, null, true, false), this.faction.getId());
            return new BaseMissionIntel.MissionResult(0, result);
        }
        return new BaseMissionIntel.MissionResult();
    }

    @Override
    protected BaseMissionIntel.MissionResult createTimeRanOutFailedResult() {
        return this.createAbandonedResult(true);
    }

    @Override
    public void missionAccepted() {
        this.entity.getMemoryWithoutUpdate().set("$aem_target", true, this.getDuration().floatValue());
        this.entity.getMemoryWithoutUpdate().set("$aem_eventRef", this, this.getDuration().floatValue());
        Misc.setFlagWithReason(this.entity.getMemoryWithoutUpdate(), "$missionImportant", "aem", true, this.getDuration().floatValue());
    }

    @Override
    public void endMission() {
        this.entity.getMemoryWithoutUpdate().unset("$aem_target");
        this.entity.getMemoryWithoutUpdate().unset("$aem_eventRef");
        Misc.setFlagWithReason(this.entity.getMemoryWithoutUpdate(), "$missionImportant", "aem", false, 0.0f);
        this.endAfterDelay();
    }

    @Override
    public void advanceMission(float amount) {
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String action = params.get(0).getString(memoryMap);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        if (action.equals("runPackage")) {
            AddRemoveCommodity.addCreditsGainText(this.reward, dialog.getTextPanel());
            cargo.getCredits().add(this.reward);
            CoreReputationPlugin.MissionCompletionRep rep = new CoreReputationPlugin.MissionCompletionRep(0.05f, RepLevel.WELCOMING, -0.01f, RepLevel.INHOSPITABLE);
            ReputationActionResponsePlugin.ReputationAdjustmentResult result = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_SUCCESS, (Object)rep, null, dialog.getTextPanel(), true, false), this.faction.getId());
            this.setMissionResult(new BaseMissionIntel.MissionResult(this.reward, result));
            this.setMissionState(BaseMissionIntel.MissionState.COMPLETED);
            this.endMission();
        }
        return true;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (isUpdate) {
            if (this.isFailed() || this.isCancelled()) {
                return;
            }
            if (this.isCompleted()) {
                if (this.missionResult.payment > 0) {
                    info.addPara("%s received", initPad, tc, h, Misc.getDGSCredits(this.missionResult.payment));
                }
                CoreReputationPlugin.addAdjustmentMessage(this.missionResult.rep1.delta, this.faction, null, null, null, info, tc, isUpdate, 0.0f);
            }
        } else if (this.missionResult != null) {
            if (this.missionResult.payment > 0) {
                info.addPara("%s received", initPad, tc, h, Misc.getDGSCredits(this.missionResult.payment));
                initPad = 0.0f;
            }
            if (this.missionResult.rep1 != null) {
                CoreReputationPlugin.addAdjustmentMessage(this.missionResult.rep1.delta, this.faction, null, null, null, info, tc, isUpdate, initPad);
                initPad = 0.0f;
            }
        } else {
            if (mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
                info.addPara("Faction: " + this.faction.getDisplayName(), initPad, tc, this.faction.getBaseUIColor(), this.faction.getDisplayName());
                initPad = 0.0f;
            }
            info.addPara("%s reward", initPad, tc, h, Misc.getDGSCredits(this.reward));
            this.addDays(info, "to complete", this.duration.floatValue() - this.elapsedDays, tc, 0.0f);
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public String getSortString() {
        return "Analyze";
    }

    @Override
    public String getName() {
        String name = "";
        name = this.entity.getName();
        return "Analyze " + name + this.getPostfixForState();
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.faction.getLogo(), width, 128.0f, opad);
        String name = "";
        String shortName = "";
        String isOrAre = "is";
        String aOrAn = "a";
        if (this.entity.getCustomEntitySpec() != null) {
            name = this.entity.getCustomEntitySpec().getNameInText();
            shortName = this.entity.getCustomEntitySpec().getShortName();
            isOrAre = this.entity.getCustomEntitySpec().getIsOrAre();
            aOrAn = this.entity.getCustomEntitySpec().getAOrAn();
        } else {
            name = this.entity.getName();
            shortName = this.entity.getName();
        }
        String authorities = "authorities";
        if (!this.faction.getId().equals(this.market.getFactionId())) {
            authorities = "concerns";
        }
        info.addPara("%s " + authorities + " " + this.market.getOnOrAt() + " " + this.market.getName() + " have posted a reward for running a custom sensor package on " + aOrAn + " " + name + ".", opad, this.faction.getBaseUIColor(), Misc.ucFirst(this.faction.getPersonNamePrefix()));
        String loc = BreadcrumbSpecial.getLocatedString(this.entity, true);
        info.addPara("The " + shortName + " " + isOrAre + " " + loc + ".", opad);
        if (this.isPosted() || this.isAccepted()) {
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
            this.addGenericMissionState(info);
            this.addAcceptOrAbandonButton(info, width, "Accept", "Abandon");
        } else {
            this.addGenericMissionState(info);
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        }
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("campaignMissions", "analyze_entity");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Exploration");
        tags.add("Missions");
        tags.add(this.faction.getId());
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.entity != null && this.entity.isDiscoverable() && this.entity.getStarSystem() != null) {
            return this.entity.getStarSystem().getCenter();
        }
        return this.entity;
    }
}

