/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.impl.campaign.intel.BaseEventManager;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMissionManager
extends BaseEventManager {
    public static final String KEY = "$core_genericMissionManager";
    protected List<GenericMissionCreator> creators = new ArrayList<GenericMissionCreator>();
    protected Set<GenericMissionCreator> failed = new LinkedHashSet<GenericMissionCreator>();
    protected Map<EveryFrameScript, GenericMissionCreator> missionCreators = new LinkedHashMap<EveryFrameScript, GenericMissionCreator>();

    public static GenericMissionManager getInstance() {
        Object test = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        return (GenericMissionManager)test;
    }

    public GenericMissionManager() {
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        if (this.failed == null) {
            this.failed = new LinkedHashSet<GenericMissionCreator>();
        }
        return this;
    }

    public void addMissionCreator(GenericMissionCreator creator) {
        this.creators.add(creator);
    }

    public boolean hasMissionCreator(Class<?> clazz) {
        for (GenericMissionCreator script : this.creators) {
            if (!clazz.isInstance(script)) continue;
            return true;
        }
        return false;
    }

    public List<GenericMissionCreator> getCreators() {
        return this.creators;
    }

    @Override
    protected int getMinConcurrent() {
        return Global.getSettings().getInt("minGenericMissions");
    }

    @Override
    protected int getMaxConcurrent() {
        return Global.getSettings().getInt("maxGenericMissions");
    }

    @Override
    protected float getIntervalRateMult() {
        float approximateMissionPostingDurationDays = 10.0f;
        return (float)this.getCurrMax() / approximateMissionPostingDurationDays;
    }

    @Override
    protected EveryFrameScript createEvent() {
        ArrayList<EveryFrameScript> orphaned = new ArrayList<EveryFrameScript>(this.missionCreators.keySet());
        CountingMap<GenericMissionCreator> current = new CountingMap<GenericMissionCreator>();
        for (EveryFrameScript s : this.getActive()) {
            orphaned.remove(s);
            GenericMissionCreator genericMissionCreator = this.missionCreators.get(s);
            if (genericMissionCreator == null) continue;
            current.add(genericMissionCreator);
        }
        for (EveryFrameScript s : orphaned) {
            this.missionCreators.remove(s);
        }
        float totalWeight = 0.0f;
        for (GenericMissionCreator c : this.creators) {
            totalWeight += c.getMissionFrequencyWeight();
        }
        WeightedRandomPicker<GenericMissionCreator> picker = new WeightedRandomPicker<GenericMissionCreator>();
        for (GenericMissionCreator genericMissionCreator : this.creators) {
            float deviation;
            float exponent;
            float desiredNum;
            if (this.failed.contains(genericMissionCreator)) continue;
            float currNum = current.getCount(genericMissionCreator);
            if (currNum < 1.0f) {
                currNum = 1.0f;
            }
            if ((desiredNum = (float)this.getCurrMax() * genericMissionCreator.getMissionFrequencyWeight() / totalWeight) < 0.1f) {
                desiredNum = 0.1f;
            }
            if ((exponent = (desiredNum - currNum) / (deviation = desiredNum * 0.25f)) > 4.0f) {
                exponent = 4.0f;
            }
            float probMult = (float)Math.pow(10.0, exponent);
            picker.add(genericMissionCreator, genericMissionCreator.getMissionFrequencyWeight() * probMult);
        }
        GenericMissionCreator genericMissionCreator = (GenericMissionCreator)picker.pick();
        if (genericMissionCreator == null) {
            this.failed.clear();
            return null;
        }
        EveryFrameScript intel = genericMissionCreator.createMissionIntel();
        if (intel instanceof BaseIntelPlugin && ((BaseIntelPlugin)intel).isDone()) {
            intel = null;
        }
        if (intel != null) {
            this.missionCreators.put(intel, genericMissionCreator);
            this.failed.clear();
        } else {
            this.failed.add(genericMissionCreator);
        }
        return intel;
    }

    public static interface GenericMissionCreator {
        public float getMissionFrequencyWeight();

        public EveryFrameScript createMissionIntel();
    }
}

