/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.BaseEventManager;
import com.fs.starfarer.api.impl.campaign.intel.SystemBountyIntel;
import com.fs.starfarer.api.util.ListMap;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.HashSet;

public class SystemBountyManager
extends BaseEventManager {
    public static final String KEY = "$core_systemBountyManager";

    public static SystemBountyManager getInstance() {
        Object test = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        return (SystemBountyManager)test;
    }

    public SystemBountyManager() {
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
    }

    protected int getMinConcurrent() {
        return Global.getSettings().getInt("minSystemBounties");
    }

    protected int getMaxConcurrent() {
        return Global.getSettings().getInt("maxSystemBounties");
    }

    protected EveryFrameScript createEvent() {
        MarketAPI market = this.pickMarket();
        if (market == null) {
            return null;
        }
        SystemBountyIntel intel = new SystemBountyIntel(market);
        return intel;
    }

    public boolean isActive(MarketAPI market) {
        for (EveryFrameScript s : this.getActive()) {
            if (market != ((SystemBountyIntel)s).getMarket()) continue;
            return true;
        }
        return false;
    }

    public SystemBountyIntel getActive(MarketAPI market) {
        for (EveryFrameScript s : this.getActive()) {
            SystemBountyIntel intel = (SystemBountyIntel)s;
            if (intel.isDone() || market != intel.getMarket()) continue;
            return intel;
        }
        return null;
    }

    public void addOrResetBounty(MarketAPI market) {
        if (market != null) {
            SystemBountyIntel active = this.getActive(market);
            if (active != null) {
                active.reset();
            } else {
                this.addActive(new SystemBountyIntel(market));
            }
        }
    }

    protected MarketAPI pickMarket() {
        MarketAPI market3;
        HashSet<MarketAPI> already = new HashSet<MarketAPI>();
        for (EveryFrameScript s : this.getActive()) {
            already.add(((SystemBountyIntel)s).getMarket());
        }
        ListMap<MarketAPI> locationIdToMarket = new ListMap<MarketAPI>();
        for (MarketAPI market2 : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market2.isHidden()) continue;
            locationIdToMarket.add(market2.getContainingLocation().getId(), market2);
        }
        WeightedRandomPicker<MarketAPI> pickerWithPirateActivity = new WeightedRandomPicker<MarketAPI>();
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>();
        block2: for (MarketAPI market3 : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market3.isHidden() || market3.getSize() <= 4 || market3.isPlayerOwned() || already.contains(market3) || market3.getFaction().getCustom().optBoolean("postsNoBounties") || Global.getSector().isInNewGameAdvance() && market3.getId().equals("jangala")) continue;
            for (MarketAPI other : locationIdToMarket.getList(market3.getContainingLocation().getId())) {
                if (market3.getFaction() == other.getFaction() && already.contains(other)) continue block2;
            }
            float w = (float)market3.getSize() * 0.25f;
            for (MarketAPI other : locationIdToMarket.getList(market3.getContainingLocation().getId())) {
                if (!market3.getFaction().isHostileTo(other.getFaction())) continue;
                w += 10.0f;
                if (other.getMemoryWithoutUpdate().getBoolean("$military") || other.getMemoryWithoutUpdate().getBoolean("$patrol")) {
                    w += 10.0f;
                }
                if (market3.getMemoryWithoutUpdate().getBoolean("$military")) {
                    w += 10.0f;
                    continue;
                }
                if (!market3.getMemoryWithoutUpdate().getBoolean("$patrol")) continue;
                w += 5.0f;
            }
            if (market3.hasCondition("pirate_activity")) {
                pickerWithPirateActivity.add(market3, w += 10.0f);
                continue;
            }
            picker.add(market3, w);
        }
        market3 = (MarketAPI)pickerWithPirateActivity.pick();
        float w = pickerWithPirateActivity.getWeight(market3);
        if (market3 == null) {
            market3 = (MarketAPI)picker.pick();
            w = picker.getWeight(market3);
        }
        float probMult = 1.0f / ((float)this.getOngoing() + 1.0f);
        if ((float)Math.random() > w * 0.01f * probMult) {
            market3 = null;
        }
        return market3;
    }
}

