/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseGetCommodityBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.DeliveryMissionIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Random;

public class DeliveryBarEvent
extends BaseGetCommodityBarEvent {
    public static String KEY_FAILED_RECENTLY = "$core_dmi_failedRecently";
    public static String KEY_SAW_DELIVERY_EVENT_RECENTLY = "$core_dmi_sawRecently";
    public static String KEY_ACCEPTED_AT_THIS_MARKET_RECENTLY = "$core_dmi_acceptedAtThisMarket";
    public static float PROB_HIGHER_CAPACITY = 0.25f;
    public static float FAILED_RECENTLY_DURATION = 365.0f;
    public static float SAW_RECENTLY_DURATION = 180.0f;
    public static float ACCEPTED_AT_THIS_MARKET_DURATION = 90.0f;
    public static float PROB_TO_SHOW = 0.5f;
    protected MarketAPI destination;
    protected int reward;
    protected int escrow;
    protected float duration;
    protected FactionAPI faction;
    protected int playerCargoCap = 0;
    protected int playerFuelCap = 0;
    protected DestinationData data;

    public boolean shouldShowAtMarket(MarketAPI market) {
        if (!super.shouldShowAtMarket(market)) {
            return false;
        }
        if (market.getFactionId().equals("pirates")) {
            return false;
        }
        if (market.getFactionId().equals("luddic_path")) {
            return false;
        }
        if (market.getMemoryWithoutUpdate().getBoolean(KEY_ACCEPTED_AT_THIS_MARKET_RECENTLY)) {
            return false;
        }
        this.regen(market);
        if (this.destination == null) {
            return false;
        }
        if (this.escrow > 0 && market.isPlayerOwned()) {
            return false;
        }
        if (Global.getSector().getMemoryWithoutUpdate().getBoolean(KEY_SAW_DELIVERY_EVENT_RECENTLY) && this.shownAt != market && this.random.nextFloat() > PROB_TO_SHOW) {
            return false;
        }
        Global.getSector().getMemoryWithoutUpdate().set(KEY_SAW_DELIVERY_EVENT_RECENTLY, true, SAW_RECENTLY_DURATION);
        return true;
    }

    protected void regen(MarketAPI market) {
        if (this.market != market) {
            this.playerCargoCap = 0;
            this.playerFuelCap = 0;
        }
        this.market = market;
        this.random = new Random(this.seed + (long)market.getId().hashCode());
        this.computeData(market);
        if (this.destination != null) {
            this.person = this.createPerson();
        }
    }

    protected void computeData(MarketAPI market) {
        float mult;
        float base;
        this.data = null;
        this.destination = null;
        this.reward = 0;
        this.duration = 0.0f;
        this.faction = null;
        this.quantity = 0;
        this.commodity = null;
        ArrayList<CommodityOnMarketAPI> commodities = new ArrayList<CommodityOnMarketAPI>();
        for (CommodityOnMarketAPI com : market.getCommoditiesCopy()) {
            if (com.isNonEcon() || com.isMeta() || com.isPersonnel() || com.isIllegal() || com.getAvailable() <= 0 || com.getMaxSupply() <= 0) continue;
            commodities.add(com);
        }
        ArrayList<DestinationData> potential = new ArrayList<DestinationData>();
        float maxScore = 0.0f;
        float maxDist = 0.0f;
        for (MarketAPI other : Global.getSector().getEconomy().getMarketsCopy()) {
            if (other == market || other.isHidden() || other.isInvalidMissionTarget() || other.getEconGroup() == null && market.getEconGroup() != null || other.getEconGroup() != null && !other.getEconGroup().equals(market.getEconGroup()) || other.getStarSystem() == null) continue;
            for (CommodityOnMarketAPI com : commodities) {
                CommodityOnMarketAPI otherCom = other.getCommodityData(com.getDemandClass());
                if (otherCom.getMaxDemand() <= 0) continue;
                DestinationData data = new DestinationData(market, other, com, otherCom);
                if (data.illegal) continue;
                if (data.score > maxScore) {
                    maxScore = data.score;
                }
                if (data.distLY > maxDist) {
                    maxDist = data.distLY;
                }
                potential.add(data);
            }
        }
        if (maxDist > 10.0f) {
            maxDist = 10.0f;
        }
        WeightedRandomPicker<DestinationData> picker = new WeightedRandomPicker<DestinationData>(this.random);
        int i = 0;
        while (i < potential.size()) {
            DestinationData d = (DestinationData)potential.get(i);
            if (d.score > maxScore * 0.5f && d.distLY > maxDist * 0.5f) {
                picker.add(d, d.score * d.score * d.score);
            }
            ++i;
        }
        DestinationData pick = (DestinationData)picker.pick();
        if (pick == null) {
            return;
        }
        this.destination = pick.dest;
        this.duration = pick.distLY * 5.0f + 50.0f;
        this.duration = (int)this.duration / 10 * 10;
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        this.quantity = (int)cargo.getMaxCapacity();
        if (pick.com.isFuel()) {
            this.quantity = (int)cargo.getMaxFuel();
        }
        if (this.random.nextFloat() < PROB_HIGHER_CAPACITY) {
            this.quantity = this.quantity = (int)((float)this.quantity * (1.0f + this.random.nextFloat() * 3.0f));
        }
        if (pick.com.isFuel()) {
            if (this.playerFuelCap == 0) {
                this.playerFuelCap = this.quantity;
            } else {
                this.quantity = this.playerFuelCap;
            }
        } else if (this.playerCargoCap == 0) {
            this.playerCargoCap = this.quantity;
        } else {
            this.quantity = this.playerCargoCap;
        }
        this.quantity = (int)((float)this.quantity * (0.5f + 0.25f * this.random.nextFloat()));
        this.quantity = (int)((float)this.quantity * Math.min(1.0f, 200.0f / pick.comFrom.getCommodity().getBasePrice()));
        int limit = (int)((float)pick.comFrom.getAvailable() * pick.comFrom.getCommodity().getEconUnit());
        limit = (int)((float)limit * (0.75f + 0.5f * this.random.nextFloat()));
        if (this.quantity > limit) {
            this.quantity = limit;
        }
        if (this.quantity > 10000) {
            this.quantity = this.quantity / 1000 * 1000;
        } else if (this.quantity > 100) {
            this.quantity = this.quantity / 10 * 10;
        } else if (this.quantity > 10) {
            this.quantity = this.quantity / 10 * 10;
        }
        if (this.quantity < 10) {
            this.quantity = 10;
        }
        if ((float)this.quantity * (base = pick.comFrom.getMarket().getSupplyPrice(pick.comFrom.getId(), 1.0, true)) < 4000.0f) {
            base = Math.min(100, 4000 / this.quantity);
        }
        float minBase = 100.0f - 50.0f * Math.min(1.0f, (float)this.quantity / 500.0f);
        if (base < (minBase = (base + minBase) * 0.75f)) {
            base = minBase;
        }
        if ((mult = pick.score / 30.0f) < 0.75f) {
            mult = 0.75f;
        }
        this.reward = (int)(base * mult * (float)this.quantity);
        this.reward = this.reward / 1000 * 1000;
        if (this.reward < 4000) {
            this.reward = 4000;
        }
        if (Global.getSector().getMemoryWithoutUpdate().getBoolean(KEY_FAILED_RECENTLY)) {
            this.escrow = (int)((float)this.quantity * pick.comFrom.getCommodity().getBasePrice());
        }
        if (market.getFaction() == pick.dest.getFaction()) {
            this.faction = market.getFaction();
        } else {
            this.faction = Global.getSector().getFaction("independent");
            if (this.faction == null) {
                this.faction = market.getFaction();
            }
        }
        this.commodity = pick.comFrom.getId();
        this.data = pick;
    }

    protected int getNegotiatedAmount() {
        return (int)((float)this.reward * 1.5f);
    }

    protected void addStoryOption() {
        String id = "negotiate_id";
        this.options.addOption("Negotiate a higher fee for the delivery", id);
        SetStoryOption.StoryOptionParams params = new SetStoryOption.StoryOptionParams(id, 1, "negotiateDeliveryFee", Sounds.STORY_POINT_SPEND_INDUSTRY, "Negotiated higher fee for delivery of " + this.data.comFrom.getCommodity().getLowerCaseName() + " to " + this.data.dest.getName());
        SetStoryOption.set(this.dialog, params, new SetStoryOption.BaseOptionStoryPointActionDelegate(this.dialog, params){

            public void confirm() {
                super.confirm();
                DeliveryBarEvent.this.reward = DeliveryBarEvent.this.getNegotiatedAmount();
                this.dialog.getTextPanel().addPara(DeliveryBarEvent.this.getNegotiatedText());
                OptionPanelAPI options = this.dialog.getOptionPanel();
                options.clearOptions();
                options.addOption("Continue", "confirm");
            }

            public String getTitle() {
                return null;
            }

            public void createDescription(TooltipMakerAPI info) {
                float opad = 10.0f;
                info.addSpacer(-opad);
                info.setParaInsigniaLarge();
                info.addPara("You're able to negotiate the delivery fee from %s up to %s.", 0.0f, Misc.getHighlightColor(), Misc.getDGSCredits(DeliveryBarEvent.this.reward), Misc.getDGSCredits(DeliveryBarEvent.this.getNegotiatedAmount()));
                info.addSpacer(opad * 2.0f);
                this.addActionCostSection(info);
            }
        });
    }

    protected boolean canAccept() {
        if (this.escrow <= 0) {
            return true;
        }
        float credits = Global.getSector().getPlayerFleet().getCargo().getCredits().get();
        boolean canAfford = credits >= (float)this.escrow;
        return canAfford;
    }

    protected void doStandardConfirmActions() {
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        TextPanelAPI text = this.dialog.getTextPanel();
        cargo.addCommodity(this.commodity, this.quantity);
        AddRemoveCommodity.addCommodityGainText(this.commodity, this.quantity, text);
        if (this.escrow > 0) {
            cargo.getCredits().subtract(this.escrow);
            AddRemoveCommodity.addCreditsLossText(this.escrow, text);
        }
        this.createIntel();
    }

    protected void createIntel() {
        DeliveryMissionIntel intel = new DeliveryMissionIntel(this, this.dialog);
        this.market.getMemoryWithoutUpdate().set(KEY_ACCEPTED_AT_THIS_MARKET_RECENTLY, true, ACCEPTED_AT_THIS_MARKET_DURATION * (0.75f + this.random.nextFloat() * 0.5f));
    }

    protected void adjustPerson(PersonAPI person) {
        super.adjustPerson(person);
        person.setImportanceAndVoice(this.pickImportance(), this.random);
        person.addTag("trade");
    }

    protected String getPersonFaction() {
        return this.faction.getId();
    }

    protected String getPersonRank() {
        return Ranks.CITIZEN;
    }

    protected String getPersonPost() {
        return this.pickOne(Ranks.POST_TRADER, Ranks.POST_COMMODITIES_AGENT, Ranks.POST_MERCHANT, Ranks.POST_INVESTOR);
    }

    protected float getPriceMult() {
        return 0.0f;
    }

    protected String getPrompt() {
        if (this.faction.getId().equals("independent")) {
            return "At a corner table, a concerned-looking " + this.getManOrWoman() + " glumly examines " + this.getHisOrHer() + " TriPad.";
        }
        return "At a corner table, a concerned-looking " + this.getManOrWoman() + " in " + this.faction.getPersonNamePrefixAOrAn() + " " + this.faction.getPersonNamePrefix() + " uniform " + " glumly examines " + this.getHisOrHer() + " TriPad.";
    }

    protected String getOptionText() {
        return "Nod to the concerned " + this.getManOrWoman() + " and walk over to " + this.getHisOrHer() + " table";
    }

    protected String getMainText() {
        int cap;
        String str = "";
        if (this.market.isPlayerOwned()) {
            String sir = "sir";
            if (Global.getSector().getPlayerPerson().isFemale()) {
                sir = "ma'am";
            }
            str = "\"Oh, it's you, " + sir + "!\", " + this.getHeOrShe() + " exclaims. Taking a moment to recover " + this.getHisOrHer() + " composure, " + this.getHeOrShe() + " says \"We've got a little logistical problem that could use " + "your personal touch. " + "There are %s units of " + this.data.comFrom.getCommodity().getLowerCaseName() + " that urgently need to be delivered " + " to %s" + ", in the " + this.data.dest.getStarSystem().getNameWithLowercaseType() + ". ";
            str = this.data.fromHasPA || this.data.hasPA ? String.valueOf(str) + "However, recent pirate activity has been making that difficult, and the regular trade fleets aren't quite up to the task.\"" : (this.data.fromHasCells || this.data.hasCells ? String.valueOf(str) + "However, recent Pather cell activity has been making that difficult, and the regular trade fleets aren't quite up to the task.\"" : String.valueOf(str) + "But, well, you know what trader captains are like. There have been some disagreements over hazard pay, and it's left us in the lurch.\"");
        } else {
            str = "After brief introductions, " + this.getHeOrShe() + " wastes no time in getting to the point. " + "\"I've got %s units of " + this.data.comFrom.getCommodity().getLowerCaseName() + " that urgently need to be delivered " + " to %s" + ", in the " + this.data.dest.getStarSystem().getNameWithLowercaseType() + ". ";
            str = this.data.fromHasPA || this.data.hasPA ? String.valueOf(str) + "Recent pirate activity has been making that difficult, but you look like someone that could get the job done.\"" : (this.data.fromHasCells || this.data.hasCells ? String.valueOf(str) + "Recent Pather cell activity has been making that difficult, but I'm sure you can handle any trouble.\"" : String.valueOf(str) + "We've had some disputes with the regular shipping company, and it's left us in the lurch. Should be a milk run for someone like you, though.\"");
        }
        String where = "located in hyperspace,";
        if (this.data.dest.getStarSystem() != null) {
            where = "located in the " + this.data.dest.getStarSystem().getNameWithLowercaseType();
        }
        str = String.valueOf(str) + "\n\nYou recall that " + this.data.dest.getName() + " is under %s control, and " + where + ". ";
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        str = this.data.comFrom.isFuel() ? ((cap = cargo.getFreeFuelSpace()) > 1 ? String.valueOf(str) + " Your fleet's fuel tanks can hold an additional %s units of fuel." : String.valueOf(str) + "%sYour fleet's fuel tanks are currently full.") : ((cap = (int)cargo.getSpaceLeft()) > 1 ? String.valueOf(str) + " Your fleet's holds can accommodate an additional %s units of cargo." : String.valueOf(str) + "%sYour fleet's cargo holds are currently full.");
        str = this.market.isPlayerOwned() ? String.valueOf(str) + "\n\n" + Misc.ucFirst(this.getHeOrShe()) + " double-checks something on " + this.getHisOrHer() + " pad. " + "\"The customer will pay %s upon delivery within %s days. Can you take this on?\"" : (this.escrow > 0 ? String.valueOf(str) + "\n\n" + Misc.ucFirst(this.getHeOrShe()) + " double-checks something on " + this.getHisOrHer() + " pad. " + "\"The offer is %s credits, payable upon delivery within %s days. You'll also have to " + "transfer %s to an escrow account. This will be returned to you " + "when you complete the delivery - " + "standard insurance procedure, you understand.\"" : String.valueOf(str) + "\n\n" + Misc.ucFirst(this.getHeOrShe()) + " double-checks something on " + this.getHisOrHer() + " pad. " + "\"The offer is %s credits, payable upon delivery within %s days. You in?\"");
        return str;
    }

    protected String[] getMainTextTokens() {
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        int cap = 0;
        cap = this.data.comFrom.isFuel() ? cargo.getFreeFuelSpace() : (int)cargo.getSpaceLeft();
        return new String[]{Misc.getWithDGS(this.quantity), this.data.dest.getName(), this.data.dest.getFaction().getPersonNamePrefix(), cap > 1 ? Misc.getWithDGS(cap) : " ", Misc.getDGSCredits(this.reward), Misc.getWithDGS(this.duration), Misc.getDGSCredits(this.escrow)};
    }

    protected Color[] getMainTextColors() {
        return new Color[]{Misc.getHighlightColor(), Misc.getTextColor(), this.data.dest.getFaction().getBaseUIColor(), Misc.getHighlightColor(), Misc.getHighlightColor(), Misc.getHighlightColor(), Misc.getHighlightColor()};
    }

    protected String getConfirmText() {
        if (this.market.isPlayerOwned()) {
            return "Agree to handle the contract";
        }
        return "Accept the delivery contract";
    }

    protected String getNegotiatedText() {
        return "\"You drive a hard bargain! Very well, it's a deal.\" " + Misc.ucFirst(this.getHeOrShe()) + " does not appear too displeased. You consider that the initial offer " + "was probably on the low side.";
    }

    protected String getCancelText() {
        if (this.market.isPlayerOwned()) {
            return "Decline, explaining that you've got other urgent business to attend to";
        }
        return "Decline the offer, explaining that you've got other plans";
    }

    protected String getAcceptText() {
        return "You receive authorization codes to access a dockside warehouse, and contact your quartermaster with instructions to begin loading the cargo.";
    }

    public MarketAPI getDestination() {
        return this.destination;
    }

    public int getReward() {
        return this.reward;
    }

    public float getDuration() {
        return this.duration;
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    public DestinationData getData() {
        return this.data;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public int getEscrow() {
        return this.escrow;
    }

    protected boolean showCargoCap() {
        return false;
    }

    protected void showTotalAndOptions() {
        super.showTotalAndOptions();
        String icon = Global.getSettings().getCommoditySpec(this.commodity).getIconName();
        String text = null;
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        tags.add("Missions");
        this.dialog.getVisualPanel().showMapMarker(this.getDestination().getPrimaryEntity(), "Destination: " + this.getDestination().getName(), this.getDestination().getFaction().getBaseUIColor(), true, icon, text, tags);
    }

    public static class DestinationData {
        public MarketAPI dest;
        public CommodityOnMarketAPI comFrom;
        public CommodityOnMarketAPI com;
        public float distLY;
        public boolean fromHasPA = false;
        public boolean fromHasCells = false;
        public boolean hasPA = false;
        public boolean hasCells = false;
        public boolean illegal = false;
        public float score = 0.0f;

        public DestinationData(MarketAPI from, MarketAPI dest, CommodityOnMarketAPI comFrom, CommodityOnMarketAPI comDest) {
            this.dest = dest;
            this.comFrom = comFrom;
            this.com = comDest;
            this.distLY = Misc.getDistanceLY(from.getLocationInHyperspace(), dest.getLocationInHyperspace());
            this.fromHasPA = from.hasCondition("pirate_activity");
            this.fromHasCells = from.hasCondition("pather_cells");
            this.hasPA = dest.hasCondition("pirate_activity");
            this.hasCells = dest.hasCondition("pather_cells");
            this.illegal = dest.isIllegal(this.com.getId());
            this.score += Math.min(this.distLY, 10.0f);
            if (this.fromHasPA) {
                this.score += 10.0f;
            }
            if (this.fromHasCells) {
                this.score += 5.0f;
            }
            if (this.hasPA) {
                this.score += 10.0f;
            }
            if (this.hasCells) {
                this.score += 5.0f;
            }
        }
    }
}

