/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseGetCommodityBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class LuddicFarmerBarEvent
extends BaseGetCommodityBarEvent {
    public boolean shouldShowAtMarket(MarketAPI market) {
        if (!super.shouldShowAtMarket(market)) {
            return false;
        }
        this.regen(market);
        if (!market.getFactionId().equals("luddic_church") && !market.getFactionId().equals("luddic_path")) {
            return false;
        }
        if (market.getStabilityValue() < 4.0f) {
            return false;
        }
        CommodityOnMarketAPI com = market.getCommodityData(this.commodity);
        if (com.getMaxSupply() <= 0) {
            return false;
        }
        return com.getAvailable() >= com.getMaxDemand();
    }

    protected String getCommodityId() {
        return "food";
    }

    protected void doExtraConfirmActions() {
        ContactIntel.addPotentialContact(this.person, this.market, this.text);
    }

    protected void adjustPerson(PersonAPI person) {
        super.adjustPerson(person);
        person.setImportanceAndVoice(this.pickLowImportance(), this.random);
        person.addTag("trade");
    }

    protected String getPersonPost() {
        return Ranks.POST_COMMUNE_LEADER;
    }

    protected String getPersonFaction() {
        return "luddic_church";
    }

    protected String getPersonRank() {
        return Ranks.CITIZEN;
    }

    protected int computeQuantity() {
        int quantity = 50 + 10 * this.random.nextInt(6);
        CommodityOnMarketAPI com = this.market.getCommodityData(this.commodity);
        int size = Math.min(com.getAvailable(), com.getMaxSupply());
        if (size < 1) {
            size = 1;
        }
        quantity = (int)((float)quantity * Math.max(1.0f, BaseIndustry.getSizeMult(size) - 2.0f));
        return quantity;
    }

    protected float getPriceMult() {
        return 0.75f;
    }

    protected String getPrompt() {
        return "A weathered-looking " + this.getManOrWoman() + " whose worn but well-tailored " + "work suit bears the sigil of a farming commune sits at a table drinking small-beer.";
    }

    protected String getOptionText() {
        return "Chat up the weathered-looking " + this.getManOrWoman();
    }

    protected String getMainText() {
        String heOrShe = this.getHeOrShe();
        return String.valueOf(Misc.ucFirst(heOrShe)) + " turns out to be the master of a farming commune " + "and " + heOrShe + " has come \"to town\" to find distributors for their product. " + Misc.ucFirst(heOrShe) + "'s got %s units of food that has to be moved as soon as possible and " + "if you buy it all today, you'll get an under-market price of %s per unit. " + "And, " + heOrShe + " says with a wink, \"As pious folk, we need not bother with the Church\u2019s tariff.\",";
    }

    protected String[] getMainTextTokens() {
        return new String[]{Misc.getWithDGS(this.quantity), Misc.getDGSCredits(this.unitPrice)};
    }

    protected Color[] getMainTextColors() {
        return new Color[]{Misc.getHighlightColor(), Misc.getHighlightColor()};
    }

    protected String getConfirmText() {
        return "Accept with a firm handshake and cryptokey exchange";
    }

    protected String getCancelText() {
        return "Decline the deal, and thank " + this.getHimOrHer() + " for the proposal";
    }

    protected String getAcceptText() {
        return "You make arrangements with the farm master for pickup of the cargo from a quiet warehouse on the outskirts of " + this.market.getName() + " and transmit the details " + "to your quartermaster to handle.";
    }

    protected String[] getAcceptTextTokens() {
        return new String[0];
    }

    protected Color[] getAcceptTextColors() {
        return new Color[0];
    }
}

