/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BarEventManager;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseBarEventWithPerson;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.PlanetaryShieldIntel;
import com.fs.starfarer.api.impl.campaign.procgen.themes.MiscellaneousThemeGenerator;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.LinkedHashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanetaryShieldBarEvent
extends BaseBarEventWithPerson {
    protected PersonAPI pilot;
    protected MarketAPI pilotMarket = null;

    public static PlanetAPI getTargetPlanet() {
        return (PlanetAPI)Global.getSector().getMemoryWithoutUpdate().get(MiscellaneousThemeGenerator.PLANETARY_SHIELD_PLANET_KEY);
    }

    @Override
    public boolean shouldShowAtMarket(MarketAPI market) {
        if (!super.shouldShowAtMarket(market)) {
            return false;
        }
        if (market.getFactionId().equals("luddic_church") || market.getFactionId().equals("luddic_path")) {
            return false;
        }
        if (PlanetaryShieldBarEvent.getTargetPlanet() == null) {
            return false;
        }
        if (Global.getSector().getIntelManager().hasIntelOfClass(PlanetaryShieldIntel.class)) {
            return false;
        }
        return Global.getSector().getPlayerStats().getLevel() >= 10 || DebugFlags.BAR_DEBUG;
    }

    @Override
    protected void regen(MarketAPI market) {
        if (this.market == market) {
            return;
        }
        super.regen(market);
        if (this.person.getGender() == FullName.Gender.MALE) {
            this.person.setPortraitSprite(Global.getSettings().getSpriteName("intel", "old_spacer_male"));
        } else {
            this.person.setPortraitSprite(Global.getSettings().getSpriteName("intel", "old_spacer_female"));
        }
        this.pilot = Global.getSector().getFaction("independent").createRandomPerson(this.random);
        this.pilot.setRankId(Ranks.PILOT);
        this.pilot.setPostId(Ranks.POST_CITIZEN);
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(this.random);
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsInGroup(null)) {
            if (curr == market || curr.isPlayerOwned() || curr.isHidden() || curr.isInvalidMissionTarget() || curr.getStabilityValue() <= 0.0f) continue;
            float w = curr.getSize();
            if (curr.isFreePort()) {
                w += 10.0f;
            }
            picker.add(curr, w);
        }
        if (picker.isEmpty()) {
            picker.add(market, 1.0f);
        }
        this.pilotMarket = (MarketAPI)picker.pick();
    }

    @Override
    public void addPromptAndOption(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.addPromptAndOption(dialog, memoryMap);
        this.regen(dialog.getInteractionTarget().getMarket());
        TextPanelAPI text = dialog.getTextPanel();
        text.addPara("A rough-looking veteran spacer with cybernetic eyes seems to be staring intently at you; it's a little unnerving.");
        dialog.getOptionPanel().addOption("Ask the veteran spacer what " + this.getHeOrShe() + "'s looking at", this, null);
    }

    @Override
    public void init(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.init(dialog, memoryMap);
        this.done = false;
        dialog.getVisualPanel().showPersonInfo(this.person, true);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
        if (!(optionData instanceof OptionId)) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        OptionPanelAPI options = this.dialog.getOptionPanel();
        TextPanelAPI text = this.dialog.getTextPanel();
        options.clearOptions();
        switch (option) {
            case INIT: {
                text.addPara("\"Ain't nothing, I'm just reading my mail,\" " + this.getHeOrShe() + " growls back. Then laughs, and taps " + this.getHisOrHer() + " temple. " + "\"Swear I'll never get proper used to these things.\"");
                options.addOption("Offer to apologize for the misunderstanding by buying " + this.getHimOrHer() + " a drink", (Object)OptionId.APOLOGIZE);
                options.addOption("Suggest that " + this.getHeOrShe() + " read the manual then leave", (Object)OptionId.LEAVE);
                break;
            }
            case APOLOGIZE: {
                text.addPara("The old space-hand opens up as one drink turns to two or three. " + Misc.ucFirst(this.getHeOrShe()) + " tells stories of old injuries earned, including that of " + this.getHisOrHer() + " lost eyes.\n\n\"Was just two survivors from that mission, me and the pilot. " + "Lucky bastards, we two.\" It all began when " + this.getHeOrShe() + " was hired on to " + "a salvage fleet trawling decivilized systems outside the Core Worlds. " + "The loot was good, and any brigand they couldn't fight, they could flee." + "\n\nThen the officers found something new in a data-cache. " + "Rumours flew among the crew, who were told nothing, as the fleet suddenly left a rich " + "asteroid belt to make for the outer system jump-point. " + "They fared two hyperspace storms before arriving at a distant star system.");
                options.addOption("Continue", (Object)OptionId.CONTINUE_1);
                break;
            }
            case CONTINUE_1: {
                text.addPara("There they found a planet all shining and red. \"It weren't anything natural. It was all... shapes, angles, glowing like plasma. That's truth,\" " + this.getHeOrShe() + " says quietly, \"I've seen Gates, sure, and orbital works big as you like. Ain't " + "never seen anything Domain-made glow like that across a whole planet's face. " + "Not anything that weren't a weapon, I mean.\"");
                options.addOption("Continue", (Object)OptionId.CONTINUE_2);
                break;
            }
            case CONTINUE_2: {
                text.addPara("\"While we were gawkin', the prox alarm goes and it's battle stations\", " + this.getHeOrShe() + " continues. Hostile ships came fast upon the salvage fleet, flitting with agility " + "belying advanced tech. They had equally advanced weapons, too, and with those they " + "attacked with no mercy. \"It weren't pirates, nor military,\" here the spacer loses " + this.getHisOrHer() + " cheer at a good story. \"Ludd's hells, I swear to you it weren't anything human.\"");
                text.addPara("The spacer explains that just " + this.getHeOrShe() + " and the pilot got away in an " + "escape pod which was only \"mostly\" malfunctioning. \"The miracle wasn't that I " + "fixed it, it's that they could thaw enough of me out at the end of it for me to keep " + "livin', if you call this livin'.\"");
                options.addOption("\"Where was this system with the red planet?\"", (Object)OptionId.WHERE_WAS_SYSTEM);
                break;
            }
            case WHERE_WAS_SYSTEM: {
                text.addPara("You emphasize your interest in the subject by having the spacer's drink refreshed. " + Misc.ucFirst(this.getHeOrShe()) + " shakes " + this.getHisOrHer() + " head, \"Captain, " + "I wouldn't wish my fate on you or anyone. Besides, I have no idea.\" A pause, then, " + "\"" + this.pilot.getNameString() + " would - that's the pilot,\" " + this.getHeOrShe() + " finally admits.");
                text.addPara("The old spacer tells you that " + this.pilot.getName().getFirst() + " did not live the experience in such " + "stride as " + this.getHimOrHerself() + ", and has taken to drinking themselves senseless " + "in semi-retirement " + this.pilotMarket.getOnOrAt() + " " + this.pilotMarket.getName() + ". " + "\"Some folks, I don't think they react well " + "to the emergency cryo-pods. Like a bit o' their brain is still froze up and not coming back.\"");
                String icon = Global.getSettings().getSpriteName("intel", "red_planet");
                LinkedHashSet<String> tags = new LinkedHashSet<String>();
                tags.add("Missions");
                this.dialog.getVisualPanel().showMapMarker(this.pilotMarket.getPrimaryEntity(), "Destination: " + this.pilotMarket.getName(), this.pilotMarket.getFaction().getBaseUIColor(), true, icon, null, tags);
                options.addOption("Continue", (Object)OptionId.CONTINUE_3);
                break;
            }
            case CONTINUE_3: {
                text.addPara("You consider a trip to " + this.pilotMarket.getName() + " to see if you can get the exact location of " + "this mysterious planet with its unknown technology. You also realize that the old spacer " + "has fallen asleep in " + this.getHisOrHer() + " seat, cybernetic eyes blanked out in standby mode.");
                BarEventManager.getInstance().notifyWasInteractedWith(this);
                this.addIntel();
                options.addOption("Leave the old spacer to " + this.getHisOrHer() + " rest", (Object)OptionId.LEAVE);
                break;
            }
            case LEAVE: {
                this.noContinue = true;
                this.done = true;
            }
        }
    }

    protected void addIntel() {
        PlanetaryShieldIntel intel;
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        TextPanelAPI text = this.dialog.getTextPanel();
        PlanetAPI planet = PlanetaryShieldBarEvent.getTargetPlanet();
        boolean success = false;
        if (planet != null && !(intel = new PlanetaryShieldIntel(planet, this)).isDone()) {
            Global.getSector().getIntelManager().addIntel(intel, false, text);
            success = true;
        }
        if (!success) {
            text.addPara("For a minute there, you were caught by the story, but you now see that following up on it would be a fool's errand.");
        }
    }

    @Override
    protected String getPersonFaction() {
        return "independent";
    }

    @Override
    protected String getPersonRank() {
        return Ranks.SPACE_SAILOR;
    }

    @Override
    protected String getPersonPost() {
        return Ranks.CITIZEN;
    }

    @Override
    protected String getPersonPortrait() {
        return null;
    }

    @Override
    protected FullName.Gender getPersonGender() {
        return FullName.Gender.ANY;
    }

    public PersonAPI getPilot() {
        return this.pilot;
    }

    public MarketAPI getPilotMarket() {
        return this.pilotMarket;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionId {
        INIT,
        APOLOGIZE,
        CONTINUE_1,
        CONTINUE_2,
        WHERE_WAS_SYSTEM,
        CONTINUE_3,
        LEAVE;

    }
}

