/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseGetCommodityBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.TriTachLoanIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class TriTachLoanBarEvent
extends BaseGetCommodityBarEvent {
    public static int REPAYMENT_DAYS = 400;
    protected int loanAmount;
    protected int repaymentAmount;
    protected int repaymentDays;

    public boolean shouldShowAtMarket(MarketAPI market) {
        if (!super.shouldShowAtMarket(market)) {
            return false;
        }
        if (!market.getFactionId().equals("tritachyon")) {
            return false;
        }
        if (market.getStabilityValue() < 4.0f) {
            return false;
        }
        return !Global.getSector().getFaction("tritachyon").getRelToPlayer().isAtBest(RepLevel.HOSTILE);
    }

    protected void regen(MarketAPI market) {
        if (this.market == market) {
            return;
        }
        super.regen(market);
        this.loanAmount = 200000 + this.random.nextInt(6) * 10000;
        this.repaymentAmount = (int)((float)this.loanAmount * 1.5f);
        this.repaymentDays = REPAYMENT_DAYS;
    }

    protected void doStandardConfirmActions() {
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        cargo.getCredits().add(this.loanAmount);
        TextPanelAPI text = this.dialog.getTextPanel();
        AddRemoveCommodity.addCreditsGainText(this.loanAmount, text);
        this.createIntel();
    }

    protected int getNegotiatedAmount() {
        return this.repaymentAmount - (int)((float)(this.repaymentAmount - this.loanAmount) * 0.5f);
    }

    protected void addStoryOption() {
        String id = "negotiate_id";
        this.options.addOption("Negotiate a lower rate on the loan", id);
        SetStoryOption.StoryOptionParams params = new SetStoryOption.StoryOptionParams(id, 1, "negotiateLoanRate", Sounds.STORY_POINT_SPEND_TECHNOLOGY, "Negotiated lower rate on " + Misc.getDGSCredits(this.loanAmount) + " loan from Tri-Tachyon investor");
        SetStoryOption.set(this.dialog, params, new SetStoryOption.BaseOptionStoryPointActionDelegate(this.dialog, params){

            public void confirm() {
                super.confirm();
                TriTachLoanBarEvent.this.repaymentAmount = TriTachLoanBarEvent.this.getNegotiatedAmount();
                this.dialog.getTextPanel().addPara(TriTachLoanBarEvent.this.getNegotiatedText());
                OptionPanelAPI options = this.dialog.getOptionPanel();
                options.clearOptions();
                options.addOption("Continue", "confirm");
            }

            public String getTitle() {
                return null;
            }

            public void createDescription(TooltipMakerAPI info) {
                float opad = 10.0f;
                info.setParaInsigniaLarge();
                info.addSpacer(-opad * 1.0f);
                info.addPara("The loan amount is %s.", 0.0f, Misc.getHighlightColor(), Misc.getDGSCredits(TriTachLoanBarEvent.this.loanAmount));
                info.addPara("You're able to negotiate the repayment amount from %s down to %s.", opad, Misc.getHighlightColor(), Misc.getDGSCredits(TriTachLoanBarEvent.this.repaymentAmount), Misc.getDGSCredits(TriTachLoanBarEvent.this.getNegotiatedAmount()));
                info.addSpacer(opad * 2.0f);
                this.addActionCostSection(info);
            }
        });
    }

    public void optionSelected(String optionText, Object optionData) {
        super.optionSelected(optionText, optionData);
    }

    protected void createIntel() {
        TriTachLoanIntel intel = new TriTachLoanIntel(this, this.market);
        Global.getSector().getIntelManager().addIntel(intel, false, this.dialog.getTextPanel());
    }

    protected String getPersonFaction() {
        return "tritachyon";
    }

    protected String getPersonRank() {
        return Ranks.CITIZEN;
    }

    protected void adjustPerson(PersonAPI person) {
        super.adjustPerson(person);
        person.setImportanceAndVoice(PersonImportance.MEDIUM, this.random);
        person.addTag("trade");
    }

    protected String getPersonPost() {
        return Ranks.POST_EXECUTIVE;
    }

    protected float getPriceMult() {
        return 0.0f;
    }

    protected String getPrompt() {
        return "A Tri-Tachyon careerist sits at a spotless table, sipping something expensive-looking.";
    }

    protected String getOptionText() {
        return "Introduce yourself to the Tri-Tachyon " + this.getManOrWoman() + " and try to land some investment credits";
    }

    protected String getMainText() {
        return "A young Tri-Tachyon factioneer in a perfect suit sips from some insubstantial drink as sophisticated as it is expensive. After introductions " + this.getHeOrShe() + " quickly cuts to the point, and says \"I'm simply in the business of statistics, and " + "I like your growth potential. I think that you can take my %s now and pay " + "%s back to me in, oh, %s days. If not, \"" + this.getHeOrShe() + " mimics a stricken look, \"I'll ruin your reputation across Tri-Tachyon space. What do you say?\"";
    }

    protected String[] getMainTextTokens() {
        return new String[]{Misc.getDGSCredits(this.loanAmount), Misc.getDGSCredits(this.repaymentAmount), "" + this.repaymentDays};
    }

    protected Color[] getMainTextColors() {
        return new Color[]{Misc.getHighlightColor(), Misc.getHighlightColor(), Misc.getHighlightColor()};
    }

    protected String getConfirmText() {
        return "Accept the deal and order another round to celebrate";
    }

    protected String getCancelText() {
        return "Decline the deal, explaining that you're \"just here to network\"";
    }

    protected String getNegotiatedText() {
        return "The Tri-Tachyon " + this.getManOrWoman() + "'s smile freezes in place as you launch into a sophisticated " + " pitch to modify the proposed terms. You notice " + this.getHisOrHer() + " eyes tracking rapidly, navigating some ocular data interface as you speak; " + this.getHeOrShe() + " seems thrown off-balance by your savvy, and never quite recovers that signature megacorp implacability." + " By the time it is agreed that a substantially lower repayment figure will benefit all parties, the dazed " + "investor finds " + this.getHisOrHer() + " drink has gone flat. " + this.getHeOrShe() + " brusquely orders a replacement.";
    }

    protected String getAcceptText() {
        return "You leave the lounge rich in credits, having exchanged secure comm keys with the Tri-Tachyon shark and receiving the transfer immediately. Your head spins with plans for how to leverage your new assets - and a bit from the drink, you admit to yourself.";
    }

    public int getLoanAmount() {
        return this.loanAmount;
    }

    public void setLoanAmount(int loanAmount) {
        this.loanAmount = loanAmount;
    }

    public int getRepaymentAmount() {
        return this.repaymentAmount;
    }

    public void setRepaymentAmount(int repaymentAmount) {
        this.repaymentAmount = repaymentAmount;
    }

    public int getRepaymentDays() {
        return this.repaymentDays;
    }

    public void setRepaymentDays(int repaymentDays) {
        this.repaymentDays = repaymentDays;
    }

    protected boolean showCargoCap() {
        return false;
    }
}

