/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events.historian;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOffer;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.HistorianData;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseHistorianOfferCreator
implements HistorianData.HistorianOfferCreator {
    protected float frequency = 10.0f;

    @Override
    public HistorianData.HistorianOffer createOffer(Random random, List<HistorianData.HistorianOffer> soFar) {
        return null;
    }

    @Override
    public boolean ignoresLimit() {
        return false;
    }

    @Override
    public float getFrequency() {
        return this.frequency;
    }

    public void setFrequency(float frequency) {
        this.frequency = frequency;
    }

    public SectorEntityToken pickEntity(Random random, boolean allowDerelict) {
        WeightedRandomPicker<SectorEntityToken> picker = new WeightedRandomPicker<SectorEntityToken>(random);
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            if (system.hasTag("theme_core_populated") || !allowDerelict && system.hasTag("theme_derelict") || !system.hasTag("theme_derelict") && !system.hasTag("theme_ruins") && !system.hasTag("theme_remnant")) continue;
            for (SectorEntityToken entity : system.getEntitiesWithTag("salvageable")) {
                float w = 1.0f;
                if (entity.hasTag("expires") || entity.hasTag("not_random_mission_target") || entity.getCircularOrbitRadius() > 10000.0f) continue;
                picker.add(entity, w);
            }
        }
        return (SectorEntityToken)picker.pick();
    }

    public PlanetAPI pickUnexploredRuins(Random random) {
        WeightedRandomPicker<PlanetAPI> picker = new WeightedRandomPicker<PlanetAPI>(random);
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            if (system.hasTag("theme_core_populated") || !system.hasTag("theme_interesting") && !system.hasTag("theme_interesting_minor")) continue;
            for (PlanetAPI planet : system.getPlanets()) {
                if (planet.isStar() || !Misc.hasUnexploredRuins(planet.getMarket())) continue;
                float w = 1.0f;
                picker.add(planet, w);
            }
        }
        return (PlanetAPI)picker.pick();
    }

    public static SectorEntityToken createEntity(Random random) {
        StarSystemAPI system2;
        WeightedRandomPicker<StarSystemAPI> picker = new WeightedRandomPicker<StarSystemAPI>(random);
        for (StarSystemAPI system2 : Global.getSector().getStarSystems()) {
            float sinceVisit;
            if (system2.hasTag("theme_core_populated") || system2.hasTag("theme_remnant_main") || system2.hasTag("theme_remnant_resurgent") || !system2.hasTag("theme_interesting") && !system2.hasTag("theme_interesting_minor") || (sinceVisit = Global.getSector().getClock().getElapsedDaysSince(system2.getLastPlayerVisitTimestamp())) < 360.0f) continue;
            picker.add(system2);
        }
        system2 = (StarSystemAPI)picker.pick();
        if (system2 == null) {
            return null;
        }
        BaseThemeGenerator.EntityLocation loc = BaseThemeGenerator.pickHiddenLocationNotNearStar(random, system2, 100.0f, null);
        if (loc == null) {
            return null;
        }
        BaseThemeGenerator.AddedEntity added = BaseThemeGenerator.addEntity(random, (LocationAPI)system2, loc, "equipment_cache", "neutral");
        if (added == null || added.entity == null) {
            return null;
        }
        added.entity.addTag("expires");
        return added.entity;
    }

    @Override
    public String getOfferId(BaseHistorianOffer offer) {
        return null;
    }

    @Override
    public void notifyAccepted(HistorianData.HistorianOffer offer) {
    }
}

