/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events.historian;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOffer;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOfferWithLocation;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BlueprintOfferCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.FighterBlueprintOffer;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.HistorianData;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FighterBlueprintOfferCreator
extends BlueprintOfferCreator {
    public static String PREFIX = "ftr_";

    public FighterBlueprintOfferCreator(float frequency) {
        super(frequency);
    }

    @Override
    protected BaseHistorianOfferWithLocation createOffer(SectorEntityToken entity, String data) {
        return new FighterBlueprintOffer(entity, data);
    }

    @Override
    protected List<Object> getAllSpecs() {
        return new ArrayList<Object>(Global.getSettings().getAllFighterWingSpecs());
    }

    @Override
    protected String getAlreadyUsedIdFromOffer(HistorianData.HistorianOffer offer) {
        if (offer instanceof FighterBlueprintOffer) {
            FighterBlueprintOffer fbo = (FighterBlueprintOffer)offer;
            return fbo.getData();
        }
        return null;
    }

    @Override
    protected String getIdForSpec(Object spec) {
        return ((FighterWingSpecAPI)spec).getId();
    }

    @Override
    protected Set<String> getTagsForSpec(Object spec) {
        return ((FighterWingSpecAPI)spec).getTags();
    }

    @Override
    protected float getRarityForSpec(Object spec) {
        return ((FighterWingSpecAPI)spec).getRarity();
    }

    @Override
    protected boolean playerKnowsSpecAlready(String id) {
        return Global.getSector().getPlayerFaction().knowsFighter(id);
    }

    @Override
    protected float getProbabilityRuins() {
        return super.getProbabilityRuins();
    }

    @Override
    public String getOfferId(BaseHistorianOffer offer) {
        if (offer instanceof FighterBlueprintOffer) {
            return String.valueOf(PREFIX) + ((FighterBlueprintOffer)offer).getData();
        }
        return null;
    }

    @Override
    public String getBlueprintIdFromOfferId(String offerId) {
        if (offerId.startsWith(PREFIX)) {
            return offerId.replaceAll(PREFIX, "");
        }
        return null;
    }
}

