/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events.historian;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.SpecialItemSpecAPI;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOfferWithLocation;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;

public class SpecialItemOffer
extends BaseHistorianOfferWithLocation {
    protected int points;
    protected String data;

    public SpecialItemOffer(SectorEntityToken entity, int points, String id) {
        super(entity);
        this.points = points;
        this.data = id;
    }

    public void addPromptAndOption(InteractionDialogAPI dialog) {
        SpecialItemSpecAPI spec = Global.getSettings().getSpecialItemSpec(this.data);
        dialog.getOptionPanel().addOption("... the possible location of an item (" + spec.getName() + ")", this);
        SetStoryOption.set(dialog, this.points, this, "historianBP", Sounds.STORY_POINT_SPEND_TECHNOLOGY, "Learned location of " + spec.getName());
    }

    public String getSortString() {
        return "AAA";
    }

    public String getName() {
        SpecialItemSpecAPI spec = Global.getSettings().getSpecialItemSpec(this.data);
        if (this.isEnding()) {
            return String.valueOf(spec.getName()) + " - Recovered";
        }
        return String.valueOf(spec.getName()) + " Location";
    }

    protected void addItemToCargo(CargoAPI loot) {
        loot.addSpecial(new SpecialItemData(this.data, null), 1.0f);
    }

    public String getData() {
        return this.data;
    }
}

