/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bases;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.ids.MemFlags;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.PersonBountyIntel;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarData;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.LuddicPathBaseBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathCellsIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.impl.campaign.procgen.MarkovNames;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuddicPathBaseIntel
extends BaseIntelPlugin
implements EveryFrameScript,
FleetEventListener,
EconomyAPI.EconomyUpdateListener,
RaidIntel.RaidDelegate {
    public static final String PATHER_BASE_COMMANDER = "$patherBaseCommander";
    public static String MEM_FLAG = "$core_luddicPathBase";
    public static Object BOUNTY_EXPIRED_PARAM = new Object();
    public static Object DISCOVERED_PARAM = new Object();
    public static Logger log = Global.getLogger(LuddicPathBaseIntel.class);
    protected PersonAPI baseCommander;
    protected StarSystemAPI system;
    protected MarketAPI market;
    protected SectorEntityToken entity;
    protected float elapsedDays = 0.0f;
    protected float duration = 45.0f;
    protected PirateBaseIntel.BaseBountyData bountyData = null;
    protected IntervalUtil monthlyInterval = new IntervalUtil(20.0f, 40.0f);
    protected int monthsNoBounty = 0;
    protected boolean large = false;
    protected Random random = new Random();
    protected CampaignFleetAPI addedListenerTo = null;
    protected PersonBountyIntel.BountyResult result = null;
    protected boolean sentBountyUpdate = false;

    public static LuddicPathBaseIntel getIntelFor(StarSystemAPI system) {
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(LuddicPathBaseIntel.class)) {
            if (((LuddicPathBaseIntel)intel).getSystem() != system) continue;
            return (LuddicPathBaseIntel)intel;
        }
        return null;
    }

    public LuddicPathBaseIntel(StarSystemAPI system, String factionId) {
        this.system = system;
        this.market = Global.getFactory().createMarket(Misc.genUID(), "Luddic Path Base", 3);
        this.market.setSize(3);
        this.market.setHidden(true);
        this.market.getMemoryWithoutUpdate().set(MEM_FLAG, true);
        this.market.getMemoryWithoutUpdate().set(MemFlags.HIDDEN_BASE_MEM_FLAG, true);
        this.market.setFactionId("luddic_path");
        this.market.setSurveyLevel(MarketAPI.SurveyLevel.FULL);
        this.market.setFactionId(factionId);
        this.market.addCondition("population_3");
        this.market.addIndustry("population");
        this.market.addIndustry("spaceport");
        this.market.addIndustry("militarybase");
        this.market.addSubmarket("open_market");
        this.market.addSubmarket("black_market");
        this.market.getTariff().modifyFlat("default_tariff", this.market.getFaction().getTariffFraction());
        LinkedHashMap<BaseThemeGenerator.LocationType, Float> weights = new LinkedHashMap<BaseThemeGenerator.LocationType, Float>();
        weights.put(BaseThemeGenerator.LocationType.IN_ASTEROID_BELT, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_ASTEROID_FIELD, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_RING, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.IN_SMALL_NEBULA, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.GAS_GIANT_ORBIT, Float.valueOf(10.0f));
        weights.put(BaseThemeGenerator.LocationType.PLANET_ORBIT, Float.valueOf(10.0f));
        WeightedRandomPicker<BaseThemeGenerator.EntityLocation> locs = BaseThemeGenerator.getLocations(null, system, null, 100.0f, weights);
        BaseThemeGenerator.EntityLocation loc = locs.pick();
        if (loc == null) {
            this.endImmediately();
            return;
        }
        BaseThemeGenerator.AddedEntity added = BaseThemeGenerator.addNonSalvageEntity(system, loc, "makeshift_station", factionId);
        if (added == null || added.entity == null) {
            this.endImmediately();
            return;
        }
        this.entity = added.entity;
        String name = this.generateName();
        if (name == null) {
            this.endImmediately();
            return;
        }
        this.market.setName(name);
        this.entity.setName(name);
        BaseThemeGenerator.convertOrbitWithSpin(this.entity, -5.0f);
        this.market.setPrimaryEntity(this.entity);
        this.entity.setMarket(this.market);
        this.entity.setSensorProfile(Float.valueOf(1.0f));
        this.entity.setDiscoverable(true);
        this.entity.getDetectedRangeMod().modifyFlat("gen", 5000.0f);
        this.market.setEconGroup(this.market.getId());
        this.market.getMemoryWithoutUpdate().set("$core_noDeciv", true);
        this.market.reapplyIndustries();
        Global.getSector().getEconomy().addMarket(this.market, true);
        this.baseCommander = this.market.getFaction().createRandomPerson(Misc.random);
        this.baseCommander.setRankId(Ranks.SPACE_CAPTAIN);
        this.baseCommander.setPostId(Ranks.POST_STATION_COMMANDER);
        this.baseCommander.setImportanceAndVoice(PersonImportance.HIGH, Misc.random);
        this.baseCommander.addTag("military");
        this.baseCommander.getMemoryWithoutUpdate().set(PATHER_BASE_COMMANDER, true);
        this.baseCommander.setImportance(PersonImportance.VERY_HIGH);
        this.market.getCommDirectory().addPerson(this.baseCommander);
        Global.getSector().getIntelManager().addIntel(this, true);
        if (!DebugFlags.PATHER_BASE_DEBUG) {
            this.timestamp = null;
        }
        Global.getSector().getListenerManager().addListener(this);
        Global.getSector().getEconomy().addUpdateListener(this);
        this.large = this.random.nextFloat() > 0.5f;
        this.updateStationIfNeeded(this.large);
        PortsideBarData.getInstance().addEvent(new LuddicPathBaseBarEvent(this));
        log.info((Object)String.format("Added luddic path base in [%s], isLarge: %s", system.getName(), "" + this.large));
    }

    @Override
    public boolean isHidden() {
        if (super.isHidden()) {
            return true;
        }
        return this.timestamp == null;
    }

    @Override
    public void notifyRaidEnded(RaidIntel raid, RaidIntel.RaidStageStatus status) {
    }

    public StarSystemAPI getSystem() {
        return this.system;
    }

    protected String pickStationType(boolean large) {
        WeightedRandomPicker<String> stations = new WeightedRandomPicker<String>();
        try {
            JSONObject json = this.getFactionForUIColors().getCustom().getJSONObject("patherBaseTypesSmall");
            if (large) {
                json = this.getFactionForUIColors().getCustom().getJSONObject("patherBaseTypesLarge");
            }
            String[] stringArray = JSONObject.getNames((JSONObject)json);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                stations.add(key, (float)json.optDouble(key, 0.0));
                ++n2;
            }
            if (stations.isEmpty()) {
                stations.add("orbitalstation", 5.0f);
            }
        }
        catch (JSONException e) {
            stations.clear();
        }
        return (String)stations.pick();
    }

    protected Industry getStationIndustry() {
        for (Industry curr : this.market.getIndustries()) {
            if (!curr.getSpec().hasTag("station")) continue;
            return curr;
        }
        return null;
    }

    protected void updateStationIfNeeded(boolean large) {
        Industry stationInd = this.getStationIndustry();
        String currIndId = null;
        if (stationInd != null) {
            currIndId = stationInd.getId();
            this.market.removeIndustry(stationInd.getId(), null, false);
            stationInd = null;
        }
        if (currIndId == null) {
            currIndId = this.pickStationType(large);
        }
        if (currIndId == null) {
            return;
        }
        this.market.addIndustry(currIndId);
        stationInd = this.getStationIndustry();
        if (stationInd == null) {
            return;
        }
        stationInd.finishBuildingOrUpgrading();
        CampaignFleetAPI fleet = Misc.getStationFleet(this.entity);
        if (fleet == null) {
            return;
        }
        List<FleetMemberAPI> members = fleet.getFleetData().getMembersListCopy();
        if (members.size() < 1) {
            return;
        }
        fleet.inflateIfNeeded();
    }

    @Override
    protected void advanceImpl(float amount) {
        CampaignFleetAPI fleet;
        float days = Global.getSector().getClock().convertToDays(amount);
        if (this.getPlayerVisibleTimestamp() == null && this.entity.isInCurrentLocation() && this.isHidden()) {
            this.makeKnown();
            this.sendUpdateIfPlayerHasIntel(DISCOVERED_PARAM, false);
        }
        if (!this.sentBountyUpdate && this.bountyData != null && (Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay() || !this.isHidden() && DebugFlags.SEND_UPDATES_WHEN_NO_COMM)) {
            this.makeKnown();
            this.sendUpdateIfPlayerHasIntel((Object)this.bountyData, false);
            this.sentBountyUpdate = true;
        }
        if ((fleet = Misc.getStationFleet(this.market)) != null && this.addedListenerTo != fleet) {
            if (this.addedListenerTo != null) {
                this.addedListenerTo.removeEventListener(this);
            }
            fleet.addEventListener(this);
            this.addedListenerTo = fleet;
        }
        this.monthlyInterval.advance(days);
        if (this.monthlyInterval.intervalElapsed()) {
            if (this.bountyData == null && this.random.nextFloat() < Math.min(0.3f, (float)this.monthsNoBounty * 0.02f)) {
                this.setBounty();
            } else {
                ++this.monthsNoBounty;
            }
        }
        if (this.bountyData != null) {
            boolean canEndBounty = !this.entity.isInCurrentLocation();
            this.bountyData.bountyElapsedDays += days;
            if (this.bountyData.bountyElapsedDays > this.bountyData.bountyDuration && canEndBounty) {
                this.endBounty();
            }
        }
    }

    public void makeKnown() {
        this.makeKnown(null);
    }

    public void makeKnown(TextPanelAPI text) {
        if (this.getPlayerVisibleTimestamp() == null) {
            Global.getSector().getIntelManager().removeIntel(this);
            Global.getSector().getIntelManager().addIntel(this, text == null, text);
        }
    }

    @Override
    public float getTimeRemainingFraction() {
        float f = 1.0f - this.elapsedDays / this.duration;
        return f;
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        log.info((Object)String.format("Removing luddic path base at [%s]", this.system.getName()));
        Global.getSector().getListenerManager().removeListener(this);
        Global.getSector().getEconomy().removeMarket(this.market);
        Global.getSector().getEconomy().removeUpdateListener(this);
        Misc.removeRadioChatter(this.market);
        this.market.advance(0.0f);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        if (this.isEnding()) {
            return;
        }
        if (this.addedListenerTo != null && fleet == this.addedListenerTo) {
            BattleAPI battle;
            Misc.fadeAndExpire(this.entity);
            this.endAfterDelay();
            this.result = new PersonBountyIntel.BountyResult(PersonBountyIntel.BountyResultType.END_OTHER, 0, null);
            if (reason == CampaignEventListener.FleetDespawnReason.DESTROYED_BY_BATTLE && param instanceof BattleAPI && (battle = (BattleAPI)param).isPlayerInvolved()) {
                int payment = 0;
                if (this.bountyData != null) {
                    payment = (int)(this.bountyData.baseBounty * battle.getPlayerInvolvementFraction());
                }
                if (payment > 0) {
                    Global.getSector().getPlayerFleet().getCargo().getCredits().add(payment);
                    CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
                    impact.delta = this.bountyData.repChange * battle.getPlayerInvolvementFraction();
                    if (impact.delta < 0.01f) {
                        impact.delta = 0.01f;
                    }
                    ReputationActionResponsePlugin.ReputationAdjustmentResult rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, null, false, true), this.bountyData.bountyFaction.getId());
                    this.result = new PersonBountyIntel.BountyResult(PersonBountyIntel.BountyResultType.END_PLAYER_BOUNTY, payment, rep);
                } else {
                    this.result = new PersonBountyIntel.BountyResult(PersonBountyIntel.BountyResultType.END_PLAYER_NO_REWARD, 0, null);
                }
            }
            boolean sendUpdate = DebugFlags.SEND_UPDATES_WHEN_NO_COMM || this.result.type != PersonBountyIntel.BountyResultType.END_OTHER || Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay();
            sendUpdate = true;
            if (sendUpdate) {
                this.sendUpdateIfPlayerHasIntel((Object)this.result, false);
            }
            for (LuddicPathCellsIntel cell : LuddicPathCellsIntel.getCellsForBase(this, false)) {
                cell.makeSleeper(Global.getSettings().getFloat("patherCellDisruptionDuration"));
                if (cell.getMarket().isPlayerOwned() || DebugFlags.PATHER_BASE_DEBUG) {
                    cell.sendUpdateIfPlayerHasIntel(LuddicPathCellsIntel.UPDATE_DISRUPTED, false);
                }
                ListenerUtil.reportCellDisrupted(cell);
            }
            PirateBaseManager.markRecentlyUsedForBase(this.system);
            LuddicPathBaseManager.getInstance().incrDestroyed();
        }
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (this.bountyData != null && this.result == null && this.getListInfoParam() != BOUNTY_EXPIRED_PARAM) {
            if (isUpdate || mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
                FactionAPI faction = this.bountyData.bountyFaction;
                info.addPara("Bounty faction: " + faction.getDisplayName(), initPad, tc, faction.getBaseUIColor(), faction.getDisplayName());
                initPad = 0.0f;
            }
            info.addPara("%s reward", initPad, tc, h, Misc.getDGSCredits(this.bountyData.baseBounty));
            this.addDays(info, "remaining", this.bountyData.bountyDuration - this.bountyData.bountyElapsedDays, tc);
        }
        if (this.result != null && this.bountyData != null) {
            switch (this.result.type) {
                case END_PLAYER_BOUNTY: {
                    info.addPara("%s received", initPad, tc, h, Misc.getDGSCredits(this.result.payment));
                    CoreReputationPlugin.addAdjustmentMessage(this.result.rep.delta, this.bountyData.bountyFaction, null, null, null, info, tc, isUpdate, 0.0f);
                    break;
                }
                case END_TIME: {
                    break;
                }
            }
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public String getSortString() {
        String base = Misc.ucFirst(this.getFactionForUIColors().getPersonNamePrefix());
        return String.valueOf(base) + " Base";
    }

    @Override
    public String getName() {
        String base = Misc.ucFirst(this.getFactionForUIColors().getPersonNamePrefix());
        if (this.getListInfoParam() == this.bountyData && this.bountyData != null) {
            return String.valueOf(base) + " Base - Bounty Posted";
        }
        if (this.getListInfoParam() == BOUNTY_EXPIRED_PARAM) {
            return String.valueOf(base) + " Base - Bounty Expired";
        }
        if (this.result != null) {
            if (this.result.type == PersonBountyIntel.BountyResultType.END_PLAYER_BOUNTY) {
                return String.valueOf(base) + " Base - Bounty Completed";
            }
            if (this.result.type == PersonBountyIntel.BountyResultType.END_PLAYER_NO_REWARD) {
                return String.valueOf(base) + " Base - Destroyed";
            }
        }
        String name = this.market.getName();
        if (this.isEnding()) {
            return String.valueOf(base) + " Base - Abandoned";
        }
        if (this.getListInfoParam() == DISCOVERED_PARAM) {
            return String.valueOf(base) + " Base - Discovered";
        }
        if (this.entity.isDiscoverable()) {
            return String.valueOf(base) + " Base - Exact Location Unknown";
        }
        return String.valueOf(base) + " Base - " + name;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.market.getFaction();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        FactionAPI faction = this.market.getFaction();
        info.addImage(faction.getLogo(), width, 128.0f, opad);
        String has = faction.getDisplayNameHasOrHave();
        info.addPara(String.valueOf(Misc.ucFirst(faction.getDisplayNameWithArticle())) + " " + has + " established a base in the " + this.market.getContainingLocation().getNameWithLowercaseType() + ". " + "The base serves to provide material support to active Pather cells on nearby colonies, enabling them " + "to cause widespread damage and destruction.", opad, faction.getBaseUIColor(), faction.getDisplayNameWithArticleWithoutArticle());
        if (!this.entity.isDiscoverable()) {
            if (this.large) {
                info.addPara("It has extremely well-developed defensive capabilities and is protected by a large number of fleets.", opad);
            } else {
                info.addPara("It has well-developed defensive capabilities and is protected by a large number of fleets.", opad);
            }
        } else {
            info.addPara("You have not yet discovered the exact location or capabilities of this base.", opad);
        }
        info.addSectionHeading("Recent events", faction.getBaseUIColor(), faction.getDarkUIColor(), Alignment.MID, opad);
        List<LuddicPathCellsIntel> cells = LuddicPathCellsIntel.getCellsForBase(this, false);
        if (!cells.isEmpty()) {
            float initPad = opad;
            info.addPara("This base is known to be providing support to active Pather cells at the following colonies:", opad);
            for (LuddicPathCellsIntel intel : cells) {
                LuddicPathBaseIntel.addMarketToList(info, intel.getMarket(), initPad, tc);
                initPad = 0.0f;
            }
            initPad = 0.0f;
        } else {
            info.addPara("You do not know of any active pather cells this base might be providing support to.", opad);
        }
        if (this.bountyData != null) {
            info.addPara(String.valueOf(Misc.ucFirst(this.bountyData.bountyFaction.getDisplayNameWithArticle())) + " " + this.bountyData.bountyFaction.getDisplayNameHasOrHave() + " posted a bounty for the destruction of this base.", opad, this.bountyData.bountyFaction.getBaseUIColor(), this.bountyData.bountyFaction.getDisplayNameWithArticleWithoutArticle());
            if (this.result != null && this.result.type == PersonBountyIntel.BountyResultType.END_PLAYER_BOUNTY) {
                info.addPara("You have successfully completed this bounty.", opad);
            }
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        }
        if (this.result != null) {
            if (this.result.type == PersonBountyIntel.BountyResultType.END_PLAYER_NO_REWARD) {
                info.addPara("You have destroyed this base.", opad);
            } else if (this.result.type == PersonBountyIntel.BountyResultType.END_OTHER) {
                info.addPara("It is rumored that this base is no longer operational.", opad);
            }
        }
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "pather_base");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        if (this.bountyData != null) {
            tags.add("Bounties");
        }
        tags.add("Exploration");
        for (LuddicPathCellsIntel cell : LuddicPathCellsIntel.getCellsForBase(this, true)) {
            if (!cell.getMarket().isPlayerOwned()) continue;
            tags.add("Colony threats");
            break;
        }
        tags.add(this.market.getFactionId());
        if (this.bountyData != null) {
            tags.add(this.bountyData.bountyFaction.getId());
        }
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.market.getPrimaryEntity().isDiscoverable()) {
            return this.system.getCenter();
        }
        return this.market.getPrimaryEntity();
    }

    protected String generateName() {
        MarkovNames.loadIfNeeded();
        MarkovNames.MarkovNameResult gen = null;
        int i = 0;
        while (i < 10) {
            String test;
            gen = MarkovNames.generate(null);
            if (gen != null && !(test = gen.name).toLowerCase().startsWith("the ")) {
                String p = this.pickPostfix();
                if (p != null && !p.isEmpty()) {
                    test = String.valueOf(test) + " " + p;
                }
                if (test.length() <= 22) {
                    return test;
                }
            }
            ++i;
        }
        return null;
    }

    private String pickPostfix() {
        WeightedRandomPicker<String> post = new WeightedRandomPicker<String>();
        post.add("Asylum");
        post.add("Citadel");
        post.add("Hammer");
        post.add("Harbor");
        post.add("Haven");
        post.add("Hold");
        post.add("Locus");
        post.add("Nexus");
        post.add("Refuge");
        post.add("Sanctuary");
        post.add("Sanctum");
        post.add("Shadow");
        post.add("Shelter");
        post.add("Safehold");
        post.add("Terminus");
        post.add("Principle");
        post.add("Offering");
        post.add("Devotion");
        post.add("Atonement");
        post.add("Cleansing");
        post.add("Oblation");
        post.add("Sacrement");
        return (String)post.pick();
    }

    @Override
    public void commodityUpdated(String commodityId) {
        CommodityOnMarketAPI com = this.market.getCommodityData(commodityId);
        int curr = 0;
        String modId = this.market.getId();
        MutableStat.StatMod mod = com.getAvailableStat().getFlatStatMod(modId);
        if (mod != null) {
            curr = Math.round(mod.value);
        }
        int a = com.getAvailable() - curr;
        int d = com.getMaxDemand();
        if (d > a) {
            com.getAvailableStat().modifyFlat(modId, d - a, "Brought in by smugglers");
        }
    }

    @Override
    public void economyUpdated() {
        float qualityBonus = 0.0f;
        int light = 0;
        int medium = 0;
        int heavy = 0;
        if (this.large) {
            qualityBonus = 0.5f;
            light = 4;
            medium = 4;
            heavy = 3;
        } else {
            qualityBonus = 0.0f;
            light = 3;
            medium = 2;
            heavy = 1;
        }
        this.market.getStats().getDynamic().getMod("fleet_quality_mod").modifyFlatAlways(this.market.getId(), qualityBonus, "Development level");
        float fleetSizeBonus = 0.5f;
        if (this.large) {
            fleetSizeBonus = 1.0f;
        }
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyFlatAlways(this.market.getId(), fleetSizeBonus, "Development level");
        String modId = this.market.getId();
        this.market.getStats().getDynamic().getMod("patrol_num_light_mod").modifyFlat(modId, light);
        this.market.getStats().getDynamic().getMod("patrol_num_medium_mod").modifyFlat(modId, medium);
        this.market.getStats().getDynamic().getMod("patrol_num_heavy_mod").modifyFlat(modId, heavy);
    }

    @Override
    public boolean isEconomyListenerExpired() {
        return this.isEnded();
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    protected void setBounty() {
        List<IntelInfoPlugin> bases = Global.getSector().getIntelManager().getIntel(LuddicPathBaseIntel.class);
        for (IntelInfoPlugin curr : bases) {
            LuddicPathBaseIntel intel = (LuddicPathBaseIntel)curr;
            if (intel == this || intel.bountyData == null) continue;
            return;
        }
        this.bountyData = new PirateBaseIntel.BaseBountyData();
        float base = 100000.0f;
        if (this.large) {
            base = Global.getSettings().getFloat("luddicPathBaseBountyLarge");
            this.bountyData.repChange = 0.05f;
        } else {
            base = Global.getSettings().getFloat("luddicPathBaseBountySmall");
            this.bountyData.repChange = 0.1f;
        }
        this.bountyData.baseBounty = base * (0.9f + (float)Math.random() * 0.2f);
        this.bountyData.baseBounty = (int)(this.bountyData.baseBounty / 10000.0f) * 10000;
        WeightedRandomPicker<FactionAPI> picker = new WeightedRandomPicker<FactionAPI>();
        for (LuddicPathCellsIntel cell : LuddicPathCellsIntel.getCellsForBase(this, false)) {
            FactionAPI faction = cell.getMarket().getFaction();
            picker.add(faction, (float)Math.pow(2.0, cell.getMarket().getSize()));
        }
        FactionAPI faction = (FactionAPI)picker.pick();
        if (faction == null || faction.isPlayerFaction()) {
            this.bountyData = null;
            return;
        }
        this.bountyData.bountyFaction = faction;
        this.bountyData.bountyDuration = 180.0f;
        this.bountyData.bountyElapsedDays = 0.0f;
        this.monthsNoBounty = 0;
        Misc.makeImportant(this.entity, "baseBounty");
        this.sentBountyUpdate = false;
    }

    protected void endBounty() {
        this.sendUpdateIfPlayerHasIntel(BOUNTY_EXPIRED_PARAM, false);
        this.bountyData = null;
        this.monthsNoBounty = 0;
        Misc.makeUnimportant(this.entity, "baseBounty");
        this.sentBountyUpdate = false;
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        return null;
    }

    public SectorEntityToken getEntity() {
        return this.entity;
    }

    public boolean isLarge() {
        return this.large;
    }

    public PersonAPI getBaseCommander() {
        return this.baseCommander;
    }

    public void setBaseCommander(PersonAPI baseCommander) {
        this.baseCommander = baseCommander;
    }
}

