/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bases;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.econ.RecentUnrest;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathCells;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuddicPathCellsIntel
extends BaseIntelPlugin
implements RouteManager.RouteFleetSpawner,
FleetEventListener {
    public static String USED_PLANETBUSTER_KEY = "$core_lpUsedPlanetbuster";
    public static float INCIDENT_PROB = Global.getSettings().getFloat("luddicPathCellsIncidentProbabilityPerMonth");
    public static float MIN_WARNING_DAYS = Global.getSettings().getFloat("luddicPathCellsIncidentWarningMinDays");
    public static float MIN_SABOTAGE = Global.getSettings().getFloatFromArray("luddicPathSabotageDays", 0);
    public static float MAX_SABOTAGE = Global.getSettings().getFloatFromArray("luddicPathSabotageDays", 1);
    public static Object UPDATE_DISSOLVED = new Object();
    public static Object UPDATE_DISRUPTED = new Object();
    public static Object INCIDENT_PREP = new Object();
    public static Object INCIDENT_PREVENTED = new Object();
    public static Object INCIDENT_HAPPENED = new Object();
    protected boolean sleeper = false;
    protected float sleeperTimeout = 0.0f;
    protected MarketAPI market;
    protected IntervalUtil incidentTracker = new IntervalUtil(20.0f, 40.0f);
    protected Random random = new Random();
    protected int numIncidentAttempts = 0;
    protected float incidentDelay = 0.0f;
    protected IncidentType incidentType = null;
    protected RouteManager.RouteData smuggler = null;
    protected IncidentType prevIncident = null;
    protected boolean prevIncidentSucceeded = false;
    protected float sincePrevIncident = 0.0f;
    protected Object prevIncidentData = null;
    protected float inertiaTime = 0.0f;

    public LuddicPathCellsIntel(MarketAPI market, boolean sleeper) {
        this.market = market;
        this.sleeper = sleeper;
        if (!market.isPlayerOwned()) {
            this.setPostingLocation(market.getPrimaryEntity());
        }
        if (!market.hasCondition("pather_cells")) {
            market.addCondition("pather_cells", this);
        }
        Global.getSector().addScript(this);
        if (market.isPlayerOwned() || DebugFlags.PATHER_BASE_DEBUG) {
            Global.getSector().getIntelManager().addIntel(this);
        } else {
            Global.getSector().getIntelManager().queueIntel(this);
        }
    }

    public static LuddicPathBaseIntel getClosestBase(MarketAPI market) {
        List<IntelInfoPlugin> bases = Global.getSector().getIntelManager().getIntel(LuddicPathBaseIntel.class);
        float minDist = Float.MAX_VALUE;
        LuddicPathBaseIntel closest = null;
        for (IntelInfoPlugin curr : bases) {
            LuddicPathBaseIntel intel = (LuddicPathBaseIntel)curr;
            float dist = Misc.getDistance(intel.getMarket().getLocationInHyperspace(), market.getLocationInHyperspace());
            if (!(dist < minDist)) continue;
            minDist = dist;
            closest = intel;
        }
        return closest;
    }

    public static List<LuddicPathCellsIntel> getCellsForBase(LuddicPathBaseIntel base, boolean includeSleeper) {
        ArrayList<LuddicPathCellsIntel> result = new ArrayList<LuddicPathCellsIntel>();
        List<IntelInfoPlugin> cells = Global.getSector().getIntelManager().getIntel(LuddicPathCellsIntel.class);
        for (IntelInfoPlugin curr : cells) {
            LuddicPathCellsIntel intel = (LuddicPathCellsIntel)curr;
            if (!includeSleeper && intel.isSleeper() || LuddicPathCellsIntel.getClosestBase(intel.getMarket()) != base) continue;
            result.add(intel);
        }
        return result;
    }

    public static LuddicPathCellsIntel getCellsForMarket(MarketAPI market) {
        if (market == null) {
            return null;
        }
        List<IntelInfoPlugin> cells = Global.getSector().getIntelManager().getIntel(LuddicPathCellsIntel.class);
        for (IntelInfoPlugin curr : cells) {
            LuddicPathCellsIntel intel = (LuddicPathCellsIntel)curr;
            if (intel.getMarket() != market) continue;
            return intel;
        }
        return null;
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    @Override
    public boolean canMakeVisibleToPlayer(boolean playerInRelayRange) {
        return super.canMakeVisibleToPlayer(playerInRelayRange);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript(this);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        if (this.market.hasCondition("pather_cells")) {
            this.market.removeCondition("pather_cells");
        }
    }

    public void makeSleeper() {
        this.makeSleeper(-1.0f);
    }

    public void makeSleeper(float sleeperTimeout) {
        if (sleeperTimeout >= 0.0f) {
            this.sleeperTimeout = sleeperTimeout;
        }
        this.sleeper = true;
    }

    public void makeActiveIfPossible() {
        if (this.sleeperTimeout <= 0.0f) {
            this.sleeper = false;
        }
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        float days = Misc.getDays(amount);
        this.inertiaTime += days;
        if (this.sleeperTimeout > 0.0f) {
            this.sleeperTimeout -= days;
            if (this.sleeperTimeout < 0.0f) {
                this.sleeperTimeout = 0.0f;
            }
        }
        if (!this.market.isInEconomy()) {
            this.endImmediately();
            return;
        }
        if (this.isSleeper()) {
            return;
        }
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
            LuddicPathCellsIntel.addMarketToList(info, this.market, initPad, tc);
            initPad = 0.0f;
        }
        if (isUpdate && this.getListInfoParam() == INCIDENT_HAPPENED) {
            if (!this.prevIncidentSucceeded) {
                info.addPara("Incident averted by local security forces", initPad);
            } else {
                switch (this.prevIncident) {
                    case INDUSTRY_SABOTAGE: {
                        Industry ind = (Industry)this.prevIncidentData;
                        String days = this.getDays(ind.getDisruptedDays());
                        String daysStr = LuddicPathCellsIntel.getDaysString(ind.getDisruptedDays());
                        info.addPara(String.valueOf(ind.getCurrentName()) + " operations disrupted for %s " + daysStr, initPad, tc, h, days);
                        break;
                    }
                    case REDUCED_STABILITY: {
                        info.addPara("Stability reduced by %s", initPad, tc, h, "" + (Integer)this.prevIncidentData);
                        break;
                    }
                    case PLANETBUSTER: {
                        info.addPara("Colony destroyed by planetbuster", initPad, tc, new String[0]);
                    }
                }
            }
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    public void addInterestInfo(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        float opad = 10.0f;
        info.addSectionHeading("Pather interest", this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), Alignment.MID, opad);
        info.addPara("The following activity is attracting Pather interest, whether due to AI core use or the inherent nature of the industry:", opad);
        ArrayList<Industry> industries = new ArrayList<Industry>(this.market.getIndustries());
        Iterator iter = industries.iterator();
        while (iter.hasNext()) {
            if (!((Industry)iter.next()).isHidden()) continue;
            iter.remove();
        }
        Collections.sort(industries, new Comparator<Industry>(){

            @Override
            public int compare(Industry o1, Industry o2) {
                float s1 = o1.getPatherInterest();
                float s2 = o2.getPatherInterest();
                return (int)Math.signum(s2 - s1);
            }
        });
        String indent = "    ";
        float initPad = 5.0f;
        boolean added = false;
        String aiCoreId = this.market.getAdmin().getAICoreId();
        if (aiCoreId != null) {
            int s = Math.round(LuddicPathBaseManager.AI_CORE_ADMIN_INTEREST);
            if (this.market.getAdmin().getMemoryWithoutUpdate().getBoolean("$suspectedAI")) {
                info.addPara(String.valueOf(indent) + "Suspected AI core administrator (%s)", initPad, h, "" + s);
            } else {
                info.addPara(String.valueOf(indent) + "AI core administrator (%s)", initPad, h, "" + s);
            }
            initPad = 3.0f;
            added = true;
        }
        for (Industry ind : industries) {
            float score = ind.getPatherInterest();
            if (!(score > 0.0f)) continue;
            int s = Math.round(score);
            info.addPara(String.valueOf(indent) + ind.getCurrentName() + " (%s)", initPad, h, "" + s);
            initPad = 3.0f;
            added = true;
        }
        if (!added) {
            info.addPara(String.valueOf(indent) + "None", initPad);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        block31: {
            block33: {
                float opad;
                block32: {
                    String days;
                    Color h = Misc.getHighlightColor();
                    Color g = Misc.getGrayColor();
                    Color tc = Misc.getTextColor();
                    float pad = 3.0f;
                    opad = 10.0f;
                    if (width > 0.0f) {
                        info.addImage(this.getFactionForUIColors().getLogo(), width, 128.0f, opad);
                    }
                    if (this.isEnding()) {
                        info.addPara("The Pather cells " + this.market.getOnOrAt() + " " + this.market.getName() + " have been dissolved.", opad);
                    } else if (this.isSleeper() && this.sleeperTimeout <= 0.0f) {
                        info.addPara("There are indications that sleeper Luddic Path cells are being organized " + this.market.getOnOrAt() + " " + this.market.getName() + ".", opad);
                        info.addPara("The Pathers have not made any significant moves, but are apparently preparing to do so if whatever activity they object to - industrial development, or the suspected use of AI cores, and other such - continues.", opad);
                    } else {
                        info.addPara("There are active Luddic Path cells " + this.market.getOnOrAt() + " " + this.market.getName() + ".", opad);
                        info.addPara("They are engaged in planning acts of terror and industrial sabotage, but are unlikely to carry them off unless the overal level of hostile activity in the system provides sufficient cover. The cells also provide intel to Pather fleets operating in-system.", opad);
                        if (this.sleeperTimeout > 0.0f) {
                            int daysNum = Math.round(this.sleeperTimeout);
                            if (daysNum < 1) {
                                daysNum = 1;
                            }
                            days = LuddicPathCellsIntel.getDaysString(daysNum);
                            info.addPara("However, the base supporting these cells is no longer operational. It is projected that establishing a new support network will take at least %s " + days + ", provided another base exists.", opad, h, "" + daysNum);
                        } else {
                            LuddicPathBaseIntel base = LuddicPathCellsIntel.getClosestBase(this.market);
                            if (base != null) {
                                if (base.isPlayerVisible()) {
                                    info.addPara("The Pather base at the " + base.getMarket().getStarSystem().getNameWithLowercaseType() + " is providing support to these cells.", opad);
                                } else {
                                    info.addPara("You do not know the location of the Pather base providing support to these cells.", opad);
                                }
                                info.addPara("If the base is destroyed, it will take some time to organize support from another base, and both ground and fleet operations will be disrupted.", opad);
                            }
                        }
                    }
                    if (!this.isEnding()) {
                        info.addSectionHeading("Impact", this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), Alignment.MID, opad);
                        if (!this.isSleeper()) {
                            float stability = LuddicPathCells.STABLITY_PENALTY;
                            info.addPara("%s stability.", opad, h, "-" + (int)stability);
                        } else if (this.sleeperTimeout <= 0.0f) {
                            info.addPara("No perceptible impact on operations as of yet.", opad);
                        } else {
                            info.addPara("No impact on operations due to lack of material support.", opad);
                        }
                    }
                    if (this.prevIncident == null && this.incidentType != IncidentType.PLANETBUSTER) break block31;
                    info.addSectionHeading("Recent events", this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), Alignment.MID, opad);
                    if (!this.prevIncidentSucceeded) break block32;
                    if (this.incidentType == IncidentType.PLANETBUSTER) {
                        info.addPara("There are indications that the Pather cells are preparing to sneak a planetbuster onto " + this.market.getName() + ". " + "If they succeed, the colony will effectively be destroyed.", opad);
                        break block33;
                    } else if (this.prevIncident != null) {
                        switch (this.prevIncident) {
                            case INDUSTRY_SABOTAGE: {
                                Industry ind;
                                if (!(this.prevIncidentData instanceof Industry) || !((ind = (Industry)this.prevIncidentData).getDisruptedDays() > 2.0f)) break;
                                days = this.getDays(ind.getDisruptedDays());
                                String daysStr = LuddicPathCellsIntel.getDaysString(ind.getDisruptedDays());
                                info.addPara("The Pather cells have conducted a successful act of sabotage, disrupting " + ind.getCurrentName() + " operations for %s " + daysStr + ".", opad, h, days);
                                break;
                            }
                            case REDUCED_STABILITY: {
                                info.addPara("The Pather cells have conducted low-level attacks on various industrial, military, and civilian targets, reducing stability by %s.", opad, h, "" + (Integer)this.prevIncidentData);
                                break;
                            }
                            case PLANETBUSTER: {
                                info.addPara("The Pather cells have smuggled a planetbuster onto " + this.market.getName() + " and detonated it. The colony has been effectively destroyed.", opad);
                            }
                            default: {
                                break;
                            }
                        }
                    }
                    break block33;
                }
                if (this.prevIncident != null) {
                    switch (this.prevIncident) {
                        case INDUSTRY_SABOTAGE: {
                            if (!(this.prevIncidentData instanceof Industry)) break;
                            Industry ind = (Industry)this.prevIncidentData;
                            info.addPara("An attempted act of sabotage against " + ind.getCurrentName() + " operations was averted by the local security forces.", opad);
                            break;
                        }
                        case REDUCED_STABILITY: {
                            info.addPara("Multiple planned attacks against various industrial, military, and civilian targets  were averted by the local security forces.", opad);
                            break;
                        }
                        case PLANETBUSTER: {
                            info.addPara("The Pather cells have smuggled a planetbuster onto " + this.market.getName() + ", but the local security forces were able to locate and disarm it, thereby " + "saving the colony.", opad);
                            break;
                        }
                    }
                }
            }
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        }
        if (!this.isEnding()) {
            this.addInterestInfo(info, width, height);
        }
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        SectorEntityToken iconEntity;
        if (this.sleeperTimeout > 0.0f) {
            return null;
        }
        LuddicPathBaseIntel base = LuddicPathCellsIntel.getClosestBase(this.market);
        if (base == null || !base.isPlayerVisible()) {
            return null;
        }
        ArrayList<IntelInfoPlugin.ArrowData> result = new ArrayList<IntelInfoPlugin.ArrowData>();
        SectorEntityToken entityFrom = base.getMapLocation(map);
        if (map != null && (iconEntity = map.getIntelIconEntity(base)) != null) {
            entityFrom = iconEntity;
        }
        IntelInfoPlugin.ArrowData arrow = new IntelInfoPlugin.ArrowData(entityFrom, this.market.getPrimaryEntity());
        arrow.color = this.getFactionForUIColors().getBaseUIColor();
        result.add(arrow);
        return result;
    }

    @Override
    public String getIcon() {
        if (this.isSleeper()) {
            return Global.getSettings().getSpriteName("intel", "sleeper_cells");
        }
        return Global.getSettings().getSpriteName("intel", "active_cells");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("luddic_path");
        if (this.market.isPlayerOwned()) {
            tags.add("Colony threats");
        }
        return tags;
    }

    @Override
    public String getSortString() {
        String base = Misc.ucFirst(this.getFactionForUIColors().getPersonNamePrefix());
        if (this.sleeper) {
            return String.valueOf(base) + " D";
        }
        return String.valueOf(base) + " C";
    }

    @Override
    public String getName() {
        String base = "Luddic Path Cells";
        if (this.isSendingUpdate() && this.getListInfoParam() == INCIDENT_HAPPENED) {
            if (this.prevIncidentSucceeded) {
                return String.valueOf(base) + " - Incident";
            }
            return String.valueOf(base) + " - Incident Averted";
        }
        if (this.isEnding()) {
            return String.valueOf(base) + " - Dissolved";
        }
        if (this.sleeperTimeout > 0.0f) {
            return String.valueOf(base) + " - Disrupted";
        }
        if (this.isSleeper()) {
            return String.valueOf(base) + " - Sleeper";
        }
        return String.valueOf(base) + " - Active";
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return Global.getSector().getFaction("luddic_path");
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.market.getPrimaryEntity();
    }

    @Override
    public String getCommMessageSound() {
        return super.getCommMessageSound();
    }

    public boolean isSleeper() {
        if ("player".equals(this.market.getFactionId()) && HA_CMD.playerHasPatherAgreement()) {
            return true;
        }
        return this.sleeper;
    }

    public void setSleeper(boolean sleeper) {
        this.sleeper = sleeper;
    }

    public float getSleeperTimeout() {
        return this.sleeperTimeout;
    }

    public void setSleeperTimeout(float sleeperTimeout) {
        this.sleeperTimeout = sleeperTimeout;
    }

    public String getRouteSourceId() {
        return "econ";
    }

    public void prepareIncident() {
        this.abortIncident();
        LuddicPathBaseIntel base = LuddicPathCellsIntel.getClosestBase(this.getMarket());
        if (base == null) {
            return;
        }
        WeightedRandomPicker<IncidentType> types = new WeightedRandomPicker<IncidentType>(this.random);
        types.add(IncidentType.REDUCED_STABILITY, 10.0f);
        if (this.numIncidentAttempts >= 3 || !this.market.isPlayerOwned()) {
            types.add(IncidentType.INDUSTRY_SABOTAGE, 10.0f);
        }
        this.incidentType = (IncidentType)((Object)types.pick());
        this.incidentDelay = MIN_WARNING_DAYS + this.random.nextFloat() * MIN_WARNING_DAYS;
        if (this.incidentType == IncidentType.PLANETBUSTER) {
            this.incidentDelay = MIN_WARNING_DAYS * 4.0f + this.random.nextFloat() * 30.0f;
            Global.getSector().getMemoryWithoutUpdate().set(USED_PLANETBUSTER_KEY, true, 1500.0f);
        }
    }

    public void beginIncident() {
        LuddicPathBaseIntel base = LuddicPathCellsIntel.getClosestBase(this.getMarket());
        if (base == null) {
            this.abortIncident();
            return;
        }
        this.sendSmuggler(base);
    }

    public void abortIncident() {
        this.incidentDelay = 0.0f;
        this.incidentType = null;
        if (this.smuggler != null && this.smuggler.getActiveFleet() != null) {
            this.smuggler.getActiveFleet().removeEventListener(this);
        }
        this.smuggler = null;
    }

    protected boolean checkSuccess() {
        float pSuccess = 1.0f - this.market.getStabilityValue() * 0.075f;
        return this.random.nextFloat() < pSuccess;
    }

    public void doIncident() {
        if (this.incidentType == null) {
            return;
        }
        this.prevIncidentData = null;
        boolean success = this.checkSuccess();
        if (this.incidentType == IncidentType.REDUCED_STABILITY) {
            if (success) {
                RecentUnrest.get(this.market).add(3, String.valueOf(Misc.ucFirst(Global.getSector().getFaction("luddic_path").getPersonNamePrefix())) + " sabotage");
                this.prevIncidentData = 3;
            }
        } else if (this.incidentType == IncidentType.INDUSTRY_SABOTAGE) {
            WeightedRandomPicker<Industry> picker = new WeightedRandomPicker<Industry>(this.random);
            for (Industry ind : this.market.getIndustries()) {
                if (!ind.canBeDisrupted()) continue;
                picker.add(ind, ind.getPatherInterest());
            }
            Industry target = (Industry)picker.pick();
            if (target == null) {
                this.abortIncident();
                return;
            }
            this.prevIncidentData = target;
            if (success) {
                float disruptionDur = MIN_SABOTAGE + this.random.nextFloat() * (MAX_SABOTAGE - MIN_SABOTAGE);
                target.setDisrupted(disruptionDur, true);
            }
        }
        this.prevIncident = this.incidentType;
        this.sincePrevIncident = 0.0f;
        this.prevIncidentSucceeded = success;
        if ((DebugFlags.SEND_UPDATES_WHEN_NO_COMM || Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay() || this.market.isPlayerOwned()) && (this.market.isPlayerOwned() || this.incidentType == IncidentType.INDUSTRY_SABOTAGE || this.incidentType == IncidentType.PLANETBUSTER)) {
            this.sendUpdateIfPlayerHasIntel(INCIDENT_HAPPENED, false);
        }
        this.abortIncident();
    }

    protected void sendSmuggler(LuddicPathBaseIntel base) {
        String sid = this.getRouteSourceId();
        SectorEntityToken from = base.getMarket().getPrimaryEntity();
        SectorEntityToken to = this.getMarket().getPrimaryEntity();
        EconomyFleetAssignmentAI.EconomyRouteData data = new EconomyFleetAssignmentAI.EconomyRouteData();
        data.from = base.getMarket();
        data.to = this.market;
        data.smuggling = true;
        data.cargoCap = 400.0f;
        data.fuelCap = 200.0f;
        RouteManager.OptionalFleetData extra = new RouteManager.OptionalFleetData(data.from);
        extra.fleetType = "tradeSmuggler";
        RouteManager.RouteData route = RouteManager.getInstance().addRoute(sid, base.getMarket(), Misc.genRandomSeed(), extra, this, data);
        extra.strength = Float.valueOf(50.0f);
        extra.strength = Float.valueOf(Misc.getAdjustedStrength(extra.strength.floatValue(), base.getMarket()));
        float orbitDays = 3.0f + this.random.nextFloat() * 3.0f;
        float travelDays = RouteLocationCalculator.getTravelDays(from, to);
        if (DebugFlags.PATHER_BASE_DEBUG) {
            travelDays *= 0.1f;
        }
        route.addSegment(new RouteManager.RouteSegment(EconomyFleetRouteManager.ROUTE_SRC_LOAD, orbitDays, from));
        route.addSegment(new RouteManager.RouteSegment(EconomyFleetRouteManager.ROUTE_TRAVEL_DST, travelDays, from, to));
        route.addSegment(new RouteManager.RouteSegment(EconomyFleetRouteManager.ROUTE_DST_UNLOAD, orbitDays * 0.5f, to));
        route.addSegment(new RouteManager.RouteSegment(EconomyFleetRouteManager.ROUTE_DST_LOAD, orbitDays * 0.5f, to));
        route.addSegment(new RouteManager.RouteSegment(EconomyFleetRouteManager.ROUTE_TRAVEL_SRC, travelDays, to, from));
        route.addSegment(new RouteManager.RouteSegment(EconomyFleetRouteManager.ROUTE_SRC_UNLOAD, orbitDays, from));
        this.smuggler = route;
    }

    @Override
    public void reportAboutToBeDespawnedByRouteManager(RouteManager.RouteData route) {
    }

    @Override
    public boolean shouldCancelRouteAfterDelayCheck(RouteManager.RouteData route) {
        return false;
    }

    @Override
    public boolean shouldRepeat(RouteManager.RouteData route) {
        return false;
    }

    @Override
    public CampaignFleetAPI spawnFleet(RouteManager.RouteData route) {
        CampaignFleetAPI fleet;
        Random random = new Random();
        if (route.getSeed() != null) {
            random = new Random(route.getSeed());
        }
        if ((fleet = EconomyFleetRouteManager.createTradeRouteFleet(route, random)) == null) {
            return null;
        }
        fleet.getMemoryWithoutUpdate().set("$cfai_doNotIgnorePlayer", true);
        fleet.getMemoryWithoutUpdate().set("$cfai_ignoreOtherFleets", true);
        fleet.addEventListener(this);
        fleet.addScript(new EconomyFleetAssignmentAI(fleet, route));
        return fleet;
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        if (this.smuggler == null || this.smuggler.getActiveFleet() == null) {
            return;
        }
        CampaignFleetAPI active = this.smuggler.getActiveFleet();
        if (!battle.isInvolved(active)) {
            return;
        }
        if (battle.getSideFor(active) != battle.getSideFor(primaryWinner)) {
            this.abortIncident();
        }
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        if (this.smuggler != null && fleet == this.smuggler.getActiveFleet()) {
            this.abortIncident();
        }
    }

    public float getInertiaTime() {
        return this.inertiaTime;
    }

    public void setInertiaTime(float inertiaTime) {
        this.inertiaTime = inertiaTime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IncidentType {
        REDUCED_STABILITY,
        INDUSTRY_SABOTAGE,
        PLANETBUSTER;

    }
}

