/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bases;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateActivity;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PirateActivityIntel
extends BaseIntelPlugin {
    protected StarSystemAPI system;
    protected PirateBaseIntel source;

    public PirateActivityIntel(StarSystemAPI system, PirateBaseIntel source) {
        this.system = system;
        this.source = source;
        boolean hasPlayerMarkets = false;
        for (MarketAPI curr : Global.getSector().getEconomy().getMarkets(system)) {
            hasPlayerMarkets |= curr.isPlayerOwned();
        }
        if (!hasPlayerMarkets) {
            this.setPostingLocation(system.getCenter());
        }
        Global.getSector().addScript(this);
        if (!Misc.getMarketsInLocation(system, "player").isEmpty()) {
            Global.getSector().getIntelManager().addIntel(this);
        } else {
            Global.getSector().getIntelManager().queueIntel(this);
        }
    }

    @Override
    public boolean canMakeVisibleToPlayer(boolean playerInRelayRange) {
        if (DebugFlags.SEND_UPDATES_WHEN_NO_COMM && this.source.isPlayerVisible()) {
            return true;
        }
        return super.canMakeVisibleToPlayer(playerInRelayRange);
    }

    public PirateBaseIntel getSource() {
        return this.source;
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript(this);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        for (MarketAPI curr : this.source.getAffectedMarkets(this.system)) {
            if (!curr.hasCondition("pirate_activity")) continue;
            curr.removeCondition("pirate_activity");
        }
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        if (this.source.isEnding() || this.source.getTarget() != this.system) {
            this.endAfterDelay();
            if (DebugFlags.SEND_UPDATES_WHEN_NO_COMM || Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay()) {
                this.sendUpdateIfPlayerHasIntel(new Object(), false);
            }
            return;
        }
        for (MarketAPI curr : this.source.getAffectedMarkets(this.system)) {
            if (curr.hasCondition("pirate_activity")) continue;
            curr.addCondition("pirate_activity", this.source);
        }
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.getFactionForUIColors().getLogo(), width, 128.0f, opad);
        info.addPara("Pirates have been targeting colonies and shipping in the " + this.system.getNameWithLowercaseType() + ".", opad);
        if (this.source.isPlayerVisible()) {
            info.addPara("The pirates are based out of " + this.source.getMarket().getName() + " in the " + this.source.getSystem().getNameWithLowercaseType() + ".", opad);
        } else {
            float distLY = Misc.getDistanceLY(this.system.getLocation(), this.source.getSystem().getLocation());
            if (distLY < 10.0f) {
                info.addPara("The location of the pirate base is unknown, but it's likely to be somewhere nearby.", opad);
            } else {
                info.addPara("The location of the pirate base is unknown, but there are indications that it's quite distant.", opad);
            }
        }
        info.addSectionHeading("Colonies affected", this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), Alignment.MID, opad);
        MarketConditionAPI condition = null;
        float initPad = opad;
        for (MarketAPI curr : this.source.getAffectedMarkets(this.system)) {
            if (condition == null) {
                condition = curr.getCondition("pirate_activity");
            }
            PirateActivityIntel.addMarketToList(info, curr, initPad, tc);
            initPad = 0.0f;
        }
        if (condition != null) {
            MarketConditionPlugin plugin = condition.getPlugin();
            ((PirateActivity)plugin).createTooltipAfterDescription(info, true);
        }
    }

    public StarSystemAPI getSystem() {
        return this.system;
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "pirate_activity");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("pirates");
        if (!Misc.getMarketsInLocation(this.system, "player").isEmpty()) {
            tags.add("Colony threats");
        }
        return tags;
    }

    @Override
    public String getSortString() {
        String base = Misc.ucFirst(this.getFactionForUIColors().getPersonNamePrefix());
        return String.valueOf(base) + " C";
    }

    @Override
    public String getName() {
        String base = "Pirate Activity";
        if (this.isEnding()) {
            return String.valueOf(base) + " - Over";
        }
        return String.valueOf(base) + " - " + this.system.getBaseName();
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.source.getFactionForUIColors();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.system.getCenter();
    }

    @Override
    public String getCommMessageSound() {
        return PirateActivityIntel.getSoundMinorMessage();
    }
}

