/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.command.WarSimScript;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.EventFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HADefensiveMeasuresFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HAPatherBaseDestroyedFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HAPirateBaseDestroyedFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HAShipsDestroyedFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HAShipsDestroyedFactorHint;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.KantasProtectionPirateActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.KantasWrathPirateActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicPathAgreementHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicPathHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.PirateBasePirateActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.PirateHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.StandardLuddicPathActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.StandardPirateActivityCause2;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import com.fs.starfarer.api.util.Range;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostileActivityEventIntel
extends BaseEventIntel
implements EconomyAPI.EconomyUpdateListener,
FleetEventListener {
    public static String KEY = "$hae_ref";
    public static float FP_PER_POINT = Global.getSettings().getFloat("HA_fleetPointsPerPoint");
    protected float accessibilityPenalty;
    protected float stabilityPenalty;

    public static HostileActivityEventIntel get() {
        return (HostileActivityEventIntel)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public HostileActivityEventIntel() {
        Global.getSector().getEconomy().addUpdateListener(this);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        this.setMaxProgress(500);
        this.addStage((Object)Stage.START, 0);
        this.addStage((Object)Stage.HA_1, 50, BaseEventIntel.StageIconSize.MEDIUM);
        this.addStage((Object)Stage.MINOR_EVENT, 100, BaseEventIntel.StageIconSize.SMALL);
        this.addStage((Object)Stage.HA_2, 150, BaseEventIntel.StageIconSize.MEDIUM);
        this.addStage((Object)Stage.INCREASED_DEFENSES, 200, true, BaseEventIntel.StageIconSize.LARGE);
        this.addStage((Object)Stage.HA_3, 250, BaseEventIntel.StageIconSize.MEDIUM);
        this.addStage((Object)Stage.HA_4, 350, BaseEventIntel.StageIconSize.MEDIUM);
        this.addStage((Object)Stage.HA_EVENT, 500, true, BaseEventIntel.StageIconSize.LARGE);
        this.setRandomized((Object)Stage.MINOR_EVENT, BaseEventIntel.RandomizedStageType.BAD, 50, 75, false, false);
        this.setRandomized((Object)Stage.HA_EVENT, BaseEventIntel.RandomizedStageType.BAD, 400, 450, false);
        this.getDataFor((Object)((Object)Stage.INCREASED_DEFENSES)).sendIntelUpdateOnReaching = false;
        this.addFactor(new HADefensiveMeasuresFactor());
        this.addFactor(new HAShipsDestroyedFactorHint());
        this.addActivity(new PirateHostileActivityFactor(this), new KantasProtectionPirateActivityCause2(this));
        this.addActivity(new PirateHostileActivityFactor(this), new StandardPirateActivityCause2(this));
        this.addActivity(new PirateHostileActivityFactor(this), new PirateBasePirateActivityCause2(this));
        this.addActivity(new PirateHostileActivityFactor(this), new KantasWrathPirateActivityCause2(this));
        this.addActivity(new LuddicPathHostileActivityFactor(this), new LuddicPathAgreementHostileActivityCause2(this));
        this.addActivity(new LuddicPathHostileActivityFactor(this), new StandardLuddicPathActivityCause2(this));
        Global.getSector().getIntelManager().addIntel(this);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getEconomy().removeUpdateListener(this);
        this.cleanUpHostileActivityConditions();
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
    }

    public static Pair<String, Color> getImpactDisplayData(Stage id) {
        Pair<String, Color> p = new Pair<String, Color>();
        if (id == Stage.START) {
            p.one = "minimal";
            p.two = Misc.getPositiveHighlightColor();
        } else if (id == Stage.HA_1) {
            p.one = "low";
            p.two = Misc.getPositiveHighlightColor();
        } else if (id == Stage.HA_2) {
            p.one = "moderate";
            p.two = Misc.getHighlightColor();
        } else if (id == Stage.HA_3) {
            p.one = "high";
            p.two = Misc.getNegativeHighlightColor();
        } else if (id == Stage.HA_4) {
            p.one = "extreme";
            p.two = Misc.getNegativeHighlightColor();
        }
        return p;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        BaseEventIntel.EventStageData esd;
        if (this.addEventFactorBulletPoints(info, mode, isUpdate, tc, initPad)) {
            return;
        }
        if (isUpdate && this.getListInfoParam() instanceof HAERandomEventData) {
            HAERandomEventData data = (HAERandomEventData)this.getListInfoParam();
            if (data.isReset) {
                data.factor.addBulletPointForEventReset(this, data.stage, info, mode, isUpdate, tc, initPad);
            } else {
                data.factor.addBulletPointForEvent(this, data.stage, info, mode, isUpdate, tc, initPad);
            }
            return;
        }
        if (isUpdate && this.getListInfoParam() instanceof BaseEventIntel.EventStageData) {
            esd = (BaseEventIntel.EventStageData)this.getListInfoParam();
            if (EnumSet.of(Stage.START, Stage.HA_1, Stage.HA_2, Stage.HA_3, Stage.HA_4).contains(esd.id)) {
                String delta = "increased";
                if (!this.prevProgressDeltaWasPositive) {
                    delta = "reduced";
                }
                Pair<String, Color> p = HostileActivityEventIntel.getImpactDisplayData((Stage)((Object)esd.id));
                String impact = (String)p.one;
                Color impactColor = (Color)p.two;
                info.addPara("Impact " + delta + " to: %s", initPad, tc, impactColor, impact);
                return;
            }
        }
        if ((esd = this.getLastActiveStage(false)) != null && EnumSet.of(Stage.START, Stage.HA_1, Stage.HA_2, Stage.HA_3, Stage.HA_4).contains(esd.id)) {
            Pair<String, Color> p = HostileActivityEventIntel.getImpactDisplayData((Stage)((Object)esd.id));
            String impact = (String)p.one;
            Color impactColor = (Color)p.two;
            info.addPara("Colony impact: %s", initPad, tc, impactColor, impact);
            return;
        }
    }

    @Override
    public void addStageDescriptionText(TooltipMakerAPI info, float width, Object stageId) {
        float opad = 10.0f;
        float small = 0.0f;
        Color h = Misc.getHighlightColor();
        this.updatePenalties();
        List<HAEStarSystemDangerData> systemData = this.computePlayerSystemDangerData();
        BaseEventIntel.EventStageData stage = this.getDataFor(stageId);
        if (stage == null) {
            return;
        }
        if (stage.rollData instanceof HAERandomEventData) {
            HAERandomEventData data = (HAERandomEventData)stage.rollData;
            data.factor.addStageDescriptionForEvent(this, stage, info);
            return;
        }
        if (this.isStageActiveAndLast(stageId)) {
            if (stageId == Stage.START) {
                info.addPara("Various hostile forces are threatening your colonies. If left unchecked, your hardest-hit colonies will have to devote more resources to defensive measures, reducing their stability and accessibility.", small);
            } else {
                int extra;
                Range affects = new Range(String.valueOf(((Stage)((Object)stageId)).name()) + "_affects");
                int numSystems = (int)Math.max(Math.min((float)systemData.size(), affects.min), (float)Math.round((float)systemData.size() * affects.max));
                int numColonies = 0;
                int num = 0;
                ArrayList<String> systemsList = new ArrayList<String>();
                for (HAEStarSystemDangerData curr : systemData) {
                    numColonies += Misc.getMarketsInLocation(curr.system, "player").size();
                    if (++num <= 3) {
                        systemsList.add(curr.system.getNameWithNoType());
                    }
                    if (num >= numSystems) break;
                }
                if ((extra = numSystems - systemsList.size()) > 0) {
                    systemsList.remove(systemsList.size() - 1);
                    systemsList.add(extra + 1 + " other");
                }
                String isOrAre = "are";
                String coloniesStr = "colonies";
                if (numColonies == 1) {
                    isOrAre = "is";
                    coloniesStr = "colony";
                }
                String systemsStr = "systems";
                if (numSystems == 1) {
                    systemsStr = "system";
                }
                String desc1 = "minor";
                String desc2 = "some";
                if (stageId == Stage.HA_2) {
                    desc1 = "moderate";
                    desc2 = "considerable";
                } else if (stageId == Stage.HA_3) {
                    desc1 = "serious";
                    desc2 = "a lot of";
                } else if (stageId == Stage.HA_4) {
                    desc1 = "extreme";
                    desc2 = "much of their";
                }
                String combined = "Your " + coloniesStr + " in the " + Misc.getAndJoined(systemsList) + " " + systemsStr + " " + isOrAre;
                if (numSystems == systemData.size() && numColonies > 1) {
                    combined = "All of your colonies are";
                }
                info.addPara(String.valueOf(combined) + " forced to make " + desc1 + " concessions to security considerations and devote " + desc2 + " resources to defensive measures. " + "Stability reduced by %s, accessibility reduced by %s.", small, h, "" + (int)this.stabilityPenalty, Math.round(this.accessibilityPenalty * 100.0f) + "%");
            }
            float systemW = 230.0f;
            float threatW = 300.0f;
            info.beginTable(this.getFactionForUIColors(), 20.0f, "Star system", Float.valueOf(systemW), "Danger", Float.valueOf(100.0f), "Primary threats", Float.valueOf(threatW));
            info.makeTableItemsClickable();
            int maxSystemsToList = 4;
            int numListed = 0;
            info.addTableHeaderTooltip(0, "Star system with hostile activity, and the name (or number) of your colonies found there.\n\nUp to four of the hardest-hit systems are listed here.");
            info.addTableHeaderTooltip(1, "Danger level of the stronger fleets likely to be found in the system. Approximate, there may be exceptions. Does not include hostile fleets that may be present there for other reasons.");
            info.addTableHeaderTooltip(2, "The most dangerous types of threats likely to be found in the system. Not comprehensive, and does not include hostile fleets that may be present there for other reasons.");
            for (final HAEStarSystemDangerData sys : systemData) {
                if (sys.sortMag <= 0.0f) continue;
                float mag = sys.sortMag;
                String danger = this.getDangerString(mag);
                int maxThreats = 3;
                int count = 0;
                ArrayList<String> threats = new ArrayList<String>();
                ArrayList<Color> colors = new ArrayList<Color>();
                for (HAEFactorDangerData data : sys.factorData) {
                    if (data.mag <= 0.0f) continue;
                    threats.add(data.factor.getNameForThreatList(count == 0));
                    colors.add(data.factor.getNameColorForThreatList());
                    if (++count >= maxThreats) break;
                }
                String threatStr = Misc.getJoined("", threats);
                LabelAPI label = info.createLabel(threatStr, Misc.getTextColor(), threatW);
                label.setHighlightColors(colors.toArray(new Color[0]));
                label.setHighlight(threats.toArray(new String[0]));
                String systemName = sys.system.getNameWithNoType();
                List<MarketAPI> colonies = Misc.getMarketsInLocation(sys.system, "player");
                String colStr = "";
                colStr = colonies.size() == 1 ? colonies.get(0).getName() : colonies.size() + " colonies";
                systemName = String.valueOf(systemName) + " - " + colStr;
                info.addRowWithGlow(new Object[]{Alignment.LMID, Misc.getBasePlayerColor(), systemName, Alignment.MID, this.getDangerColor(mag), danger, Alignment.MID, null, label});
                info.addTooltipToAddedRow(new BaseFactorTooltip(){

                    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                        float w = tooltip.getWidthSoFar();
                        float h = Math.round(w / 1.6f);
                        tooltip.addSectorMap(w, h, sys.system, 0.0f);
                        tooltip.addPara("Click to open map", Misc.getGrayColor(), 5.0f);
                    }
                }, TooltipMakerAPI.TooltipLocation.LEFT, false);
                info.setIdForAddedRow(sys);
                if (++numListed >= maxSystemsToList) break;
            }
            info.addTable("None", -1, opad);
            info.addSpacer(3.0f);
        }
    }

    @Override
    public void tableRowClicked(IntelUIAPI ui, IntelInfoPlugin.TableRowClickData data) {
        if (data.rowId instanceof HAEStarSystemDangerData) {
            HAEStarSystemDangerData d = (HAEStarSystemDangerData)data.rowId;
            List<MarketAPI> m = Misc.getMarketsInLocation(d.system, "player");
            if (m.size() == 1) {
                ui.showOnMap(m.get(0).getPrimaryEntity());
            } else {
                ui.showOnMap(d.system.getHyperspaceAnchor());
            }
        }
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(Object stageId) {
        final BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd != null && esd.rollData instanceof HAERandomEventData) {
            HAERandomEventData data = (HAERandomEventData)esd.rollData;
            return data.factor.getStageTooltipImpl(this, esd);
        }
        if (esd != null && EnumSet.of(Stage.HA_1, Stage.HA_2, Stage.HA_3, Stage.HA_4).contains(esd.id)) {
            return new BaseFactorTooltip(){

                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    float opad = 10.0f;
                    Range affects = new Range(String.valueOf(((Stage)((Object)esd.id)).name()) + "_affects");
                    Range impact = new Range(String.valueOf(((Stage)((Object)esd.id)).name()) + "_impact");
                    float stability = impact.min;
                    float access = impact.max;
                    if (esd.id == Stage.HA_1) {
                        tooltip.addTitle("Low impact");
                    } else if (esd.id == Stage.HA_2) {
                        tooltip.addTitle("Moderate impact");
                    } else if (esd.id == Stage.HA_3) {
                        tooltip.addTitle("High impact");
                    } else if (esd.id == Stage.HA_4) {
                        tooltip.addTitle("Extreme impact");
                    }
                    tooltip.addPara("Colony stability reduced by %s, accessibility reduced by %s.", opad, Misc.getHighlightColor(), "" + (int)stability, Math.round(access * 100.0f) + "%");
                    if (affects.max >= 1.0f) {
                        tooltip.addPara("All of your colonies are affected.", opad);
                    } else {
                        tooltip.addPara("Affects colonies in %s of your hardest-hit star systems, or in at least %s of your star systems, whichever is higher.", opad, Misc.getHighlightColor(), "" + (int)affects.min, Math.round(affects.max * 100.0f) + "%");
                    }
                    esd.addProgressReq(tooltip, opad);
                }
            };
        }
        if (esd != null && esd.id == Stage.INCREASED_DEFENSES) {
            return new BaseFactorTooltip(){

                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    float opad = 10.0f;
                    tooltip.addTitle("Increased defenses");
                    tooltip.addPara("When this stage is reached, your colonies will implement additional defensive measures, substantially reducing the event's rate of progress.", opad);
                    esd.addProgressReq(tooltip, opad);
                }
            };
        }
        return null;
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("events", "hostile_activity");
    }

    @Override
    protected String getStageIcon(Object stageId) {
        BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd != null && esd.id == Stage.HA_EVENT && esd.rollData != null && "random_event_none".equals(esd.rollData)) {
            return Global.getSettings().getSpriteName("events", "stage_unknown_neutral");
        }
        return super.getStageIcon(stageId);
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltip(Object stageId) {
        BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd != null && esd.id == Stage.HA_EVENT && esd.rollData != null && "random_event_none".equals(esd.rollData)) {
            return new TooltipMakerAPI.TooltipCreator(){

                public boolean isTooltipExpandable(Object tooltipParam) {
                    return false;
                }

                public float getTooltipWidth(Object tooltipParam) {
                    return BaseEventFactor.TOOLTIP_WIDTH;
                }

                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    float opad = 10.0f;
                    Color h = Misc.getHighlightColor();
                    tooltip.addPara("Hostile activity waxes and wanes with time. When this stage is reached, event progress will be reset to a lower value.", opad);
                }
            };
        }
        return super.getStageTooltip(stageId);
    }

    @Override
    protected String getStageIconImpl(Object stageId) {
        BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd == null) {
            return null;
        }
        if (esd.rollData instanceof HAERandomEventData) {
            HAERandomEventData data = (HAERandomEventData)esd.rollData;
            return data.factor.getEventStageIcon(this, esd);
        }
        if (EnumSet.of(Stage.HA_1, new Stage[]{Stage.HA_2, Stage.HA_3, Stage.HA_4, Stage.INCREASED_DEFENSES, Stage.START}).contains(esd.id)) {
            return Global.getSettings().getSpriteName("events", "hostile_activity_" + ((Stage)((Object)esd.id)).name());
        }
        return Global.getSettings().getSpriteName("events", "hostile_activity");
    }

    @Override
    public Color getBarColor() {
        Color color = Misc.getNegativeHighlightColor();
        color = Misc.interpolateColor(color, Color.black, 0.25f);
        return color;
    }

    @Override
    public Color getBarProgressIndicatorColor() {
        return super.getBarProgressIndicatorColor();
    }

    @Override
    protected int getStageImportance(Object stageId) {
        if (stageId == Stage.HA_EVENT) {
            return 1;
        }
        if (stageId == Stage.MINOR_EVENT) {
            return 1;
        }
        return super.getStageImportance(stageId);
    }

    @Override
    protected String getName() {
        return "Hostile Activity";
    }

    @Override
    public boolean isEventProgressANegativeThingForThePlayer() {
        return true;
    }

    public void addActivity(BaseHostileActivityFactor factor, HostileActivityCause2 cause) {
        BaseHostileActivityFactor curr = this.getActivityOfClass(factor.getClass());
        if (curr == null) {
            this.addFactor(factor);
            curr = factor;
        }
        curr.addCause(cause);
    }

    public void removeActivityCause(Class activityClass, Class causeClass) {
        BaseHostileActivityFactor curr = this.getActivityOfClass(activityClass);
        if (curr == null) {
            return;
        }
        HostileActivityCause2 cause = curr.getCauseOfClass(causeClass);
        if (cause == null) {
            return;
        }
        curr.getCauses().remove(cause);
        if (curr.getCauses().isEmpty()) {
            this.removeActivity(curr);
        }
    }

    public HostileActivityCause2 getActivityCause(Class activityClass, Class causeClass) {
        BaseHostileActivityFactor curr = this.getActivityOfClass(activityClass);
        if (curr == null) {
            return null;
        }
        HostileActivityCause2 cause = curr.getCauseOfClass(causeClass);
        if (cause == null) {
            return null;
        }
        return cause;
    }

    public void removeActivity(BaseHostileActivityFactor plugin) {
        this.factors.remove(plugin);
    }

    public void removeActivityOfClass(Class c) {
        Iterator iter = this.factors.iterator();
        while (iter.hasNext()) {
            EventFactor curr = (EventFactor)iter.next();
            if (curr.getClass() != c) continue;
            iter.remove();
        }
    }

    public BaseHostileActivityFactor getActivityOfClass(Class c) {
        for (EventFactor curr : this.factors) {
            if (curr.getClass() != c) continue;
            return (BaseHostileActivityFactor)curr;
        }
        return null;
    }

    public List<HAEStarSystemDangerData> computePlayerSystemDangerData() {
        ArrayList<HAEStarSystemDangerData> systemData = new ArrayList<HAEStarSystemDangerData>();
        for (StarSystemAPI system : Misc.getPlayerSystems(false)) {
            HAEStarSystemDangerData data = this.computeDangerData(system);
            systemData.add(data);
        }
        Collections.sort(systemData, new Comparator<HAEStarSystemDangerData>(){

            @Override
            public int compare(HAEStarSystemDangerData o1, HAEStarSystemDangerData o2) {
                int result = (int)Math.signum(o2.sortMag - o1.sortMag);
                if (result == 0) {
                    result = (int)Math.signum(o2.totalMag - o1.totalMag);
                }
                if (result == 0) {
                    result = (int)Math.signum(o2.system.getId().hashCode() - o1.system.getId().hashCode());
                }
                return result;
            }
        });
        return systemData;
    }

    public HAEStarSystemDangerData computeDangerData(StarSystemAPI system) {
        HAEStarSystemDangerData data = new HAEStarSystemDangerData();
        data.system = system;
        float maxMag = 0.0f;
        float total = 0.0f;
        for (EventFactor factor : this.factors) {
            if (!(factor instanceof BaseHostileActivityFactor)) continue;
            HAEFactorDangerData curr = new HAEFactorDangerData();
            curr.factor = (HostileActivityFactor)((Object)factor);
            curr.mag = ((BaseHostileActivityFactor)factor).getEffectMagnitude(system);
            data.factorData.add(curr);
            maxMag = Math.max(maxMag, curr.mag);
            total += curr.mag;
        }
        data.maxMag = maxMag;
        data.totalMag = total;
        data.sortMag = data.maxMag * 0.75f + data.totalMag * 0.25f;
        Collections.sort(data.factorData, new Comparator<HAEFactorDangerData>(){

            @Override
            public int compare(HAEFactorDangerData o1, HAEFactorDangerData o2) {
                return (int)Math.signum(o2.mag - o1.mag);
            }
        });
        return data;
    }

    public WarSimScript.LocationDanger getDanger(float mag) {
        if (mag <= 0.0f) {
            return WarSimScript.LocationDanger.NONE;
        }
        if (mag < 0.25f) {
            return WarSimScript.LocationDanger.MINIMAL;
        }
        if (mag < 0.5f) {
            return WarSimScript.LocationDanger.LOW;
        }
        if (mag < 0.75f) {
            return WarSimScript.LocationDanger.MEDIUM;
        }
        if (mag < 1.0f) {
            return WarSimScript.LocationDanger.HIGH;
        }
        return WarSimScript.LocationDanger.EXTREME;
    }

    public String getDangerString(float mag) {
        return this.getDangerString(this.getDanger(mag));
    }

    public String getDangerString(WarSimScript.LocationDanger d) {
        switch (d) {
            case EXTREME: {
                return "Extreme";
            }
            case HIGH: {
                return "High";
            }
            case MEDIUM: {
                return "Medium";
            }
            case LOW: {
                return "Low";
            }
            case MINIMAL: {
                return "Minimal";
            }
            case NONE: {
                return "None";
            }
        }
        return "Unknown";
    }

    public Color getDangerColor(float mag) {
        WarSimScript.LocationDanger d = this.getDanger(mag);
        if (d == WarSimScript.LocationDanger.NONE || d == WarSimScript.LocationDanger.MINIMAL) {
            return Misc.getPositiveHighlightColor();
        }
        if (d == WarSimScript.LocationDanger.EXTREME || d == WarSimScript.LocationDanger.HIGH) {
            return Misc.getNegativeHighlightColor();
        }
        return Misc.getHighlightColor();
    }

    public float getVeryApproximateFPStrength(StarSystemAPI system) {
        float mag = this.getTotalActivityMagnitude(system, true);
        return (mag *= this.getProgressFraction()) * 1000.0f;
    }

    public float getTotalActivityMagnitude(StarSystemAPI system) {
        return this.getTotalActivityMagnitude(system, true);
    }

    public float getTotalActivityMagnitude(StarSystemAPI system, boolean capped) {
        float total = 0.0f;
        for (EventFactor factor : this.factors) {
            if (!(factor instanceof BaseHostileActivityFactor)) continue;
            total += ((BaseHostileActivityFactor)factor).getEffectMagnitude(system);
        }
        if (capped && total > 1.0f) {
            total = 1.0f;
        }
        total = (float)Math.round(total * 100.0f) / 100.0f;
        return total;
    }

    @Override
    public void economyUpdated() {
        this.syncHostileActivityConditionsWithEventProgress();
    }

    public void updatePenalties() {
        BaseEventIntel.EventStageData esd = this.getLastActiveStage(false);
        if (esd == null || !EnumSet.of(Stage.HA_1, Stage.HA_2, Stage.HA_3, Stage.HA_4).contains(esd.id)) {
            this.stabilityPenalty = 0.0f;
            this.accessibilityPenalty = 0.0f;
            return;
        }
        Range impact = new Range(String.valueOf(((Stage)((Object)esd.id)).name()) + "_impact");
        this.stabilityPenalty = impact.min;
        this.accessibilityPenalty = impact.max;
    }

    public void syncHostileActivityConditionsWithEventProgress() {
        BaseEventIntel.EventStageData esd = this.getLastActiveStage(false);
        if (esd == null || !EnumSet.of(Stage.HA_1, Stage.HA_2, Stage.HA_3, Stage.HA_4).contains(esd.id)) {
            this.cleanUpHostileActivityConditions();
            return;
        }
        this.updatePenalties();
        Range affects = new Range(String.valueOf(((Stage)((Object)esd.id)).name()) + "_affects");
        List<HAEStarSystemDangerData> sysData = this.computePlayerSystemDangerData();
        int numSystems = (int)Math.max(Math.min((float)sysData.size(), affects.min), (float)Math.round((float)sysData.size() * affects.max));
        int i = 0;
        while (i < sysData.size()) {
            HAEStarSystemDangerData sys = sysData.get(i);
            for (MarketAPI market : Misc.getMarketsInLocation(sys.system, "player")) {
                if (i < numSystems) {
                    if (market.hasCondition("hostile_activity")) continue;
                    market.addCondition("hostile_activity", this);
                    continue;
                }
                if (!market.hasCondition("hostile_activity")) continue;
                market.removeCondition("hostile_activity");
            }
            ++i;
        }
    }

    public void cleanUpHostileActivityConditions() {
        for (MarketAPI curr : Misc.getPlayerMarkets(false)) {
            if (!curr.hasCondition("hostile_activity")) continue;
            curr.removeCondition("hostile_activity");
        }
    }

    public float getAccessibilityPenalty() {
        return this.accessibilityPenalty;
    }

    public float getStabilityPenalty() {
        return this.stabilityPenalty;
    }

    @Override
    public boolean isEconomyListenerExpired() {
        return this.isEnding();
    }

    @Override
    public void commodityUpdated(String commodityId) {
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        if (this.isEnded() || this.isEnding()) {
            return;
        }
        if (!battle.isPlayerInvolved()) {
            return;
        }
        if (Global.getSector().getCurrentLocation() instanceof StarSystemAPI && battle.getPlayerSide().contains(primaryWinner)) {
            StarSystemAPI system = (StarSystemAPI)Global.getSector().getCurrentLocation();
            for (CampaignFleetAPI otherFleet : battle.getNonPlayerSideSnapshot()) {
                if (!otherFleet.isStationMode()) continue;
                BaseIntelPlugin intel = PirateBaseIntel.getIntelFor(system);
                if (intel != null && Misc.getStationFleet(((PirateBaseIntel)intel).getMarket()) == otherFleet && HA_CMD.baseInvolved(system, (PirateBaseIntel)intel)) {
                    int tier = ((PirateBaseIntel)intel).getTier().ordinal();
                    if (tier < 0) {
                        tier = 0;
                    }
                    if (tier > 4) {
                        tier = 4;
                    }
                    int points = -1 * Global.getSettings().getIntFromArray("HA_pirateBase", tier);
                    HAPirateBaseDestroyedFactor factor = new HAPirateBaseDestroyedFactor(points);
                    this.addFactor(factor);
                    return;
                }
                intel = LuddicPathBaseIntel.getIntelFor(system);
                if (intel == null || Misc.getStationFleet(((LuddicPathBaseIntel)intel).getMarket()) != otherFleet) continue;
                float totalInterest = 0.0f;
                float activeCells = 0.0f;
                for (StarSystemAPI curr : Misc.getPlayerSystems(false)) {
                    totalInterest += StandardLuddicPathActivityCause2.getPatherInterest(curr, 0.0f, 0.0f, 1.0f);
                    activeCells += StandardLuddicPathActivityCause2.getPatherInterest(curr, 0.0f, 0.0f, 1.0f, true);
                }
                if (totalInterest > 0.0f) {
                    int flat = Global.getSettings().getInt("HA_patherBaseFlat");
                    int perCell = Global.getSettings().getInt("HA_patherBasePerActiveCell");
                    int max = Global.getSettings().getInt("HA_patherBaseMax");
                    int points = -1 * Math.min(max, flat + perCell * Math.round(activeCells));
                    HAPatherBaseDestroyedFactor factor = new HAPatherBaseDestroyedFactor(points);
                    this.addFactor(factor);
                }
                return;
            }
        }
        boolean nearAny = false;
        for (StarSystemAPI system : Misc.getPlayerSystems(false)) {
            if (nearAny |= Misc.isNear(primaryWinner, system.getLocation())) break;
        }
        if (!nearAny) {
            return;
        }
        float fpDestroyed = 0.0f;
        CampaignFleetAPI first = null;
        for (CampaignFleetAPI otherFleet : battle.getNonPlayerSideSnapshot()) {
            for (FleetMemberAPI loss : Misc.getSnapshotMembersLost(otherFleet)) {
                fpDestroyed += (float)loss.getFleetPointCost();
                if (first != null) continue;
                first = otherFleet;
            }
        }
        int points = HostileActivityEventIntel.computerProgressPoints(fpDestroyed);
        if (points > 0) {
            HAShipsDestroyedFactor factor = new HAShipsDestroyedFactor(-1 * points);
            this.addFactor(factor);
        }
    }

    public static int computerProgressPoints(float fleetPointsDestroyed) {
        if (fleetPointsDestroyed <= 0.0f) {
            return 0;
        }
        int points = Math.round(fleetPointsDestroyed / FP_PER_POINT);
        if (points < 1) {
            points = 1;
        }
        return points;
    }

    @Override
    protected void notifyStageReached(BaseEventIntel.EventStageData stage) {
        if (stage.rollData instanceof HAERandomEventData) {
            HAERandomEventData data = (HAERandomEventData)stage.rollData;
            boolean fired = data.factor.fireEvent(this, stage);
            stage.rollData = null;
            if (stage.id == Stage.HA_EVENT) {
                int resetProgress = this.getDataFor((Object)((Object)Stage.INCREASED_DEFENSES)).progress + 1 + this.random.nextInt(5);
                if (!fired) {
                    resetProgress = this.getDataFor((Object)((Object)Stage.HA_EVENT)).progressToRollAt - this.random.nextInt(100);
                }
                this.setProgress(resetProgress);
            }
        } else if (stage.id == Stage.HA_EVENT && (stage.rollData == null || "random_event_none".equals(stage.rollData))) {
            stage.rollData = null;
            int resetProgress = this.getDataFor((Object)((Object)Stage.INCREASED_DEFENSES)).progress + 1 + this.random.nextInt(5);
            this.setProgress(resetProgress);
        }
    }

    public void resetHA_EVENT() {
        BaseEventIntel.EventStageData stage = this.getDataFor((Object)Stage.HA_EVENT);
        int resetProgress = stage.progressToRollAt - this.getRandom().nextInt(100);
        this.resetRandomizedStage(stage);
        this.setProgress(resetProgress);
    }

    @Override
    public void resetRandomizedStage(BaseEventIntel.EventStageData stage) {
        if (stage.rollData instanceof HAERandomEventData) {
            HAERandomEventData data = (HAERandomEventData)stage.rollData;
            data.isReset = true;
            data.factor.resetEvent(this, stage);
        }
        super.resetRandomizedStage(stage);
    }

    @Override
    public void rollRandomizedStage(BaseEventIntel.EventStageData stage) {
        if (stage.id == Stage.HA_EVENT || stage.id == Stage.MINOR_EVENT) {
            float total = 0.0f;
            for (EventFactor factor : this.factors) {
                if (!(factor instanceof BaseHostileActivityFactor)) continue;
                total += (float)factor.getProgress(this);
            }
            if (total < 1.0f) {
                total = 1.0f;
            }
            WeightedRandomPicker<BaseHostileActivityFactor> picker = new WeightedRandomPicker<BaseHostileActivityFactor>(this.random);
            for (EventFactor factor : this.factors) {
                if (!(factor instanceof BaseHostileActivityFactor)) continue;
                BaseHostileActivityFactor curr = (BaseHostileActivityFactor)factor;
                curr.setRandomizedStageSeed(this.random.nextLong());
                float f = curr.getEventFrequency(this, stage);
                float w = (float)factor.getProgress(this) / total;
                if (w > 0.0f) {
                    w = 0.5f + 0.5f * w;
                }
                picker.add(curr, f * w);
            }
            HostileActivityFactor pick = (HostileActivityFactor)picker.pick();
            if (pick == null) {
                return;
            }
            pick.rollEvent(this, stage);
        }
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Colony threats");
        return tags;
    }

    public static class HAEFactorDangerData {
        public HostileActivityFactor factor;
        public float mag;
    }

    public static class HAERandomEventData {
        public HostileActivityFactor factor;
        public BaseEventIntel.EventStageData stage;
        public boolean isReset = false;
        public Object custom;

        public HAERandomEventData(HostileActivityFactor factor, BaseEventIntel.EventStageData stage) {
            this.factor = factor;
            this.stage = stage;
        }
    }

    public static class HAEStarSystemDangerData {
        public StarSystemAPI system;
        public float maxMag;
        public float totalMag;
        public float sortMag;
        public List<HAEFactorDangerData> factorData = new ArrayList<HAEFactorDangerData>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        START,
        HA_1,
        MINOR_EVENT,
        HA_2,
        INCREASED_DEFENSES,
        HA_3,
        HA_4,
        HA_EVENT;

    }
}

