/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.raid.PirateRaidActionStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.PirateRaidAssembleStage2;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.impl.campaign.intel.raid.ReturnStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.TravelStage;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.rulecmd.KantaCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class PirateHostileActivityFactor
extends BaseHostileActivityFactor {
    public PirateHostileActivityFactor(HostileActivityEventIntel intel) {
        super(intel);
    }

    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    public String getDesc(BaseEventIntel intel) {
        return "Pirate activity";
    }

    public String getNameForThreatList(boolean first) {
        if (first) {
            return "Pirates";
        }
        return "Pirates";
    }

    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) <= 0) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("pirates").getBaseUIColor();
    }

    public TooltipMakerAPI.TooltipCreator getMainRowTooltip() {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("Piracy follows interstellar civilization almost without exception.", 0.0f);
                if (KantaCMD.playerHasProtection()) {
                    tooltip.addPara("However, you have %s, which is enough dissuade most pirates from attacking your interests.", opad, Misc.getPositiveHighlightColor(), "Kanta's protection");
                } else if (KantaCMD.playerEverHadProtection()) {
                    tooltip.addPara("You've %s, and it's not the sort of thing you can do over.", opad, Misc.getNegativeHighlightColor(), "lost Kanta's protection");
                } else {
                    tooltip.addPara("Having %s, however, should be enough dissuade most pirates from attacking your interests.", opad, Misc.getHighlightColor(), "Kanta's protection");
                }
            }
        };
    }

    public boolean shouldShow(BaseEventIntel intel) {
        return this.getProgress(intel) > 0 || KantaCMD.playerHasProtection();
    }

    public Color getNameColor(float mag) {
        if (mag <= 0.0f) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("pirates").getBaseUIColor();
    }

    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        int min;
        float f = 0.0f;
        if ((f += this.getEffectMagnitude(system)) > 1.0f) {
            f = 1.0f;
        }
        int difficulty = 0;
        if ((difficulty += Math.round(f * 7.0f)) < (min = Math.round(this.intel.getProgressFraction() * 6.0f))) {
            difficulty = min;
        }
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = system.getLocation();
        String factionId = "pirates";
        m.createStandardFleet(difficulty += random.nextInt(4), factionId, loc);
        m.triggerSetPirateFleet();
        m.triggerMakeLowRepImpact();
        CampaignFleetAPI fleet = m.createFleet();
        return fleet;
    }

    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("Rumors of pirate raid", tc, initPad);
    }

    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("Pirate raid averted", tc, initPad);
    }

    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
        float small = 0.0f;
        float opad = 10.0f;
        small = 5.0f;
        info.addPara("There are rumors that a pirate raid targeting your colonies may be organized at some point in the future.", small);
        stage.addResetReq(info, false, opad);
        this.addBorder(info, Global.getSector().getFaction("pirates").getBaseUIColor());
    }

    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return Global.getSector().getFaction("pirates").getCrest();
    }

    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, final BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT || stage.id == HostileActivityEventIntel.Stage.MINOR_EVENT) {
            return new BaseFactorTooltip(){

                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    float opad = 10.0f;
                    tooltip.addTitle("Pirate raid");
                    tooltip.addPara("A pirate raid will be launched against one of your star systems.", opad);
                    stage.addResetReq(tooltip, true, opad);
                }
            };
        }
        return null;
    }

    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (KantaCMD.playerHasProtection()) {
            return 0.0f;
        }
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT || stage.id == HostileActivityEventIntel.Stage.MINOR_EVENT) {
            StarSystemAPI target = this.findRaidTarget(intel, stage);
            MarketAPI source = this.findRaidSource(intel, stage, target);
            if (target != null && source != null) {
                return 10.0f;
            }
        }
        return 0.0f;
    }

    public void resetEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        super.resetEvent(intel, stage);
    }

    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        HostileActivityEventIntel.HAERandomEventData data = new HostileActivityEventIntel.HAERandomEventData(this, stage);
        stage.rollData = data;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
    }

    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        StarSystemAPI target = this.findRaidTarget(intel, stage);
        MarketAPI source = this.findRaidSource(intel, stage, target);
        if (source == null || target == null) {
            return false;
        }
        float mag = this.getEffectMagnitude(target);
        float raidFP = 1000.0f * (0.5f + Math.min(1.0f, mag) * 0.5f);
        raidFP *= 0.85f + 0.3f * intel.getRandom().nextFloat();
        if (stage.id == HostileActivityEventIntel.Stage.MINOR_EVENT) {
            raidFP = 120.0f + 30.0f * intel.getRandom().nextFloat();
        }
        stage.rollData = null;
        return this.startRaid(source, target, raidFP);
    }

    public void notifyRaidEnded(RaidIntel raid, RaidIntel.RaidStageStatus status) {
    }

    public StarSystemAPI findRaidTarget(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        WeightedRandomPicker<StarSystemAPI> picker = new WeightedRandomPicker<StarSystemAPI>(intel.getRandom());
        for (StarSystemAPI system : Misc.getPlayerSystems(false)) {
            float mag = this.getEffectMagnitude(system);
            if (mag < 0.2f && stage.id != HostileActivityEventIntel.Stage.MINOR_EVENT) continue;
            picker.add(system, mag * mag);
        }
        return (StarSystemAPI)picker.pick();
    }

    public MarketAPI findRaidSource(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, final StarSystemAPI target) {
        float dist;
        if (target == null) {
            return null;
        }
        ArrayList<MarketAPI> list = new ArrayList<MarketAPI>();
        float maxDist = Global.getSettings().getFloat("sectorWidth") * 0.5f;
        for (IntelInfoPlugin curr : Global.getSector().getIntelManager().getIntel(PirateBaseIntel.class)) {
            PirateBaseIntel base = (PirateBaseIntel)curr;
            if (base.playerHasDealWithBaseCommander() || (dist = Misc.getDistance(target.getLocation(), base.getMarket().getLocationInHyperspace())) > maxDist) continue;
            list.add(base.getMarket());
        }
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!"pirates".equals(market.getFaction().getId())) continue;
            for (MarketAPI other : Misc.getMarketsInLocation(market.getContainingLocation())) {
                float dist2;
                if (other == market || !other.getFaction().isHostileTo(market.getFaction()) || other.getSize() <= market.getSize() - 2 || (dist2 = Misc.getDistance(market.getPrimaryEntity().getLocation(), other.getPrimaryEntity().getLocation())) < 8000.0f) continue;
                list.add(market);
            }
        }
        Collections.sort(list, new Comparator<MarketAPI>(){

            @Override
            public int compare(MarketAPI m1, MarketAPI m2) {
                float d1 = Misc.getDistance(target.getLocation(), m1.getLocationInHyperspace());
                float d2 = Misc.getDistance(target.getLocation(), m2.getLocationInHyperspace());
                return (int)Math.signum(d1 - d2);
            }
        });
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(intel.getRandom());
        int i = 0;
        while (i < list.size() && i < 4) {
            MarketAPI market = (MarketAPI)list.get(i);
            dist = Misc.getDistance(target.getLocation(), market.getLocationInHyperspace());
            float w = 100000.0f / (dist * dist);
            picker.add(market, w);
            ++i;
        }
        return (MarketAPI)picker.pick();
    }

    public boolean startRaid(MarketAPI source, StarSystemAPI target, float raidFP) {
        boolean hasTargets = false;
        for (MarketAPI curr : Misc.getMarketsInLocation(target)) {
            if (!curr.getFaction().isHostileTo(source.getFaction())) continue;
            hasTargets = true;
            break;
        }
        if (!hasTargets) {
            return false;
        }
        FactionAPI faction = source.getFaction();
        RaidIntel raid = new RaidIntel(target, faction, this);
        float successMult = 0.5f;
        JumpPointAPI gather = null;
        List points = source.getContainingLocation().getEntities(JumpPointAPI.class);
        float min = Float.MAX_VALUE;
        for (JumpPointAPI curr : points) {
            float dist = Misc.getDistance(source.getPrimaryEntity().getLocation(), curr.getLocation());
            if (!(dist < min)) continue;
            min = dist;
            gather = curr;
        }
        JumpPointAPI raidJump = RouteLocationCalculator.findJumpPointToUse(faction, target.getCenter());
        if (gather == null || raidJump == null) {
            return false;
        }
        PirateRaidAssembleStage2 assemble = new PirateRaidAssembleStage2(raid, gather);
        assemble.addSource(source);
        assemble.setSpawnFP(raidFP);
        assemble.setAbortFP(raidFP * successMult);
        raid.addStage(assemble);
        TravelStage travel = new TravelStage(raid, gather, raidJump, false);
        travel.setAbortFP(raidFP * successMult);
        raid.addStage(travel);
        PirateRaidActionStage action = new PirateRaidActionStage(raid, target);
        action.setAbortFP(raidFP * successMult);
        raid.addStage(action);
        raid.addStage(new ReturnStage(raid));
        Global.getSector().getIntelManager().addIntel(raid);
        return true;
    }
}

