/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.inspection;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HegemonyInspectionIntel;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HegemonyInspectionManager;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HIOrdersInteractionDialogPluginImpl
implements InteractionDialogPlugin {
    public static int BRIBE_MULT = 10000;
    public static int BRIBE_MAX = 100000;
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;
    protected HegemonyInspectionIntel intel;
    protected IntelUIAPI ui;
    protected HegemonyInspectionIntel.AntiInspectionOrders beingConfirmed = null;

    public HIOrdersInteractionDialogPluginImpl(HegemonyInspectionIntel intel, IntelUIAPI ui) {
        this.intel = intel;
        this.ui = ui;
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.visual.setVisualFade(0.25f, 0.25f);
        this.visual.showPlanetInfo(this.intel.getTarget().getPrimaryEntity());
        dialog.setOptionOnEscape("Leave", (Object)OptionId.LEAVE);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    protected int computeBribeAmount() {
        int bribe = (int)(Math.pow(1.5, HegemonyInspectionManager.getInstance().getNumAttempts()) * (double)BRIBE_MULT);
        if (bribe > BRIBE_MAX) {
            bribe = BRIBE_MAX;
        }
        return bribe;
    }

    protected void printOptionDesc(HegemonyInspectionIntel.AntiInspectionOrders orders, boolean inConfirm) {
        switch (orders) {
            case BRIBE: {
                int bribe = this.computeBribeAmount();
                this.textPanel.addPara("Sufficient funding allocated to proper official and unofficial actors should ensure that the inspection reaches a satisfactory outcome.");
                if (inConfirm) {
                    this.textPanel.addPara("Once this order is given and the funds and agents dispatched, it can not be rescinded.");
                    int credits = (int)this.playerFleet.getCargo().getCredits().get();
                    Color costColor = Misc.getHighlightColor();
                    if (bribe > credits) {
                        costColor = Misc.getNegativeHighlightColor();
                    }
                    this.textPanel.addPara("A total of %s should be enough to get the job done. and guarantees that your standing with the Hegemony will not suffer.", costColor, Misc.getDGSCredits(bribe));
                    this.textPanel.addPara("You have %s available.", Misc.getHighlightColor(), Misc.getDGSCredits(credits));
                    break;
                }
                this.textPanel.addPara("You've allocated %s to the task and have otherwise committed to this course of action.", Misc.getHighlightColor(), Misc.getDGSCredits(bribe));
                break;
            }
            case COMPLY: {
                this.textPanel.addPara("The local authorities will comply with the inspection. This will result in all AI cores being found and confiscated, and will cause your standing with the Hegemony to fall based on the nuber of AI cores found.");
                this.textPanel.addPara("If AI cores currently in use are removed or moved off-planet, this activity will surely leave traces for inspectors to find, inspiring them to much greater zeal.");
                break;
            }
            case RESIST: {
                this.textPanel.addPara("All space and ground forces available will resist the inspection.");
                this.textPanel.addPara("If the inspection reaches the surface, the ground defense strength will determine whether they're able to confiscate any AI cores.");
                this.textPanel.addPara("The Hegemony will become aware of this - and hostile - when the inspection task force enters the star system.");
            }
        }
    }

    protected void addChoiceOptions() {
        this.options.clearOptions();
        HegemonyInspectionIntel.AntiInspectionOrders curr = this.intel.getOrders();
        if (curr != HegemonyInspectionIntel.AntiInspectionOrders.BRIBE) {
            this.options.addOption("Order the local authorities to comply with the inspection", (Object)OptionId.COMPLY, null);
            this.options.addOption("Allocate sufficient funds to bribe or otherwise handle the inspectors", (Object)OptionId.BRIBE, null);
            this.options.addOption("Order your local forces to resist the inspection", (Object)OptionId.RESIST, null);
            this.dialog.setOptionColor((Object)OptionId.BRIBE, Misc.getStoryOptionColor());
        }
        this.options.addOption("Dismiss", (Object)OptionId.LEAVE, null);
        this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
        if (curr == HegemonyInspectionIntel.AntiInspectionOrders.COMPLY) {
            this.options.setEnabled((Object)OptionId.COMPLY, false);
        }
        if (curr == HegemonyInspectionIntel.AntiInspectionOrders.BRIBE) {
            this.options.setEnabled((Object)OptionId.BRIBE, false);
        }
        if (curr == HegemonyInspectionIntel.AntiInspectionOrders.RESIST) {
            this.options.setEnabled((Object)OptionId.RESIST, false);
        }
    }

    protected void addConfirmOptions() {
        if (this.beingConfirmed == null) {
            return;
        }
        this.options.clearOptions();
        this.printOptionDesc(this.beingConfirmed, true);
        this.options.addOption("Confirm your orders", (Object)OptionId.CONFIRM, null);
        this.options.addOption("Never mind", (Object)OptionId.CANCEL, null);
        this.options.setShortcut((Object)OptionId.CANCEL, 1, false, false, false, true);
        if (this.beingConfirmed == HegemonyInspectionIntel.AntiInspectionOrders.BRIBE) {
            int bribe = this.computeBribeAmount();
            if ((float)bribe > this.playerFleet.getCargo().getCredits().get()) {
                this.options.setEnabled((Object)OptionId.CONFIRM, false);
                this.options.setTooltip((Object)OptionId.CONFIRM, "Not enough credits.");
            }
            SetStoryOption.set(this.dialog, 1, (Object)OptionId.CONFIRM, "bribeAICoreInspection", Sounds.STORY_POINT_SPEND_TECHNOLOGY, "Issued bribe to prevent " + this.intel.getFaction().getDisplayName() + " AI core inspection");
        }
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        switch (option) {
            case INIT: {
                this.printOptionDesc(this.intel.getOrders(), false);
                this.addChoiceOptions();
                break;
            }
            case COMPLY: {
                this.beingConfirmed = HegemonyInspectionIntel.AntiInspectionOrders.COMPLY;
                this.addConfirmOptions();
                break;
            }
            case BRIBE: {
                this.beingConfirmed = HegemonyInspectionIntel.AntiInspectionOrders.BRIBE;
                this.addConfirmOptions();
                break;
            }
            case RESIST: {
                this.beingConfirmed = HegemonyInspectionIntel.AntiInspectionOrders.RESIST;
                this.addConfirmOptions();
                break;
            }
            case CONFIRM: {
                int invested = this.intel.getInvestedCredits();
                if (invested > 0) {
                    AddRemoveCommodity.addCreditsGainText(invested, this.textPanel);
                    this.playerFleet.getCargo().getCredits().add(invested);
                    this.intel.setInvestedCredits(0);
                }
                this.intel.setOrders(this.beingConfirmed);
                if (this.beingConfirmed == HegemonyInspectionIntel.AntiInspectionOrders.BRIBE) {
                    int bribe = this.computeBribeAmount();
                    this.intel.setInvestedCredits(bribe);
                    AddRemoveCommodity.addCreditsLossText(bribe, this.textPanel);
                    this.playerFleet.getCargo().getCredits().subtract(bribe);
                }
                this.addChoiceOptions();
                break;
            }
            case CANCEL: {
                this.addChoiceOptions();
                break;
            }
            case LEAVE: {
                this.leave();
            }
        }
    }

    protected void leave() {
        this.dialog.dismiss();
        if (this.ui != null) {
            this.ui.updateUIForItem(this.intel);
        }
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OptionId {
        INIT,
        COMPLY,
        BRIBE,
        RESIST,
        LEAVE,
        CONFIRM,
        CANCEL,
        HIDE;

    }
}

