/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.inspection;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HegemonyInspectionIntel;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.Random;

public class HegemonyInspectionManager
implements EveryFrameScript {
    public static final String KEY = "$core_hegemonyInspectionManager";
    public static final float MAX_THRESHOLD = 1000.0f;
    public static final float FREQ_MULT = Global.getSettings().getFloat("aiInspectionFrequencyMult");
    protected IntervalUtil inspectionChecker = new IntervalUtil(20.0f, 40.0f);
    protected float suspicion = 0.0f;
    protected float threshold = 250.0f;
    protected float inspectionDelay = 0.0f;
    protected int numAttempts = 0;
    protected Random random = new Random();
    protected HegemonyInspectionIntel intel = null;

    public static HegemonyInspectionManager getInstance() {
        Object test = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        return (HegemonyInspectionManager)test;
    }

    public HegemonyInspectionManager() {
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
    }

    protected Object readResolve() {
        if (this.inspectionChecker == null) {
            this.inspectionChecker = new IntervalUtil(20.0f, 40.0f);
        }
        return this;
    }

    public void advance(float amount) {
        float days = Misc.getDays(amount);
        if (this.intel != null) {
            if (this.intel.isEnded()) {
                this.intel = null;
                this.inspectionDelay = 100.0f + 100.0f * this.random.nextFloat();
            }
        } else {
            this.inspectionDelay -= days;
            if (this.inspectionDelay <= 0.0f) {
                this.inspectionDelay = 0.0f;
            }
        }
        if (DebugFlags.HEGEMONY_INSPECTION_DEBUG) {
            days *= 1000.0f;
            this.inspectionDelay = 0.0f;
            this.suspicion = 1000.0f;
        }
        this.inspectionChecker.advance(days * FREQ_MULT);
        if (this.inspectionChecker.intervalElapsed() && this.intel == null && this.inspectionDelay <= 0.0f) {
            this.checkInspection();
        }
    }

    protected void checkInspection() {
        float total = 0.0f;
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!market.isPlayerOwned() || market.isInHyperspace()) continue;
            total += HegemonyInspectionManager.getAICoreUseValue(market);
        }
        this.suspicion += total * (0.25f + this.random.nextFloat() * 0.75f);
        if (this.suspicion >= this.threshold) {
            this.createInspection();
        }
    }

    public void createInspection() {
        this.createInspection(null);
    }

    public void createInspection(Integer fpOverride) {
        MarketAPI target = null;
        float max = 0.0f;
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            float curr;
            if (!market.isPlayerOwned() || market.isInHyperspace() || !((curr = HegemonyInspectionManager.getAICoreUseValue(market)) > max)) continue;
            target = market;
            max = curr;
        }
        if (target != null && max > 0.0f) {
            WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(this.random);
            for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
                if (!market.getFactionId().equals("hegemony") || !market.getMemoryWithoutUpdate().getBoolean("$military")) continue;
                picker.add(market, market.getSize());
            }
            MarketAPI from = (MarketAPI)picker.pick();
            if (from == null) {
                return;
            }
            float fp = 50.0f + this.threshold * 0.5f;
            if (fpOverride != null) {
                fp = fpOverride.intValue();
            }
            this.intel = new HegemonyInspectionIntel(from, target, fp);
            if (this.intel.isDone()) {
                this.intel = null;
                return;
            }
        } else {
            return;
        }
        ++this.numAttempts;
        this.suspicion = 0.0f;
        this.threshold *= 2.0f;
        if (this.threshold > 1000.0f) {
            this.threshold = 1000.0f;
        }
    }

    public int getNumAttempts() {
        return this.numAttempts;
    }

    public static float getAICoreUseValue(MarketAPI market) {
        float total = 0.0f;
        String aiCoreId = market.getAdmin().getAICoreId();
        if (aiCoreId != null) {
            total += 10.0f;
        }
        for (Industry ind : market.getIndustries()) {
            String id = ind.getAICoreId();
            float w = 0.0f;
            if ("alpha_core".equals(id)) {
                w = 4.0f;
            } else if ("beta_core".equals(id)) {
                w = 2.0f;
            } else if ("gamma_core".equals(id)) {
                w = 1.0f;
            }
            total += w;
        }
        return total;
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public float getThreshold() {
        return this.threshold;
    }
}

