/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.ui.IconRenderMode;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TradeFleetDepartureIntel
extends BaseIntelPlugin {
    protected RouteManager.RouteData route;
    protected transient List<EconomyFleetAssignmentAI.CargoQuantityData> deliverList;
    protected transient List<EconomyFleetAssignmentAI.CargoQuantityData> returnList;
    protected transient boolean goods;
    protected transient boolean materiel;
    protected transient boolean valuable;
    protected transient boolean large;
    protected transient FactionAPI faction;
    protected transient EconomyFleetAssignmentAI.EconomyRouteData data;
    protected Float sinceLaunched = null;

    public TradeFleetDepartureIntel(RouteManager.RouteData route) {
        float numAlready;
        float target;
        float probMult;
        boolean sameLoc;
        this.route = route;
        this.initTransientData();
        if (this.deliverList.isEmpty()) {
            return;
        }
        float prob = 0.1f;
        if (this.valuable) {
            prob += 0.1f;
        }
        if (this.large) {
            prob += 0.1f;
        }
        if (!this.deliverList.isEmpty() && !this.returnList.isEmpty()) {
            prob += 0.2f;
        }
        boolean bl = sameLoc = this.data.from.getPrimaryEntity().getContainingLocation() != null && this.data.from.getPrimaryEntity().getContainingLocation() == Global.getSector().getPlayerFleet().getContainingLocation() && !this.data.from.getPrimaryEntity().getContainingLocation().isHyperspace();
        if (sameLoc) {
            prob = 1.0f;
        }
        if ((probMult = Misc.getProbabilityMult(target = Global.getSettings().getFloat("targetNumTradeFleetNotifications"), numAlready = (float)Global.getSector().getIntelManager().getIntelCount(TradeFleetDepartureIntel.class, true), 0.5f)) > 1.0f) {
            probMult = 1.0f;
        }
        prob *= probMult;
        if (Math.random() > (double)prob) {
            return;
        }
        float postingRange = Math.max(0.0f, this.data.size - 6.0f);
        if (this.valuable) {
            postingRange = Math.max(3.0f, postingRange);
        }
        this.setPostingRangeLY(Float.valueOf(postingRange), true);
        this.setPostingLocation(this.data.from.getPrimaryEntity());
        Global.getSector().getIntelManager().queueIntel(this);
    }

    protected void initTransientData() {
        this.data = (EconomyFleetAssignmentAI.EconomyRouteData)this.route.getCustom();
        this.deliverList = new ArrayList<EconomyFleetAssignmentAI.CargoQuantityData>();
        this.returnList = new ArrayList<EconomyFleetAssignmentAI.CargoQuantityData>();
        this.goods = false;
        this.materiel = false;
        this.valuable = false;
        this.large = this.data.size >= 6.0f;
        for (EconomyFleetAssignmentAI.CargoQuantityData curr : this.data.cargoDeliver) {
            CommoditySpecAPI c = curr.getCommodity();
            if (c.getBasePrice() >= 100.0f && !c.isPersonnel()) {
                this.valuable = true;
            }
            if (c.isMeta()) {
                this.materiel = true;
            } else if (!c.isPersonnel()) {
                this.goods = true;
            }
            this.deliverList.add(curr);
        }
        for (EconomyFleetAssignmentAI.CargoQuantityData curr : this.data.cargoReturn) {
            this.returnList.add(curr);
        }
        this.faction = Global.getSector().getFaction(this.route.getFactionId());
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
            info.addPara("Faction: " + this.faction.getDisplayName(), initPad, tc, this.faction.getBaseUIColor(), this.faction.getDisplayName());
            initPad = 0.0f;
        }
        if (mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
            LabelAPI label = info.addPara("From " + this.data.from.getName() + " to " + this.data.to.getName(), tc, initPad);
            label.setHighlight(this.data.from.getName(), this.data.to.getName());
            label.setHighlightColors(this.data.from.getFaction().getBaseUIColor(), this.data.to.getFaction().getBaseUIColor());
            initPad = 0.0f;
        }
        if (isUpdate) {
            info.addPara("Fleet launched", tc, initPad);
        } else {
            float delay = this.route.getDelay();
            if (delay > 0.0f) {
                this.addDays(info, "until departure", delay, tc, initPad);
            } else {
                info.addPara("Recently launched", tc, initPad);
            }
        }
        this.unindent(info);
    }

    protected String getWhat() {
        String what = "goods and materiel";
        if (!this.materiel) {
            what = "goods";
        }
        if (!this.goods) {
            what = "materiel";
        }
        return what;
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color c = this.getTitleColor(mode);
        float pad = 3.0f;
        float opad = 10.0f;
        this.initTransientData();
        LabelAPI label = info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        CommodityOnMarketAPI com;
        this.initTransientData();
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.faction.getLogo(), width, 128.0f, opad);
        float tier = this.data.size;
        String fleetType = this.getFleetTypeName().toLowerCase();
        LabelAPI label = info.addPara("Your contacts " + this.data.from.getOnOrAt() + " " + this.data.from.getName() + " let you know that " + this.faction.getPersonNamePrefixAOrAn() + " " + this.faction.getPersonNamePrefix() + " " + fleetType + " is preparing for a voyage and will soon depart for " + this.data.to.getName() + ".", opad, tc, this.faction.getBaseUIColor(), this.faction.getPersonNamePrefix());
        label.setHighlight(this.data.from.getName(), this.faction.getPersonNamePrefix(), this.data.to.getName());
        label.setHighlightColors(this.data.from.getFaction().getBaseUIColor(), this.faction.getBaseUIColor(), this.data.to.getFaction().getBaseUIColor());
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        String what = this.getWhat();
        if (!this.deliverList.isEmpty()) {
            info.addPara("On the outward trip to " + this.data.to.getName() + " the fleet will carry " + EconomyFleetAssignmentAI.EconomyRouteData.getCargoList(this.deliverList) + ".", opad);
            info.beginIconGroup();
            info.setIconSpacingMedium();
            for (EconomyFleetAssignmentAI.CargoQuantityData curr : this.deliverList) {
                com = this.data.from.getCommodityData(curr.cargo);
                info.addIcons(com, curr.units, IconRenderMode.NORMAL);
            }
            info.addIconGroup(32.0f, 1, opad);
        } else {
            info.addPara("The fleet will carry nothing of note on the trip to " + this.data.to.getName() + ".", opad);
        }
        if (!this.returnList.isEmpty()) {
            info.addPara("On the trip back to " + this.data.from.getName() + " the fleet will carry " + EconomyFleetAssignmentAI.EconomyRouteData.getCargoList(this.returnList) + ".", opad);
            info.beginIconGroup();
            info.setIconSpacingMedium();
            for (EconomyFleetAssignmentAI.CargoQuantityData curr : this.returnList) {
                com = this.data.to.getCommodityData(curr.cargo);
                info.addIcons(com, curr.units, IconRenderMode.NORMAL);
            }
            info.addIconGroup(32.0f, 1, opad);
        } else {
            info.addPara("The fleet will carry nothing of note on the trip back to " + this.data.from.getName() + ".", opad);
        }
        if (this.valuable && this.large) {
            info.addPara("It's noteworthy because it's carrying a large quantity of valuable " + what + ".", opad);
        } else if (this.valuable) {
            info.addPara("It's noteworthy because it's carrying valuable " + what + ".", opad);
        } else if (this.large) {
            info.addPara("It's noteworthy because it's carrying a large quantity of " + what + ".", opad);
        }
        if (this.data.smuggling) {
            info.addPara("Smugglers often operate in a gray legal and moral area. Thus, if one comes to an unfortunate end - as so often happens in their line of work - it's unlikely to cause a unified response from whatever faction or organization they're nominally affiliated with.", g, opad);
        }
    }

    @Override
    public String getIcon() {
        this.initTransientData();
        if (this.data.smuggling) {
            return Global.getSettings().getSpriteName("intel", "tradeFleet_smuggling");
        }
        if (this.valuable) {
            return Global.getSettings().getSpriteName("intel", "tradeFleet_valuable");
        }
        if (this.large) {
            return Global.getSettings().getSpriteName("intel", "tradeFleet_large");
        }
        return Global.getSettings().getSpriteName("intel", "tradeFleet_other");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Fleet departures");
        this.faction = Global.getSector().getFaction(this.route.getFactionId());
        tags.add(this.faction.getId());
        this.data = (EconomyFleetAssignmentAI.EconomyRouteData)this.route.getCustom();
        if (this.data.smuggling) {
            tags.add("Smuggling");
        }
        return tags;
    }

    @Override
    public String getSortString() {
        return "Trade Fleet Departure";
    }

    public String getFleetTypeName() {
        float tier = this.data.size;
        String typeId = EconomyFleetRouteManager.getFleetTypeIdForTier(tier, this.data.smuggling);
        String fleetType = this.faction.getFleetTypeName(typeId);
        if (fleetType == null) {
            fleetType = "Trade Fleet";
        }
        return fleetType;
    }

    @Override
    public String getName() {
        return this.getFleetTypeName();
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        this.faction = Global.getSector().getFaction(this.route.getFactionId());
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.route.getMarket().getPrimaryEntity();
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        if (this.route.getDelay() > 0.0f) {
            return;
        }
        if (this.sinceLaunched == null) {
            this.sinceLaunched = Float.valueOf(0.0f);
        }
        if (this.sinceLaunched.floatValue() <= 0.0f && amount > 0.0f) {
            this.sendUpdateIfPlayerHasIntel(new Object(), true);
        }
        float days = Misc.getDays(amount);
        this.sinceLaunched = Float.valueOf(this.sinceLaunched.floatValue() + days);
    }

    @Override
    public float getTimeRemainingFraction() {
        float f = this.route.getDelay() / 30.0f;
        return f;
    }

    @Override
    public boolean shouldRemoveIntel() {
        if (this.route.getDelay() > 0.0f) {
            return false;
        }
        if (this.isImportant()) {
            return false;
        }
        return this.sinceLaunched == null || !(this.sinceLaunched.floatValue() < this.getBaseDaysAfterEnd());
    }

    @Override
    public void setImportant(Boolean important) {
        super.setImportant(important);
        if (this.isImportant()) {
            if (!Global.getSector().getScripts().contains(this)) {
                Global.getSector().addScript(this);
            }
        } else {
            Global.getSector().removeScript(this);
        }
    }

    @Override
    public void reportRemovedIntel() {
        super.reportRemovedIntel();
        Global.getSector().removeScript(this);
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        SectorEntityToken iconEntity;
        ArrayList<IntelInfoPlugin.ArrowData> result = new ArrayList<IntelInfoPlugin.ArrowData>();
        if (this.data.from.getContainingLocation() == this.data.to.getContainingLocation() && this.data.from.getContainingLocation() != null && !this.data.from.getContainingLocation().isHyperspace()) {
            return null;
        }
        SectorEntityToken entityFrom = this.data.from.getPrimaryEntity();
        if (map != null && (iconEntity = map.getIntelIconEntity(this)) != null) {
            entityFrom = iconEntity;
        }
        this.data = (EconomyFleetAssignmentAI.EconomyRouteData)this.route.getCustom();
        IntelInfoPlugin.ArrowData arrow = new IntelInfoPlugin.ArrowData(entityFrom, this.data.to.getPrimaryEntity());
        arrow.color = this.getFactionForUIColors().getBaseUIColor();
        result.add(arrow);
        return result;
    }

    public RouteManager.RouteData getRoute() {
        return this.route;
    }
}

