/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.raid;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.MilitaryResponseScript;
import com.fs.starfarer.api.impl.campaign.command.WarSimScript;
import com.fs.starfarer.api.impl.campaign.econ.impl.OrbitalStation;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.raid.ActionStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PirateRaidActionStage
extends ActionStage
implements BaseAssignmentAI.FleetActionDelegate {
    protected StarSystemAPI system;
    protected float untilNextStage = 0.0f;
    protected List<MilitaryResponseScript> scripts = new ArrayList<MilitaryResponseScript>();
    protected List<RaidActionSubStage> steps = new ArrayList<RaidActionSubStage>();
    protected List<MarketAPI> targets = new ArrayList<MarketAPI>();
    protected boolean playerTargeted = false;

    public PirateRaidActionStage(RaidIntel raid, StarSystemAPI system) {
        super(raid);
        this.system = system;
        for (MarketAPI target : this.getTargets()) {
            if (!target.isPlayerOwned()) continue;
            this.playerTargeted = true;
        }
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        float days = Misc.getDays(amount);
        this.untilNextStage -= days;
        if (!this.steps.isEmpty() && this.untilNextStage <= 0.0f) {
            this.removeMilScripts();
            RaidActionSubStage step = this.steps.remove(0);
            this.untilNextStage = step.duration;
            float duration = 100.0f;
            for (Pair<SectorEntityToken, Float> curr : step.targets) {
                MilitaryResponseScript.MilitaryResponseParams params = new MilitaryResponseScript.MilitaryResponseParams(CampaignFleetAIAPI.ActionType.HOSTILE, "raid_" + ((SectorEntityToken)curr.one).getId(), this.intel.getFaction(), (SectorEntityToken)curr.one, ((Float)curr.two).floatValue(), duration);
                MilitaryResponseScript script = new MilitaryResponseScript(params);
                ((SectorEntityToken)curr.one).getContainingLocation().addScript(script);
                this.scripts.add(script);
                MilitaryResponseScript.MilitaryResponseParams defParams = new MilitaryResponseScript.MilitaryResponseParams(CampaignFleetAIAPI.ActionType.HOSTILE, "defRaid_" + ((SectorEntityToken)curr.one).getId(), ((SectorEntityToken)curr.one).getFaction(), (SectorEntityToken)curr.one, ((Float)curr.two).floatValue(), duration);
                MilitaryResponseScript defScript = new MilitaryResponseScript(defParams);
                ((SectorEntityToken)curr.one).getContainingLocation().addScript(defScript);
                this.scripts.add(defScript);
            }
        }
    }

    protected void removeMilScripts() {
        if (this.scripts != null) {
            for (MilitaryResponseScript s : this.scripts) {
                s.forceDone();
            }
        }
    }

    @Override
    protected void updateStatus() {
        this.abortIfNeededBasedOnFP(true);
        if (this.status != RaidIntel.RaidStageStatus.ONGOING) {
            return;
        }
        if (this.getTargets().isEmpty()) {
            this.status = RaidIntel.RaidStageStatus.FAILURE;
            this.removeMilScripts();
            this.giveReturnOrdersToStragglers(this.getRoutes());
            return;
        }
        if (this.steps.isEmpty()) {
            boolean inSpawnRange = RouteManager.isPlayerInSpawnRange(this.system.getCenter());
            if (!inSpawnRange && this.elapsed > this.maxDays) {
                this.autoresolve();
                return;
            }
            boolean someUnraided = false;
            boolean someRaided = false;
            for (MarketAPI market : this.targets) {
                if (!market.getFaction().isHostileTo(this.intel.getFaction())) {
                    someUnraided = true;
                    continue;
                }
                if (Misc.flagHasReason(market.getMemoryWithoutUpdate(), "$recentlyRaided", this.intel.getFaction().getId())) {
                    someRaided = true;
                    continue;
                }
                someUnraided = true;
            }
            if (this.targets.isEmpty()) {
                someUnraided = true;
            }
            if (!someUnraided || this.elapsed > this.maxDays && someRaided) {
                this.status = RaidIntel.RaidStageStatus.SUCCESS;
                this.removeMilScripts();
                return;
            }
            if (this.elapsed > this.maxDays && !someRaided) {
                this.status = RaidIntel.RaidStageStatus.FAILURE;
                this.giveReturnOrdersToStragglers(this.getRoutes());
                this.removeMilScripts();
                return;
            }
        }
    }

    protected List<MarketAPI> getTargets() {
        ArrayList<MarketAPI> targets = new ArrayList<MarketAPI>();
        for (MarketAPI market : Misc.getMarketsInLocation(this.system)) {
            if (!market.getFaction().isHostileTo(this.intel.getFaction())) continue;
            targets.add(market);
        }
        return targets;
    }

    @Override
    protected void updateRoutes() {
        this.resetRoutes();
        if (this.playerTargeted) {
            this.intel.sendEnteredSystemUpdate();
        }
        FactionAPI faction = this.intel.getFaction();
        List<RouteManager.RouteData> routes = RouteManager.getInstance().getRoutesForSource(this.intel.getRouteSourceId());
        for (RouteManager.RouteData route : routes) {
            route.addSegment(new RouteManager.RouteSegment(1000.0f, this.system.getCenter()));
        }
        List<MarketAPI> targets = this.getTargets();
        if (targets.isEmpty()) {
            return;
        }
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>();
        for (MarketAPI target : targets) {
            picker.add(target, target.getSize() * target.getSize());
        }
        float str = WarSimScript.getFactionStrength(faction, this.system);
        float enemyStr = 0.0f;
        HashSet<String> seen = new HashSet<String>();
        for (MarketAPI market : targets) {
            if (seen.contains(market.getFactionId())) continue;
            seen.add(market.getFactionId());
            enemyStr += WarSimScript.getFactionStrength(market.getFaction(), this.system);
        }
        if (str < 1.0f) {
            str = 1.0f;
        }
        if (enemyStr < 1.0f) {
            enemyStr = 1.0f;
        }
        boolean concurrent = false;
        int numRaids = 1;
        if (str > enemyStr * 2.0f && (float)Math.random() > 0.5f) {
            numRaids = 2;
        }
        if (str > enemyStr * 4.0f) {
            concurrent = true;
            ++numRaids;
        }
        if (!concurrent) {
            int i = 0;
            while (i < numRaids && !picker.isEmpty()) {
                MarketAPI target = (MarketAPI)picker.pickAndRemove();
                float defensiveStr = enemyStr + WarSimScript.getStationStrength(target.getFaction(), this.system, target.getPrimaryEntity());
                if (!(defensiveStr > str)) {
                    RaidActionSubStage step = new RaidActionSubStage();
                    step.duration = 20.0f + 10.0f * (float)Math.random();
                    float weight = 1.0f;
                    Industry station = Misc.getStationIndustry(target);
                    if (station != null && station.getDisruptedDays() < step.duration) {
                        step.duration += 10.0f + (float)Math.random() * 5.0f;
                        weight += 1.0f;
                    }
                    step.targets.add(new Pair<SectorEntityToken, Float>(target.getPrimaryEntity(), Float.valueOf(weight)));
                    this.steps.add(step);
                    this.targets.add(target);
                }
                ++numRaids;
            }
            this.maxDays = 0.0f;
            for (RaidActionSubStage step : this.steps) {
                this.maxDays += step.duration;
            }
        } else {
            RaidActionSubStage step = new RaidActionSubStage();
            boolean stationPresent = false;
            int i = 0;
            while (i < numRaids && !picker.isEmpty()) {
                MarketAPI target = (MarketAPI)picker.pickAndRemove();
                float defensiveStr = enemyStr + WarSimScript.getStationStrength(target.getFaction(), this.system, target.getPrimaryEntity());
                if (!(defensiveStr > str)) {
                    float weight = 1.0f;
                    Industry station = Misc.getStationIndustry(target);
                    if (station != null && station.getDisruptedDays() < 20.0f) {
                        stationPresent = true;
                        weight += 1.0f;
                    }
                    step.targets.add(new Pair<SectorEntityToken, Float>(target.getPrimaryEntity(), Float.valueOf(weight)));
                    this.targets.add(target);
                }
                ++numRaids;
            }
            this.steps.add(step);
            step.duration = 20.0f + 10.0f * (float)Math.random();
            if (stationPresent) {
                step.duration += 10.0f + (float)Math.random() * 5.0f;
            }
            this.maxDays = step.duration;
        }
        if (this.targets.isEmpty()) {
            this.steps.clear();
            this.maxDays = 0.0f;
            return;
        }
    }

    @Override
    public void showStageInfo(TooltipMakerAPI info) {
        int curr = this.intel.getCurrentStage();
        int index = this.intel.getStageIndex(this);
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        if (this.status == RaidIntel.RaidStageStatus.FAILURE) {
            info.addPara("The raiding forces have been defeated by the defenders of the " + this.intel.getSystem().getNameWithLowercaseType() + ". The raid is now over.", opad);
        } else if (this.status == RaidIntel.RaidStageStatus.SUCCESS) {
            ArrayList<MarketAPI> raided = new ArrayList<MarketAPI>();
            for (MarketAPI market : this.targets) {
                if (!market.getFaction().isHostileTo(this.intel.getFaction()) || !Misc.flagHasReason(market.getMemoryWithoutUpdate(), "$recentlyRaided", this.intel.getFaction().getId())) continue;
                raided.add(market);
            }
            if (!raided.isEmpty()) {
                info.addPara("The raiding forces have been successful in raiding the following colonies:", opad);
                float initPad = opad;
                for (MarketAPI market : raided) {
                    BaseIntelPlugin.addMarketToList(info, market, initPad, tc);
                    initPad = 0.0f;
                }
            }
        } else if (curr == index) {
            info.addPara("The raiding forces are currently operating in the " + this.intel.getSystem().getNameWithLowercaseType() + ".", opad);
        }
    }

    @Override
    public boolean isPlayerTargeted() {
        return this.playerTargeted;
    }

    protected void autoresolve() {
        float str = WarSimScript.getFactionStrength(this.intel.getFaction(), this.system);
        float enemyStr = WarSimScript.getEnemyStrength(this.intel.getFaction(), this.system);
        this.status = RaidIntel.RaidStageStatus.FAILURE;
        for (MarketAPI target : this.targets) {
            float defensiveStr;
            if (!target.getFaction().isHostileTo(this.intel.getFaction()) || (defensiveStr = enemyStr + WarSimScript.getStationStrength(target.getFaction(), this.system, target.getPrimaryEntity())) >= str) continue;
            Industry station = Misc.getStationIndustry(target);
            if (station != null) {
                OrbitalStation.disrupt(station);
            }
            this.performRaid(null, target);
            str -= defensiveStr * 0.5f;
            this.status = RaidIntel.RaidStageStatus.SUCCESS;
        }
        this.removeMilScripts();
    }

    @Override
    public String getRaidActionText(CampaignFleetAPI fleet, MarketAPI market) {
        return "raiding " + market.getName();
    }

    @Override
    public String getRaidApproachText(CampaignFleetAPI fleet, MarketAPI market) {
        return "moving in to raid " + market.getName();
    }

    @Override
    public void performRaid(CampaignFleetAPI fleet, MarketAPI market) {
        float raidStr = this.intel.getRaidFPAdjusted() / this.intel.getNumFleets() * Misc.FP_TO_GROUND_RAID_STR_APPROX_MULT;
        if (fleet != null) {
            raidStr = MarketCMD.getRaidStr(fleet);
        }
        float maxPenalty = 3.0f;
        new MarketCMD(market.getPrimaryEntity()).doGenericRaid(this.intel.getFaction(), raidStr, maxPenalty);
    }

    @Override
    public boolean canRaid(CampaignFleetAPI fleet, MarketAPI market) {
        if (Misc.flagHasReason(market.getMemoryWithoutUpdate(), "$recentlyRaided", this.intel.getFaction().getId())) {
            return false;
        }
        return market.getFaction().isHostileTo(fleet.getFaction());
    }

    @Override
    public String getRaidPrepText(CampaignFleetAPI fleet, SectorEntityToken from) {
        return "preparing for raid";
    }

    @Override
    public String getRaidInSystemText(CampaignFleetAPI fleet) {
        return "raiding";
    }

    @Override
    public String getRaidDefaultText(CampaignFleetAPI fleet) {
        return "raiding";
    }

    public static class RaidActionSubStage {
        public List<Pair<SectorEntityToken, Float>> targets = new ArrayList<Pair<SectorEntityToken, Float>>();
        public float duration = 30.0f;
    }
}

