/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.raid;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.command.WarSimScript;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.raid.ActionStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.AssembleStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.OrganizeStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidAssignmentAI;
import com.fs.starfarer.api.impl.campaign.intel.raid.TravelStage;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RouteFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RaidIntel
extends BaseIntelPlugin
implements RouteManager.RouteFleetSpawner {
    public static Object UPDATE_FAILED = new Object();
    public static Object UPDATE_RETURNING = new Object();
    public static Object ENTERED_SYSTEM_UPDATE = new Object();
    protected int currentStage = 0;
    protected int failStage = -1;
    protected List<RaidStage> stages = new ArrayList<RaidStage>();
    protected String id = Misc.genUID();
    protected String sid = "raid_" + this.id;
    protected float extraDays = 60.0f;
    protected StarSystemAPI system;
    protected FactionAPI faction;
    protected float defenderStr = 0.0f;
    protected RaidDelegate delegate;

    public RaidIntel(StarSystemAPI system, FactionAPI faction, RaidDelegate delegate) {
        this.system = system;
        this.faction = faction;
        this.delegate = delegate;
        Global.getSector().addScript(this);
        this.defenderStr = WarSimScript.getEnemyStrength(this.getFaction(), system);
    }

    public void sendEnteredSystemUpdate() {
    }

    public StarSystemAPI getSystem() {
        return this.system;
    }

    public int getCurrentStage() {
        return this.currentStage;
    }

    public int getStageIndex(RaidStage stage) {
        return this.stages.indexOf(stage);
    }

    public int getFailStage() {
        return this.failStage;
    }

    public OrganizeStage getOrganizeStage() {
        for (RaidStage stage : this.stages) {
            if (!(stage instanceof OrganizeStage)) continue;
            return (OrganizeStage)stage;
        }
        return null;
    }

    public AssembleStage getAssembleStage() {
        for (RaidStage stage : this.stages) {
            if (!(stage instanceof AssembleStage)) continue;
            return (AssembleStage)stage;
        }
        return null;
    }

    public ActionStage getActionStage() {
        for (RaidStage stage : this.stages) {
            if (!(stage instanceof ActionStage)) continue;
            return (ActionStage)stage;
        }
        return null;
    }

    public void addStage(RaidStage stage) {
        this.stages.add(stage);
    }

    public String getRouteSourceId() {
        return this.sid;
    }

    public float getExtraDays() {
        return this.extraDays;
    }

    public void setExtraDays(float extraDays) {
        this.extraDays = extraDays;
    }

    @Override
    public boolean canMakeVisibleToPlayer(boolean playerInRelayRange) {
        return super.canMakeVisibleToPlayer(playerInRelayRange);
    }

    public boolean shouldSendUpdate() {
        if (DebugFlags.SEND_UPDATES_WHEN_NO_COMM || Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay()) {
            return true;
        }
        if (this.system != null && this.system == Global.getSector().getCurrentLocation()) {
            return true;
        }
        return this.isPlayerTargeted();
    }

    public boolean isPlayerTargeted() {
        ActionStage action = this.getActionStage();
        return action != null && action.isPlayerTargeted();
    }

    @Override
    public String getCommMessageSound() {
        if (this.isPlayerTargeted() && !this.isSendingUpdate()) {
            return RaidIntel.getSoundColonyThreat();
        }
        if (this.isSendingUpdate()) {
            return RaidIntel.getSoundStandardUpdate();
        }
        return RaidIntel.getSoundMajorPosting();
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        if (this.currentStage >= this.stages.size()) {
            this.endAfterDelay();
            if (this.shouldSendUpdate()) {
                this.sendUpdateIfPlayerHasIntel(UPDATE_RETURNING, false);
            }
            return;
        }
        RaidStage stage = this.stages.get(this.currentStage);
        stage.advance(amount);
        RaidStageStatus status = stage.getStatus();
        if (status == RaidStageStatus.SUCCESS) {
            ++this.currentStage;
            this.setExtraDays(Math.max(0.0f, this.getExtraDays() - stage.getExtraDaysUsed()));
            if (this.currentStage < this.stages.size()) {
                this.stages.get(this.currentStage).notifyStarted();
            }
            return;
        }
        if (status == RaidStageStatus.FAILURE) {
            this.failedAtStage(stage);
            this.failStage = this.currentStage;
            this.endAfterDelay();
            if (this.shouldSendUpdate()) {
                this.sendUpdateIfPlayerHasIntel(UPDATE_FAILED, false);
            }
        }
    }

    public void forceFail(boolean withUpdate) {
        int index = this.currentStage;
        if (index >= this.stages.size()) {
            index = this.stages.size() - 1;
        }
        this.failedAtStage(this.stages.get(index));
        this.failStage = this.currentStage;
        this.endAfterDelay();
        if (withUpdate && this.shouldSendUpdate()) {
            this.sendUpdateIfPlayerHasIntel(UPDATE_FAILED, false);
        }
    }

    protected void failedAtStage(RaidStage stage) {
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript(this);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        if (this.delegate != null) {
            RaidStageStatus status = RaidStageStatus.SUCCESS;
            if (this.failStage >= 0) {
                status = RaidStageStatus.FAILURE;
            }
            this.delegate.notifyRaidEnded(this, status);
        }
    }

    public float getETA() {
        int curr = this.getCurrentStage();
        float eta = 0.0f;
        for (RaidStage stage : this.stages) {
            if (stage instanceof ActionStage) break;
            int index = this.getStageIndex(stage);
            if (index < curr) continue;
            if (stage instanceof OrganizeStage) {
                eta += Math.max(0.0f, stage.getMaxDays() - stage.getElapsed());
                continue;
            }
            if (stage instanceof AssembleStage) {
                eta += Math.max(0.0f, 20.0f - stage.getElapsed());
                continue;
            }
            if (!(stage instanceof TravelStage)) continue;
            float travelDays = RouteLocationCalculator.getTravelDays(this.getAssembleStage().gatheringPoint, this.system.getHyperspaceAnchor());
            eta += Math.max(0.0f, travelDays - stage.getElapsed());
        }
        return eta;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        float eta = this.getETA();
        info.addPara("Faction: " + this.faction.getDisplayName(), initPad, tc, this.faction.getBaseUIColor(), this.faction.getDisplayName());
        initPad = 0.0f;
        int max = 0;
        MarketAPI target = null;
        for (MarketAPI marketAPI : Misc.getMarketsInLocation(this.system)) {
            int size;
            if (!marketAPI.getFaction().isHostileTo(this.faction) || (size = marketAPI.getSize()) <= max && (size != max || !marketAPI.getFaction().isPlayerFaction())) continue;
            max = size;
            target = marketAPI;
        }
        if (target != null) {
            FactionAPI factionAPI = target.getFaction();
            info.addPara("Target: " + factionAPI.getDisplayName(), initPad, tc, factionAPI.getBaseUIColor(), factionAPI.getDisplayName());
        }
        if (isUpdate) {
            if (this.getListInfoParam() == ENTERED_SYSTEM_UPDATE) {
                info.addPara("Arrived in-system", tc, initPad);
            } else if (this.failStage < 0) {
                info.addPara("Colonies in the " + this.system.getNameWithLowercaseType() + " have been raided", tc, initPad);
            } else {
                info.addPara("The raid on the " + this.system.getNameWithLowercaseType() + " has failed", tc, initPad);
            }
        } else {
            info.addPara(this.system.getNameWithLowercaseType(), tc, initPad);
        }
        initPad = 0.0f;
        if (eta > 1.0f && this.failStage < 0 && this.getListInfoParam() != ENTERED_SYSTEM_UPDATE) {
            String string = RaidIntel.getDaysString(eta);
            info.addPara("Estimated %s " + string + " until arrival", initPad, tc, h, "" + Math.round(eta));
            initPad = 0.0f;
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        this.isPlayerTargeted();
        info.setParaFontDefault();
        info.addPara(this.getName(), c, 0.0f);
        info.setParaFontDefault();
        this.addBulletPoints(info, mode);
    }

    protected MarketAPI getFirstSource() {
        AssembleStage as = this.getAssembleStage();
        if (as == null) {
            return null;
        }
        if (as.getSources() == null || as.getSources().isEmpty()) {
            return null;
        }
        return as.getSources().get(0);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.getFactionForUIColors().getLogo(), width, 128.0f, opad);
        FactionAPI faction = this.getFaction();
        String has = faction.getDisplayNameHasOrHave();
        String is = faction.getDisplayNameIsOrAre();
        AssembleStage as = this.getAssembleStage();
        MarketAPI source = this.getFirstSource();
        float raidStr = as.getOrigSpawnFP();
        raidStr = Misc.getAdjustedStrength(raidStr, source);
        String strDesc = this.getRaidStrDesc();
        int numFleets = (int)this.getOrigNumFleets();
        String fleets = "fleets";
        if (numFleets == 1) {
            fleets = " large fleet, or several smaller ones";
        }
        LabelAPI label = info.addPara(String.valueOf(Misc.ucFirst(faction.getDisplayNameWithArticle())) + " " + is + " conducting a raid of the " + this.system.getName() + ". The raiding forces are " + "projected to be " + strDesc + " and likely comprised of " + numFleets + " " + fleets + ".", opad, faction.getBaseUIColor(), faction.getDisplayNameWithArticleWithoutArticle());
        label.setHighlight(faction.getDisplayNameWithArticleWithoutArticle(), strDesc, "" + numFleets);
        label.setHighlightColors(faction.getBaseUIColor(), h, h);
        ArrayList<MarketAPI> targets = new ArrayList<MarketAPI>();
        for (MarketAPI market : Misc.getMarketsInLocation(this.system)) {
            if (!market.getFaction().isHostileTo(faction)) continue;
            targets.add(market);
        }
        this.defenderStr = WarSimScript.getEnemyStrength(this.getFaction(), this.system);
        ArrayList<MarketAPI> safe = new ArrayList<MarketAPI>();
        ArrayList<MarketAPI> unsafe = new ArrayList<MarketAPI>();
        for (MarketAPI market : targets) {
            float defensiveStr = this.defenderStr + WarSimScript.getStationStrength(market.getFaction(), this.system, market.getPrimaryEntity());
            if (defensiveStr > raidStr * 1.25f) {
                safe.add(market);
                continue;
            }
            unsafe.add(market);
        }
        if (!this.isEnding()) {
            if (targets.isEmpty()) {
                info.addPara("There are no colonies for the raid to target in the system.", opad);
            } else {
                boolean showSafe = false;
                if (raidStr < this.defenderStr * 0.75f) {
                    info.addPara("The raiding forces should be outmatched by fleets defending the system. In the absence of other factors, the raid is unlikely to find success.", opad);
                } else if (raidStr < this.defenderStr * 1.25f) {
                    info.addPara("The raiding forces are evenly matched with fleets defending the system.", opad);
                    showSafe = true;
                } else {
                    info.addPara("The raiding forces are superior to the fleets defending the system.", opad);
                    showSafe = true;
                }
                if (showSafe) {
                    if (safe.size() == targets.size()) {
                        info.addPara("However, all colonies should be safe from the raid, owing to their orbital defenses.", opad);
                    } else {
                        info.addPara("Considering orbital defenses (if any), the following colonies are at risk from the raid:", opad);
                        float initPad = opad;
                        for (MarketAPI market : unsafe) {
                            RaidIntel.addMarketToList(info, market, initPad, tc);
                            initPad = 0.0f;
                        }
                    }
                }
            }
        }
        info.addSectionHeading("Status", faction.getBaseUIColor(), faction.getDarkUIColor(), Alignment.MID, opad);
        for (RaidStage stage : this.stages) {
            stage.showStageInfo(info);
            if (this.getStageIndex(stage) == this.failStage) break;
        }
    }

    @Override
    public String getIcon() {
        return this.faction.getCrest();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Military");
        if (!Misc.getMarketsInLocation(this.system, "player").isEmpty()) {
            tags.add("Colony threats");
        }
        tags.add(this.getFaction().getId());
        return tags;
    }

    @Override
    public String getSortString() {
        return "Raid";
    }

    @Override
    public String getName() {
        String base = String.valueOf(Misc.ucFirst(this.getFaction().getPersonNamePrefix())) + " Raid";
        if (this.isEnding()) {
            if (this.isSendingUpdate() && this.failStage >= 0) {
                return String.valueOf(base) + " - Failed";
            }
            for (RaidStage stage : this.stages) {
                if (!(stage instanceof ActionStage) || stage.getStatus() != RaidStageStatus.SUCCESS) continue;
                return String.valueOf(base) + " - Successful";
            }
            return String.valueOf(base) + " - Over";
        }
        return base;
    }

    public boolean isFailed() {
        return this.failStage >= 0;
    }

    public boolean isSucceeded() {
        for (RaidStage stage : this.stages) {
            if (!(stage instanceof ActionStage) || stage.getStatus() != RaidStageStatus.SUCCESS) continue;
            return true;
        }
        return false;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.getFaction();
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.system.getHyperspaceAnchor();
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        SectorEntityToken iconEntity;
        AssembleStage as = this.getAssembleStage();
        if (as == null || !as.isSourceKnown()) {
            return null;
        }
        SectorEntityToken from = as.gatheringPoint;
        if (this.system == null || this.system == from.getContainingLocation()) {
            return null;
        }
        ArrayList<IntelInfoPlugin.ArrowData> result = new ArrayList<IntelInfoPlugin.ArrowData>();
        SectorEntityToken entityFrom = from;
        if (map != null && this.delegate instanceof IntelInfoPlugin && this.delegate != this && (iconEntity = map.getIntelIconEntity((IntelInfoPlugin)((Object)this.delegate))) != null) {
            entityFrom = iconEntity;
        }
        IntelInfoPlugin.ArrowData arrow = new IntelInfoPlugin.ArrowData(entityFrom, this.system.getCenter());
        arrow.color = this.getFactionForUIColors().getBaseUIColor();
        arrow.width = 20.0f;
        result.add(arrow);
        return result;
    }

    @Override
    public boolean shouldCancelRouteAfterDelayCheck(RouteManager.RouteData route) {
        return false;
    }

    @Override
    public boolean shouldRepeat(RouteManager.RouteData route) {
        return false;
    }

    @Override
    public void reportAboutToBeDespawnedByRouteManager(RouteManager.RouteData route) {
    }

    @Override
    public CampaignFleetAPI spawnFleet(RouteManager.RouteData route) {
        Random random = route.getRandom();
        MarketAPI market = route.getMarket();
        CampaignFleetAPI fleet = this.createFleet(market.getFactionId(), route, market, null, random);
        if (fleet == null || fleet.isEmpty()) {
            return null;
        }
        market.getContainingLocation().addEntity(fleet);
        fleet.setFacing((float)Math.random() * 360.0f);
        fleet.setLocation(market.getPrimaryEntity().getLocation().x, market.getPrimaryEntity().getLocation().x);
        fleet.addScript(this.createAssignmentAI(fleet, route));
        return fleet;
    }

    public RouteFleetAssignmentAI createAssignmentAI(CampaignFleetAPI fleet, RouteManager.RouteData route) {
        ActionStage action = this.getActionStage();
        BaseAssignmentAI.FleetActionDelegate delegate = null;
        if (action instanceof BaseAssignmentAI.FleetActionDelegate) {
            delegate = (BaseAssignmentAI.FleetActionDelegate)((Object)action);
        }
        return new RaidAssignmentAI(fleet, route, delegate);
    }

    public CampaignFleetAPI createFleet(String factionId, RouteManager.RouteData route, MarketAPI market, Vector2f locInHyper, Random random) {
        if (random == null) {
            random = new Random();
        }
        RouteManager.OptionalFleetData extra = route.getExtra();
        float combat = extra.fp.floatValue();
        float tanker = extra.fp.floatValue() * (0.1f + random.nextFloat() * 0.05f);
        float transport = extra.fp.floatValue() * (0.1f + random.nextFloat() * 0.05f);
        float freighter = 0.0f;
        combat -= tanker;
        FleetParamsV3 params = new FleetParamsV3(market, locInHyper, factionId, route == null ? null : route.getQualityOverride(), extra.fleetType, combat -= transport, freighter, tanker, transport, 0.0f, 0.0f, 0.0f);
        if (route != null) {
            params.timestamp = route.getTimestamp();
        }
        params.random = random;
        CampaignFleetAPI fleet = FleetFactoryV3.createFleet(params);
        if (fleet == null || fleet.isEmpty()) {
            return null;
        }
        fleet.getMemoryWithoutUpdate().set("$isWarFleet", true);
        fleet.getMemoryWithoutUpdate().set("$isRaider", true);
        if (fleet.getFaction().getCustomBoolean("pirateBehavior")) {
            fleet.getMemoryWithoutUpdate().set("$isPirate", true);
        }
        String postId = Ranks.POST_PATROL_COMMANDER;
        String rankId = Ranks.SPACE_COMMANDER;
        fleet.getCommander().setPostId(postId);
        fleet.getCommander().setRankId(rankId);
        return fleet;
    }

    public float getRaidFPAdjusted() {
        MarketAPI source = this.getFirstSource();
        float raidFP = this.getRaidFP();
        float raidStr = Misc.getAdjustedFP(raidFP, source);
        return raidStr;
    }

    public float getRaidFP() {
        AssembleStage as = this.getAssembleStage();
        float raidStr = 0.0f;
        for (RouteManager.RouteData route : as.getRoutes()) {
            CampaignFleetAPI fleet = route.getActiveFleet();
            if (fleet != null) {
                float mult = Misc.getAdjustedFP(1.0f, route.getMarket());
                if (mult < 1.0f) {
                    mult = 1.0f;
                }
                raidStr += (float)fleet.getFleetPoints() / mult;
                continue;
            }
            raidStr += route.getExtra().fp.floatValue();
        }
        if (raidStr <= 0.0f || as.getSpawnFP() > 0.0f) {
            raidStr = Math.max(as.getOrigSpawnFP(), raidStr);
        }
        float raidFP = raidStr;
        return raidFP;
    }

    public float getNumFleets() {
        AssembleStage as = this.getAssembleStage();
        float num = as.getRoutes().size();
        if (as.getSpawnFP() > 0.0f) {
            num = Math.max(num, as.getOrigSpawnFP() / as.getLargeSize(false));
        }
        if (num < 1.0f) {
            num = 1.0f;
        }
        return num;
    }

    public float getOrigNumFleets() {
        AssembleStage as = this.getAssembleStage();
        float num = (float)Math.ceil(as.getOrigSpawnFP() / as.getLargeSize(false));
        if (num < 1.0f) {
            num = 1.0f;
        }
        return num;
    }

    public float getRaidStr() {
        MarketAPI source = this.getFirstSource();
        float raidFP = this.getRaidFP();
        float raidStr = Misc.getAdjustedStrength(raidFP, source);
        return raidStr;
    }

    protected String getRaidStrDesc() {
        return Misc.getStrengthDesc(this.getRaidStr());
    }

    public void addStandardStrengthComparisons(TooltipMakerAPI info, MarketAPI target, FactionAPI targetFaction, boolean withGround, boolean withBombard, String raid, String raids) {
        Color h = Misc.getHighlightColor();
        float opad = 10.0f;
        float raidFP = this.getRaidFPAdjusted() / this.getNumFleets();
        float raidStr = this.getRaidStr();
        float defenderStr = WarSimScript.getFactionStrength(targetFaction, this.system);
        float defensiveStr = defenderStr + WarSimScript.getStationStrength(targetFaction, this.system, target.getPrimaryEntity());
        float assumedRaidGroundStr = raidFP * Misc.FP_TO_GROUND_RAID_STR_APPROX_MULT;
        float re = MarketCMD.getRaidEffectiveness(target, assumedRaidGroundStr);
        String spaceStr = "";
        String groundStr = "";
        String outcomeDesc = null;
        boolean even = false;
        if (raidStr < defensiveStr * 0.75f) {
            spaceStr = "outmatched";
            if (outcomeDesc == null) {
                outcomeDesc = "The " + raid + " is likely to be defeated in orbit";
            }
        } else if (raidStr < defensiveStr * 1.25f) {
            spaceStr = "evenly matched";
            if (outcomeDesc == null) {
                outcomeDesc = "The " + raids + " outcome is uncertain";
            }
            even = true;
        } else {
            spaceStr = "superior";
            if (!withGround && !withBombard && outcomeDesc == null) {
                outcomeDesc = "The " + raid + " is likely to be successful";
            }
        }
        if (withGround) {
            if (re < 0.33f) {
                groundStr = "outmatched";
                if (outcomeDesc == null || even) {
                    outcomeDesc = "The " + raid + " is likely to be largely repelled by the ground defences";
                }
            } else if (re < 0.66f) {
                groundStr = "evenly matched";
                if (outcomeDesc == null) {
                    outcomeDesc = "The " + raids + " outcome is uncertain";
                }
            } else {
                groundStr = "superior";
                if (outcomeDesc == null) {
                    outcomeDesc = "The " + raid + " is likely to be successful";
                }
            }
            info.addPara("Compared to the defenses, the " + raids + " space forces are %s " + "and its ground forces are %s." + " " + outcomeDesc + ".", opad, h, spaceStr, groundStr);
        } else if (withBombard) {
            float available;
            float required = MarketCMD.getBombardmentCost(target, null);
            if ((double)required * 0.67 > (double)(available = raidFP * Misc.FP_TO_BOMBARD_COST_APPROX_MULT)) {
                groundStr = "outmatched";
                if (outcomeDesc == null) {
                    outcomeDesc = "The bombardment is likely to be countered by the ground defences";
                }
            } else if (required * 1.33f > available) {
                groundStr = "evenly matched";
                if (outcomeDesc == null) {
                    outcomeDesc = "The bombardment's outcome is uncertain";
                }
            } else {
                groundStr = "superior";
                if (outcomeDesc == null) {
                    outcomeDesc = "The bombardment is likely to be successful";
                }
            }
            info.addPara("Compared to the defenses, the " + raids + " space forces are %s. " + outcomeDesc + ".", opad, h, spaceStr, groundStr);
        } else {
            info.addPara("Compared to the defenses of " + target.getName() + ", " + "the " + raids + " space forces are %s." + " " + outcomeDesc + ".", opad, h, spaceStr, groundStr);
        }
    }

    @Override
    public IntelInfoPlugin.IntelSortTier getSortTier() {
        this.isPlayerTargeted();
        return super.getSortTier();
    }

    public static interface RaidDelegate {
        public void notifyRaidEnded(RaidIntel var1, RaidStageStatus var2);
    }

    public static interface RaidStage {
        public RaidStageStatus getStatus();

        public void advance(float var1);

        public void notifyStarted();

        public float getExtraDaysUsed();

        public void showStageInfo(TooltipMakerAPI var1);

        public float getElapsed();

        public float getMaxDays();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RaidStageStatus {
        ONGOING,
        SUCCESS,
        FAILURE;

    }
}

