/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.campaign.listeners.EconomyTickListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommodityProductionMission
extends HubMissionWithBarEvent
implements EconomyTickListener,
TooltipMakerAPI.TooltipCreator {
    public static float PROB_COMPLICATIONS = 0.5f;
    public static float PROB_UNDERWORLD_BAR = 0.25f;
    public static float MISSION_DAYS = 730.0f;
    public static int MISSION_CYCLES = Math.round(MISSION_DAYS / 365.0f);
    public static int CONTRACT_DAYS = Math.round(1825.0f);
    public static int CONTRACT_MONTHS = Math.round((float)CONTRACT_DAYS * 12.0f / 365.0f);
    public static int CONTRACT_CYCLES = Math.round((float)CONTRACT_DAYS * 1.0f / 365.0f);
    public static float REWARD_MULT_WHEN_PRODUCING_ALREADY = 0.2f;
    public static float REWARD_MULT_WHEN_NOT_PRODUCING_ALREADY = 1.0f;
    protected Variation variation;
    protected String commodityId;
    protected int needed;
    protected int monthlyPayment;
    protected int totalPayment;
    protected int monthsRemaining;
    protected String uid;
    protected transient CommoditySpecAPI spec;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person;
        if (barEvent) {
            this.setGiverRank(Ranks.CITIZEN);
            String post = this.pickOne(Ranks.POST_TRADER, Ranks.POST_COMMODITIES_AGENT, Ranks.POST_PORTMASTER, Ranks.POST_MERCHANT, Ranks.POST_INVESTOR, Ranks.POST_EXECUTIVE, Ranks.POST_SENIOR_EXECUTIVE);
            this.setGiverPost(post);
            if (post.equals(Ranks.POST_SENIOR_EXECUTIVE)) {
                this.setGiverImportance(this.pickHighImportance());
            } else {
                this.setGiverImportance(this.pickImportance());
            }
            if (this.rollProbability(PROB_UNDERWORLD_BAR)) {
                this.setGiverTags("underworld");
                this.setGiverFaction("pirates");
            } else {
                this.setGiverTags("trade");
            }
            this.findOrCreateGiver(createdAt, false, false);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$cpm_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        PersonImportance importance = person.getImportance();
        int minNeeded = 3;
        int maxNeeded = 9;
        switch (importance) {
            case VERY_LOW: {
                minNeeded = 2;
                maxNeeded = 4;
                break;
            }
            case LOW: {
                minNeeded = 3;
                maxNeeded = 5;
                break;
            }
            case MEDIUM: {
                minNeeded = 4;
                maxNeeded = 6;
                break;
            }
            case HIGH: {
                minNeeded = 5;
                maxNeeded = 7;
                break;
            }
            case VERY_HIGH: {
                minNeeded = 6;
                maxNeeded = 10;
            }
        }
        this.needed = minNeeded + this.genRandom.nextInt(maxNeeded - minNeeded + 1);
        MarketAPI market = this.getPerson().getMarket();
        if (market == null) {
            return false;
        }
        if (market.isPlayerOwned()) {
            return false;
        }
        WeightedRandomPicker<String> commoditiesPlayerIsNotProducing = new WeightedRandomPicker<String>(this.genRandom);
        WeightedRandomPicker<String> commoditiesPlayerIsProducing = new WeightedRandomPicker<String>(this.genRandom);
        ArrayList<String> all = new ArrayList<String>();
        for (CommoditySpecAPI spec : Global.getSettings().getAllCommoditySpecs()) {
            boolean illegal;
            if (spec.isPersonnel() || spec.isMeta() || spec.isNonEcon() || !spec.isPrimary() || market.getCommodityData(spec.getId()).getMaxDemand() < minNeeded / 2 || (illegal = market.isIllegal(spec.getId())) && !person.hasTag("underworld") || !illegal && !person.hasTag("trade")) continue;
            all.add(spec.getId());
        }
        for (String cid : all) {
            commoditiesPlayerIsNotProducing.add(cid);
            for (MarketAPI curr : Misc.getPlayerMarkets(true)) {
                CommodityOnMarketAPI com = curr.getCommodityData(cid);
                if (com.getMaxSupply() <= 0) continue;
                commoditiesPlayerIsProducing.add(cid, Math.max(1, 10 - com.getMaxSupply()));
                commoditiesPlayerIsNotProducing.remove(cid);
            }
        }
        this.commodityId = (String)commoditiesPlayerIsNotProducing.pick();
        if (this.commodityId == null) {
            this.commodityId = (String)commoditiesPlayerIsProducing.pick();
        }
        if (this.commodityId == null) {
            return false;
        }
        if (this.commodityId.equals("organs")) {
            this.needed = Math.min(3, this.needed);
        }
        if (this.commodityId.equals("drugs")) {
            this.needed = Math.min(6, this.needed);
        }
        this.variation = commoditiesPlayerIsNotProducing.getItems().contains(this.commodityId) ? Variation.NOT_PRODUCING : Variation.PRODUCING_ALREADY;
        float basePayment = 1000.0f + this.getSpec().getBasePrice() * 10.0f;
        basePayment = this.variation == Variation.NOT_PRODUCING ? (basePayment *= REWARD_MULT_WHEN_NOT_PRODUCING_ALREADY) : (basePayment *= REWARD_MULT_WHEN_PRODUCING_ALREADY);
        this.monthlyPayment = CommodityProductionMission.getRoundNumber(basePayment * (float)this.needed);
        this.totalPayment = Math.round(this.monthlyPayment * CONTRACT_MONTHS);
        if (this.monthlyPayment <= 0) {
            return false;
        }
        this.setStartingStage((Object)Stage.WAITING);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setFailureStage((Object)Stage.FAILED);
        this.connectWithCustomCondition((Object)Stage.WAITING, (Object)Stage.PAYING, new CheckPlayerProduction(this.commodityId, this.needed));
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[]{Stage.PAYING});
        this.monthsRemaining = CONTRACT_MONTHS;
        return true;
    }

    @Override
    public void setCurrentStage(Object next, InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.setCurrentStage(next, dialog, memoryMap);
        if (next == Stage.PAYING) {
            this.addPotentialContacts(dialog);
        }
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$cpm_barEvent", this.isBarEvent());
        this.set("$cpm_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$cpm_monthlyPayment", Misc.getWithDGS(this.monthlyPayment));
        this.set("$cpm_underworld", this.getPerson().hasTag("underworld"));
        this.set("$cpm_totalPayment", Misc.getWithDGS(this.totalPayment));
        this.set("$cpm_missionCycles", MISSION_CYCLES);
        this.set("$cpm_contractCycles", CONTRACT_CYCLES);
        this.set("$cpm_commodityName", this.getSpec().getLowerCaseName());
        this.set("$cpm_needed", this.needed);
        this.set("$cpm_playerHasColony", !Misc.getPlayerMarkets(false).isEmpty());
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.WAITING) {
            info.addPara("Produce at least %s units of " + this.getSpec().getLowerCaseName() + " at " + "a colony under your control.", opad, h, "" + this.needed);
            info.addPara("Once these terms are met, you will receive %s per month for the next %s cycles, for a total of %s, as long as production is maintained.", opad, h, Misc.getDGSCredits(this.monthlyPayment), "" + CONTRACT_CYCLES, Misc.getDGSCredits(this.totalPayment));
            if (!CommodityProductionMission.playerHasAColony()) {
                info.addPara("You will need to survey a suitable planet and establish a colony to complete this mission.", opad);
            }
        } else if (this.currentStage == Stage.PAYING) {
            info.addPara("You've met the initial terms of the contract to produce %s units of " + this.getSpec().getLowerCaseName() + " at " + "a colony under your control.", opad, h, "" + this.needed);
            info.addPara("As long these terms are met, you will receive %s per month over %s cycles for a total payout of %s, assuming there is no interruption in production.", opad, h, Misc.getDGSCredits(this.monthlyPayment), "" + CONTRACT_CYCLES, Misc.getDGSCredits(this.totalPayment));
            info.addPara("Months remaining: %s", opad, h, "" + this.monthsRemaining);
            if (CommodityProductionMission.isPlayerProducing(this.commodityId, this.needed)) {
                info.addPara("You are currently meeting the terms of the contract.", Misc.getPositiveHighlightColor(), opad);
            } else {
                info.addPara("You are not currently meeting the terms of the contract.", Misc.getNegativeHighlightColor(), opad);
            }
        } else if (this.currentStage == Stage.COMPLETED) {
            info.addPara("The contract is completed.", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.WAITING) {
            info.addPara("Produce at least %s units of " + this.getSpec().getLowerCaseName() + " at " + "a colony", pad, tc, h, "" + this.needed);
            return true;
        }
        if (this.currentStage == Stage.PAYING) {
            info.addPara("Receiving %s per month", pad, tc, h, Misc.getDGSCredits(this.monthlyPayment));
            info.addPara("Months remaining: %s", 0.0f, tc, h, "" + this.monthsRemaining);
            if (CommodityProductionMission.isPlayerProducing(this.commodityId, this.needed)) {
                info.addPara("Terms of contract met", tc, 0.0f);
            } else {
                info.addPara("Terms of contract not met", Misc.getNegativeHighlightColor(), 0.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return String.valueOf(this.getSpec().getName()) + " Production";
    }

    public static boolean playerHasAColony() {
        return !Misc.getPlayerMarkets(true).isEmpty();
    }

    public static boolean isPlayerProducing(String commodityId, int quantity) {
        for (MarketAPI market : Misc.getPlayerMarkets(true)) {
            CommodityOnMarketAPI com = market.getCommodityData(commodityId);
            if (com.getMaxSupply() < quantity) continue;
            return true;
        }
        return false;
    }

    protected CommoditySpecAPI getSpec() {
        if (this.spec == null) {
            this.spec = Global.getSettings().getCommoditySpec(this.commodityId);
        }
        return this.spec;
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getListenerManager().removeListener(this);
    }

    @Override
    public void acceptImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.acceptImpl(dialog, memoryMap);
        Global.getSector().getListenerManager().addListener(this);
        this.uid = Misc.genUID();
        this.connectWithGlobalFlag((Object)Stage.PAYING, (Object)Stage.COMPLETED, this.getCompletionFlag());
        if (this.rollProbability(PROB_COMPLICATIONS)) {
            DelayedFleetEncounter e = new DelayedFleetEncounter(this.genRandom, this.getMissionId());
            e.setDelay(MISSION_DAYS * 0.5f);
            e.setLocationInnerSector(true, "pirates");
            e.beginCreate();
            e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.VERY_LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "pirates", "patrolLarge", new Vector2f());
            e.triggerSetAdjustStrengthBasedOnQuality(true, this.getQuality());
            e.triggerSetStandardAggroPirateFlags();
            e.triggerSetStandardAggroInterceptFlags();
            e.triggerSetFleetMemoryValue("$cpm_commodityName", this.getSpec().getLowerCaseName());
            e.triggerSetFleetGenericHailPermanent("CPMPirateHail");
            e.endCreate();
        }
    }

    public String getCompletionFlag() {
        return "$" + this.getMissionId() + "_" + this.commodityId + "_" + this.uid + "_completed";
    }

    @Override
    public void reportEconomyTick(int iterIndex) {
        if (this.currentStage != Stage.PAYING) {
            return;
        }
        int numIter = (int)Global.getSettings().getFloat("economyIterPerMonth");
        MonthlyReport report = SharedData.getData().getCurrentReport();
        MonthlyReport.FDNode colonyNode = report.getNode(MonthlyReport.OUTPOSTS);
        MonthlyReport.FDNode paymentNode = report.getNode(colonyNode, String.valueOf(this.getMissionId()) + "_" + this.commodityId + "_" + this.uid);
        paymentNode.income += (float)(this.monthlyPayment / numIter);
        paymentNode.name = this.getBaseName();
        paymentNode.icon = this.getSpec().getIconName();
        paymentNode.tooltipCreator = this;
    }

    @Override
    public void reportEconomyMonthEnd() {
        --this.monthsRemaining;
        if (this.monthsRemaining <= 0) {
            Global.getSector().getMemoryWithoutUpdate().set(this.getCompletionFlag(), true);
        }
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
        tooltip.addSpacer(-10.0f);
        this.addDescriptionForNonEndStage(tooltip, this.getTooltipWidth(tooltipParam), 1000.0f);
    }

    @Override
    public float getTooltipWidth(Object tooltipParam) {
        return 450.0f;
    }

    @Override
    public boolean isTooltipExpandable(Object tooltipParam) {
        return false;
    }

    @Override
    protected String getMissionTypeNoun() {
        return "contract";
    }

    public static class CheckPlayerProduction
    implements BaseHubMission.ConditionChecker {
        protected String commodityId;
        protected int quantity;

        public CheckPlayerProduction(String commodityId, int quantity) {
            this.commodityId = commodityId;
            this.quantity = quantity;
        }

        public boolean conditionsMet() {
            return CommodityProductionMission.isPlayerProducing(this.commodityId, this.quantity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        WAITING,
        PAYING,
        COMPLETED,
        FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variation {
        PRODUCING_ALREADY,
        NOT_PRODUCING;

    }
}

