/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class DeadDropMission
extends HubMissionWithBarEvent {
    public static float PROB_COMPLICATIONS = 0.5f;
    public static float PROB_PATROL_AFTER = 0.5f;
    public static float MISSION_DAYS = 120.0f;
    protected String thing;
    protected SectorEntityToken target;
    protected StarSystemAPI system;

    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (barEvent) {
            this.setGiverRank(Ranks.CITIZEN);
            this.setGiverPost(this.pickOne(Ranks.POST_AGENT, Ranks.POST_SMUGGLER, Ranks.POST_GANGSTER, Ranks.POST_FENCE, Ranks.POST_CRIMINAL));
            this.setGiverImportance(this.pickImportance());
            this.setGiverFaction("pirates");
            this.setGiverTags("underworld");
            this.findOrCreateGiver(createdAt, false, false);
        }
        this.thing = this.pickOne("an apparently inert data chip", "a rad-shielded salvors' TriPad", "a cloudy, damaged data crystal", "a small EM-shielded safe", "a hardcopy book made of paper", "a sewing kit with strangely curved needles", "a single rose in a miniaturized stasis field", "a small packet of seeds embossed with a Luddic sigil", "an aged, twisted piece of wood", "an irradiated bulkhead in a shielded crate", "a black Volturnian lobster shell", "a biosample in sealed cylinder", "a peculiar vial of blood", "a powdered substance in a triple-sealed container", "a single vacuum-desiccated finger", "a tiny unicorn pendant", "a delicate crane made of folded paper", "a scratched golden ring", "a gravimatic trap holding some kind of glowing mote", "a battered Hegemony officer's pistol", "a large brilliant-cut diamond", "a captain's safe cut from its bulkhead", "a glowing blue crystal in a sealed tube");
        PersonAPI person = this.getPerson();
        if (person == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$ddro_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        this.requireSystemNot(createdAt.getStarSystem());
        this.requireSystemInterestingAndNotUnsafeOrCore();
        this.preferSystemInInnerSector();
        this.preferSystemUnexplored();
        this.preferSystemInDirectionOfOtherMissions();
        this.system = this.pickSystem();
        if (this.system == null) {
            return false;
        }
        this.target = this.spawnMissionNode(new BaseHubMission.LocData(BaseHubMission.EntityLocationType.HIDDEN_NOT_NEAR_STAR, null, this.system));
        if (!this.setEntityMissionRef(this.target, "$ddro_ref")) {
            return false;
        }
        this.makeImportant(this.target, "$ddro_target", Stage.DROP_OFF);
        this.setStartingStage((Object)Stage.DROP_OFF);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setFailureStage((Object)Stage.FAILED);
        this.setStageOnMemoryFlag((Object)Stage.COMPLETED, this.target, "$ddro_completed");
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[0]);
        this.setCreditReward(BaseHubMission.CreditReward.HIGH);
        if (this.rollProbability(PROB_COMPLICATIONS)) {
            this.triggerComplicationBegin((Object)Stage.DROP_OFF, HubMissionWithTriggers.ComplicationSpawn.APPROACHING_OR_ENTERING, this.system, "pirates", "the " + this.getWithoutArticle(this.thing), "it", "the " + this.getWithoutArticle(this.thing) + " given to you by " + person.getNameString(), 0, true, HubMissionWithTriggers.ComplicationRepImpact.NONE, null);
            this.triggerComplicationEnd(true);
        }
        return true;
    }

    protected void notifyEnding() {
        super.notifyEnding();
        if (this.isSucceeded() && this.rollProbability(PROB_PATROL_AFTER)) {
            PersonAPI person = this.getPerson();
            if (person == null || person.getMarket() == null) {
                return;
            }
            String patrolFaction = person.getMarket().getFactionId();
            if (patrolFaction.equals(person.getFaction().getId()) || Misc.isPirateFaction(person.getMarket().getFaction()) || "player".equals(patrolFaction)) {
                return;
            }
            DelayedFleetEncounter e = new DelayedFleetEncounter(this.genRandom, this.getMissionId());
            e.setDelayNone();
            e.setLocationInnerSector(true, patrolFaction);
            e.beginCreate();
            e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, patrolFaction, "patrolLarge", new Vector2f());
            e.setFleetWantsThing(patrolFaction, "the dead drop coordinates", "they", "the dead drop coordinates given to you by " + person.getNameString(), 0, true, HubMissionWithTriggers.ComplicationRepImpact.FULL, DelayedFleetEncounter.TRIGGER_REP_LOSS_MEDIUM, this.getPerson());
            e.triggerSetAdjustStrengthBasedOnQuality(true, this.getQuality());
            e.triggerSetPatrol();
            e.triggerSetStandardAggroInterceptFlags();
            e.endCreate();
        }
    }

    protected void updateInteractionDataImpl() {
        this.set("$ddro_barEvent", this.isBarEvent());
        this.set("$ddro_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$ddro_heOrShe", this.getPerson().getHeOrShe());
        this.set("$ddro_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$ddro_aOrAnThing", this.thing);
        this.set("$ddro_thing", this.getWithoutArticle(this.thing));
        this.set("$ddro_personName", this.getPerson().getNameString());
        this.set("$ddro_systemName", this.system.getNameWithLowercaseTypeShort());
        this.set("$ddro_dist", this.getDistanceLY(this.target));
    }

    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.DROP_OFF) {
            info.addPara("Deliver " + this.thing + " to the dead drop location at the " + "specified coordinates in the " + this.system.getNameWithLowercaseTypeShort() + ".", opad);
        }
    }

    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.DROP_OFF) {
            info.addPara("Deliver " + this.getWithoutArticle(this.thing) + " to specified location in the " + this.system.getNameWithLowercaseTypeShort(), tc, pad);
            return true;
        }
        return false;
    }

    public String getBaseName() {
        return "Dead Drop";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        DROP_OFF,
        COMPLETED,
        FAILED;

    }
}

