/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class ExtractionMission
extends HubMissionWithBarEvent {
    public static float PROB_BASE_INSTEAD_OF_MARKET_MIN = 0.25f;
    public static float PROB_BASE_INSTEAD_OF_MARKET_MAX = 0.75f;
    public static float PROB_PIRATE_BASE_WHEN_BASE = 0.5f;
    public static float PROB_ADDITIONAL_PATROLS = 0.5f;
    public static float MISSION_DAYS = 120.0f;
    protected Variation variation;
    protected MarketAPI market;
    protected MarketCMD.RaidDangerLevel danger;
    protected int storyCost = 0;
    protected String seedyBarOwner;

    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        float pBase;
        PersonAPI person;
        if ("pirates".equals(createdAt.getFaction().getId())) {
            return false;
        }
        if (barEvent) {
            this.setGiverRank(Ranks.CITIZEN);
            this.setGiverPost(Ranks.POST_AGENT);
            this.setGiverImportance(this.pickImportance());
            this.setGiverTags("military");
            this.findOrCreateGiver(createdAt, true, false);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$extr_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        this.seedyBarOwner = this.pickOne("Eduardo", "Roy", "Hyde", "Shang", "Rick", "Bogdan", "William", "Marlowe", "Benny");
        PersonImportance importance = person.getImportance();
        int minMarketSize = 3;
        int maxMarketSize = 9;
        switch (importance) {
            case VERY_LOW: {
                minMarketSize = 3;
                maxMarketSize = 4;
                break;
            }
            case LOW: {
                minMarketSize = 4;
                maxMarketSize = 4;
                break;
            }
            case MEDIUM: {
                minMarketSize = 5;
                maxMarketSize = 5;
                break;
            }
            case HIGH: {
                minMarketSize = 5;
                maxMarketSize = 6;
                break;
            }
            case VERY_HIGH: {
                minMarketSize = 6;
                maxMarketSize = 8;
            }
        }
        if (importance.ordinal() >= PersonImportance.HIGH.ordinal() && this.rollProbability(pBase = PROB_BASE_INSTEAD_OF_MARKET_MIN + (PROB_BASE_INSTEAD_OF_MARKET_MAX - PROB_BASE_INSTEAD_OF_MARKET_MIN) * Math.max(0.0f, this.getPerson().getRelToPlayer().getRel()))) {
            this.resetSearch();
            this.requireMarketIsNot(createdAt);
            this.requireMarketFactionNotPlayer();
            this.requireMarketMemoryFlag(PirateBaseIntel.MEM_FLAG, true);
            this.requireMarketNotInHyperspace();
            this.preferMarketInDirectionOfOtherMissions();
            MarketAPI pirateBase = this.pickMarket();
            this.resetSearch();
            this.requireMarketIsNot(createdAt);
            this.requireMarketMemoryFlag(LuddicPathBaseIntel.MEM_FLAG, true);
            this.requireMarketNotInHyperspace();
            this.preferMarketInDirectionOfOtherMissions();
            MarketAPI pathBase = this.pickMarket();
            if (this.rollProbability(PROB_PIRATE_BASE_WHEN_BASE) && pirateBase != null) {
                this.market = pirateBase;
                this.variation = Variation.PIRATE_BASE;
                this.danger = MarketCMD.RaidDangerLevel.EXTREME;
            } else {
                this.market = pathBase;
                this.variation = Variation.LUDDIC_PATH_BASE;
                this.danger = MarketCMD.RaidDangerLevel.EXTREME;
            }
        }
        if (this.market == null) {
            this.resetSearch();
            this.requireMarketIsNot(createdAt);
            this.requireMarketFactionNotPlayer();
            this.requireMarketNotHidden();
            this.requireMarketNotInHyperspace();
            this.preferMarketSizeAtLeast(minMarketSize);
            this.preferMarketSizeAtMost(maxMarketSize);
            this.preferMarketFactionHostileTo(createdAt.getFactionId());
            this.preferMarketInDirectionOfOtherMissions();
            this.market = this.pickMarket();
            this.variation = Variation.COLONY;
            this.danger = MarketCMD.RaidDangerLevel.MEDIUM;
        }
        if (this.market == null) {
            return false;
        }
        if (!this.setMarketMissionRef(this.market, "$extr_ref")) {
            return false;
        }
        int marines = this.getMarinesRequiredForCustomObjective(this.market, this.danger);
        if (!this.isOkToOfferMissionRequiringMarines(marines)) {
            return false;
        }
        this.makeImportant(this.market, "$extr_target", Stage.EXTRACT);
        this.makeImportant(this.getPerson(), "$extr_returnHere", Stage.RETURN);
        this.setStartingStage((Object)Stage.EXTRACT);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.connectWithMemoryFlag((Object)Stage.EXTRACT, (Object)Stage.RETURN, this.market, "$extr_needToReturn");
        this.setStageOnMemoryFlag((Object)Stage.COMPLETED, person, "$extr_completed");
        this.addNoPenaltyFailureStages(new Object[]{Stage.FAILED_DECIV});
        this.connectWithMarketDecivilized((Object)Stage.EXTRACT, (Object)Stage.FAILED_DECIV, this.market);
        this.setStageOnMarketDecivilized((Object)Stage.FAILED_DECIV, createdAt);
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[0]);
        int extraBonus = 0;
        if (this.variation == Variation.PIRATE_BASE || this.variation == Variation.LUDDIC_PATH_BASE) {
            extraBonus = 75000;
        }
        int bonus = this.getRewardBonusForMarines(this.getMarinesRequiredForCustomObjective(this.market, this.danger));
        this.setCreditRewardWithBonus(BaseHubMission.CreditReward.AVERAGE, bonus + extraBonus);
        this.storyCost = ExtractionMission.getRoundNumber(this.getCreditsReward() / 2);
        if (this.rollProbability(PROB_ADDITIONAL_PATROLS)) {
            if (this.market.getSize() <= 4) {
                this.triggerCreateMediumPatrolAroundMarket(this.market, (Object)Stage.EXTRACT, 0.0f);
            } else if (this.market.getSize() <= 6) {
                this.triggerCreateLargePatrolAroundMarket(this.market, (Object)Stage.EXTRACT, 0.0f);
            } else {
                this.triggerCreateMediumPatrolAroundMarket(this.market, (Object)Stage.EXTRACT, 0.0f);
                this.triggerCreateLargePatrolAroundMarket(this.market, (Object)Stage.EXTRACT, 0.0f);
            }
        }
        return true;
    }

    protected void updateInteractionDataImpl() {
        this.set("$extr_variation", (Object)this.variation);
        this.set("$extr_barName", String.valueOf(this.seedyBarOwner) + "'s");
        this.set("$extr_barOwner", this.seedyBarOwner);
        this.set("$extr_barEvent", this.isBarEvent());
        this.set("$extr_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$extr_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$extr_storyCost", Misc.getWithDGS(this.storyCost));
        this.set("$extr_systemName", this.market.getStarSystem().getNameWithLowercaseTypeShort());
        this.set("$extr_marketName", this.market.getName());
        this.set("$extr_marketOnOrAt", this.market.getOnOrAt());
        this.set("$extr_marketFactionArticle", this.market.getFaction().getPersonNamePrefixAOrAn());
        this.set("$extr_marketFaction", this.market.getFaction().getPersonNamePrefix());
        this.set("$extr_factionColor", this.market.getFaction().getBaseUIColor());
        this.set("$extr_dist", this.getDistanceLY(this.market));
        this.set("$extr_danger", (Object)this.danger);
        this.set("$extr_marines", Misc.getWithDGS(this.getMarinesRequiredForCustomObjective(this.market, this.danger)));
    }

    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.EXTRACT) {
            info.addPara("Extract agent located " + this.market.getOnOrAt() + " " + this.market.getName() + " in the " + this.market.getStarSystem().getNameWithLowercaseTypeShort() + ".", opad);
            if (this.variation == Variation.PIRATE_BASE || this.variation == Variation.LUDDIC_PATH_BASE) {
                FactionAPI f = this.market.getFaction();
                info.addPara("The target location is " + f.getPersonNamePrefixAOrAn() + " %s base.", opad, f.getBaseUIColor(), f.getPersonNamePrefix());
            } else {
                FactionAPI f = this.market.getFaction();
                LabelAPI label = info.addPara("The target location is a size %s colony controlled by " + f.getDisplayNameWithArticle() + ".", opad, f.getBaseUIColor(), "" + this.market.getSize(), f.getDisplayNameWithArticleWithoutArticle());
                label.setHighlight("" + this.market.getSize(), f.getDisplayNameWithArticleWithoutArticle());
                label.setHighlightColors(h, f.getBaseUIColor());
            }
            this.addCustomRaidInfo(this.market, this.danger, info, opad);
        } else if (this.currentStage == Stage.RETURN) {
            info.addPara(String.valueOf(this.getReturnText(this.getPerson().getMarket().getName())) + ".", opad);
        }
    }

    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.EXTRACT) {
            info.addPara("Extract agent from " + this.market.getName() + " in the " + this.market.getStarSystem().getNameWithLowercaseTypeShort() + ".", pad, tc, this.market.getFaction().getBaseUIColor(), this.market.getName());
            return true;
        }
        if (this.currentStage == Stage.RETURN) {
            info.addPara(this.getReturnTextShort(this.getPerson().getMarket().getName()), tc, pad);
            return true;
        }
        return false;
    }

    public String getBaseName() {
        return "Combat Extraction";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        EXTRACT,
        RETURN,
        COMPLETED,
        FAILED,
        FAILED_DECIV;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variation {
        COLONY,
        PIRATE_BASE,
        LUDDIC_PATH_BASE;

    }
}

