/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class SpySatDeployment
extends HubMissionWithBarEvent {
    public static float PROB_BAR_UNDERWORLD = 0.25f;
    public static float PROB_PATROL_AROUND_TARGET = 0.5f;
    public static float MISSION_DAYS = 120.0f;
    protected MarketAPI market;
    protected SectorEntityToken target;

    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person;
        if (barEvent) {
            if (this.rollProbability(PROB_BAR_UNDERWORLD)) {
                this.setGiverRank(Ranks.CITIZEN);
                this.setGiverPost(this.pickOne(Ranks.POST_AGENT, Ranks.POST_SMUGGLER, Ranks.POST_GANGSTER, Ranks.POST_FENCE, Ranks.POST_CRIMINAL));
                this.setGiverImportance(this.pickImportance());
                this.setGiverFaction("pirates");
                this.setGiverTags("underworld");
            } else {
                this.setGiverRank(Ranks.CITIZEN);
                this.setGiverPost(Ranks.POST_AGENT);
                this.setGiverImportance(this.pickImportance());
                if ("pirates".equals(createdAt.getFaction().getId())) {
                    this.setGiverTags("underworld");
                    this.setGiverFaction("pirates");
                } else {
                    this.setGiverTags("military");
                }
            }
            this.findOrCreateGiver(createdAt, false, false);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$ssat_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        this.requireMarketIsNot(createdAt);
        this.requireMarketLocationNot(createdAt.getContainingLocation());
        this.requireMarketFactionNotPlayer();
        this.requireMarketFactionNot(person.getFaction().getId());
        this.requireMarketFactionCustom(ReqMode.NOT_ANY, "allowsTransponderOffTrade");
        this.requireMarketMilitary();
        this.requireMarketNotHidden();
        this.requireMarketNotInHyperspace();
        this.preferMarketInDirectionOfOtherMissions();
        this.market = this.pickMarket();
        if (this.market == null) {
            return false;
        }
        this.target = this.spawnMissionNode(new BaseHubMission.LocData(BaseHubMission.EntityLocationType.ORBITING_PARAM, this.market.getPrimaryEntity(), this.market.getStarSystem()));
        if (!this.setEntityMissionRef(this.target, "$ssat_ref")) {
            return false;
        }
        this.makeImportant(this.target, "$ssat_target", Stage.DEPLOY);
        this.setMapMarkerNameColor(this.market.getTextColorForFactionOrPlanet());
        this.setStartingStage((Object)Stage.DEPLOY);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setFailureStage((Object)Stage.FAILED);
        this.setStageOnMemoryFlag((Object)Stage.COMPLETED, this.target, "$ssat_completed");
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[0]);
        this.setCreditReward(BaseHubMission.CreditReward.AVERAGE, this.market.getSize());
        if (this.rollProbability(PROB_PATROL_AROUND_TARGET)) {
            this.triggerCreateMediumPatrolAroundMarket(this.market, (Object)Stage.DEPLOY, 1.0f);
        }
        return true;
    }

    protected void updateInteractionDataImpl() {
        this.set("$ssat_barEvent", this.isBarEvent());
        this.set("$ssat_underworld", this.getPerson().hasTag("underworld"));
        this.set("$ssat_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$ssat_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$ssat_personName", this.getPerson().getNameString());
        this.set("$ssat_systemName", this.market.getStarSystem().getNameWithLowercaseTypeShort());
        this.set("$ssat_marketName", this.market.getName());
        this.set("$ssat_marketOnOrAt", this.market.getOnOrAt());
        this.set("$ssat_dist", this.getDistanceLY(this.market));
    }

    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.DEPLOY) {
            info.addPara("Deploy a spysat in orbit of " + this.market.getName() + " in the " + this.market.getStarSystem().getNameWithLowercaseTypeShort() + ".", opad);
        }
    }

    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.DEPLOY) {
            info.addPara("Deploy spysat near " + this.market.getName() + " in the " + this.market.getStarSystem().getNameWithLowercaseTypeShort(), tc, pad);
            return true;
        }
        return false;
    }

    public String getBaseName() {
        return "SpySat Deployment";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        DEPLOY,
        COMPLETED,
        FAILED;

    }
}

