/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.econ.impl.ShipQuality;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflater;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurplusShipHull
extends HubMissionWithBarEvent {
    public static float BASE_PRICE_MULT = 0.5f;
    protected FleetMemberAPI member;
    protected int price;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person;
        if (barEvent) {
            ArrayList<String> posts = new ArrayList<String>();
            posts.add(Ranks.POST_SUPPLY_OFFICER);
            if (Misc.isMilitary(createdAt)) {
                posts.add(Ranks.POST_BASE_COMMANDER);
            }
            if (Misc.hasOrbitalStation(createdAt)) {
                posts.add(Ranks.POST_STATION_COMMANDER);
            }
            String post = this.pickOne(posts);
            this.setGiverPost(post);
            if (post.equals(Ranks.POST_SUPPLY_OFFICER)) {
                this.setGiverRank(Ranks.SPACE_COMMANDER);
                this.setGiverImportance(this.pickImportance());
            } else if (post.equals(Ranks.POST_BASE_COMMANDER)) {
                this.setGiverRank(Ranks.GROUND_COLONEL);
                this.setGiverImportance(this.pickImportance());
            } else if (post.equals(Ranks.POST_STATION_COMMANDER)) {
                this.setGiverRank(Ranks.SPACE_CAPTAIN);
                this.setGiverImportance(this.pickHighImportance());
            }
            if ("pirates".equals(createdAt.getFaction().getId())) {
                this.setGiverTags("underworld");
                this.setGiverFaction("pirates");
            } else {
                this.setGiverTags("military");
            }
            this.findOrCreateGiver(createdAt, false, false);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        MarketAPI market = person.getMarket();
        if (market == null) {
            return false;
        }
        if (!Misc.isMilitary(market) && market.getSize() < 7) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$sShip_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        FactionAPI.ShipPickParams params = new FactionAPI.ShipPickParams(FactionAPI.ShipPickMode.PRIORITY_THEN_ALL);
        String role = SurplusShipHull.pickRole(this.getQuality(), person.getFaction(), person.getImportance(), this.genRandom);
        ShipVariantAPI variant = null;
        int i = 0;
        while (i < 10) {
            List<ShipRolePick> picks = market.getFaction().pickShip(role, params, null, this.genRandom);
            if (picks.isEmpty()) {
                return false;
            }
            String variantId = picks.get((int)0).variantId;
            variant = Global.getSettings().getVariant(variantId);
            variant = Global.getSettings().getVariant(String.valueOf(variant.getHullSpec().getHullId()) + "_Hull").clone();
            if (!variant.getHullSpec().hasTag("no_sell")) break;
            variant = null;
            ++i;
        }
        if (variant == null) {
            return false;
        }
        this.member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, variant);
        this.assignShipName(this.member, "independent");
        float quality = ShipQuality.getShipQuality(market, person.getFaction().getId());
        float averageDmods = DefaultFleetInflater.getAverageDmodsForQuality(quality);
        int addDmods = DefaultFleetInflater.getNumDModsToAdd(variant, averageDmods, this.genRandom);
        if (addDmods > 0) {
            DModManager.setDHull(variant);
            DModManager.addDMods(this.member, true, addDmods, this.genRandom);
        }
        this.member.getCrewComposition().setCrew(100000.0f);
        this.member.getRepairTracker().setCR(0.7f);
        this.price = BASE_PRICE_MULT == 1.0f ? Math.round(variant.getHullSpec().getBaseValue()) : SurplusShipHull.getRoundNumber(variant.getHullSpec().getBaseValue() * BASE_PRICE_MULT);
        this.setRepFactionChangesTiny();
        this.setRepPersonChangesVeryLow();
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$sShip_ref2", this);
        this.set("$sShip_barEvent", this.isBarEvent());
        this.set("$sShip_hullSize", this.member.getHullSpec().getDesignation().toLowerCase());
        this.set("$sShip_hullClass", this.member.getHullSpec().getHullNameWithDashClass());
        this.set("$sShip_price", Misc.getWithDGS(this.price));
        this.set("$sShip_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$sShip_rank", this.getPerson().getRank().toLowerCase());
        this.set("$sShip_rankAOrAn", this.getPerson().getRankArticle());
        this.set("$sShip_hisOrHer", this.getPerson().getHisOrHer());
        this.set("$sShip_member", this.member);
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("showShip".equals(action)) {
            dialog.getVisualPanel().showFleetMemberInfo(this.member, true);
            return true;
        }
        if ("showPerson".equals(action)) {
            dialog.getVisualPanel().showPersonInfo(this.getPerson(), true);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Surplus Ship Hull";
    }

    @Override
    public void accept(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        this.currentStage = new Object();
        this.abort();
    }

    public static String pickRole(float quality, FactionAPI faction, PersonImportance imp, Random random) {
        float p;
        float c;
        float w;
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(random);
        float cycles = PirateBaseManager.getInstance().getDaysSinceStart() / 365.0f;
        if (imp == PersonImportance.VERY_HIGH && cycles < 3.0f) {
            imp = PersonImportance.HIGH;
        }
        if (imp == PersonImportance.HIGH && cycles < 1.0f) {
            imp = PersonImportance.MEDIUM;
        }
        if (quality < 0.5f && imp.ordinal() > PersonImportance.MEDIUM.ordinal()) {
            imp = PersonImportance.MEDIUM;
        }
        if ((w = (float)faction.getDoctrine().getWarships() - 1.0f) + (c = (float)faction.getDoctrine().getCarriers() - 1.0f) + (p = (float)faction.getDoctrine().getPhaseShips() - 1.0f) < 1.0f) {
            w = 1.0f;
        }
        switch (imp) {
            case VERY_LOW: {
                picker.add("combatSmall", w);
                picker.add("combatMedium", w / 2.0f);
                picker.add("carrierSmall", c);
                picker.add("phaseSmall", p);
                break;
            }
            case LOW: {
                picker.add("combatSmall", w / 2.0f);
                picker.add("combatMedium", w);
                picker.add("carrierSmall", c);
                picker.add("phaseSmall", p);
                break;
            }
            case MEDIUM: {
                picker.add("combatMedium", w / 2.0f);
                picker.add("combatLarge", w);
                picker.add("carrierSmall", c / 2.0f);
                picker.add("carrierMedium", c);
                picker.add("phaseSmall", p / 2.0f);
                picker.add("phaseMedium", p);
                break;
            }
            case HIGH: {
                picker.add("combatMedium", w / 4.0f);
                picker.add("combatLarge", w);
                picker.add("combatCapital", w / 2.0f);
                picker.add("carrierMedium", c);
                picker.add("carrierLarge", c / 2.0f);
                picker.add("phaseMedium", p);
                picker.add("phaseLarge", p / 2.0f);
                break;
            }
            case VERY_HIGH: {
                picker.add("combatMedium", w / 4.0f);
                picker.add("combatLarge", w / 2.0f);
                picker.add("combatCapital", w);
                picker.add("carrierMedium", c / 2.0f);
                picker.add("carrierLarge", c);
                picker.add("phaseMedium", p / 2.0f);
                picker.add("phaseLarge", p);
                picker.add("phaseCapital", p / 2.0f);
            }
        }
        return (String)picker.pick();
    }
}

