/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GADepartments {
    public static String SOCIAL = "social";
    public static String INDUSTRIAL = "industrial";
    public static String MILITARY = "military";
    public static String SCIENCE = "science";
    public static String WEIRD = "weird";
    public static List<Department> departments = new ArrayList<Department>();

    static {
        GADepartments.add("Ancient Earth Studies", SOCIAL);
        GADepartments.add("Ancient Terran Philosophy", SOCIAL);
        GADepartments.add("Applied Anorthic Geometry", SCIENCE, WEIRD);
        GADepartments.add("Applied Holoarts", SOCIAL);
        GADepartments.add("Astrochemistry", INDUSTRIAL, SCIENCE);
        GADepartments.add("Astrometrics", SCIENCE);
        GADepartments.add("AI Defense Studies", SCIENCE, WEIRD, MILITARY);
        GADepartments.add("Classical Terran Studies", SOCIAL);
        GADepartments.add("Cybermedical Engineering", INDUSTRIAL, SOCIAL);
        GADepartments.add("Cybernetic Physiology", SCIENCE, SOCIAL);
        GADepartments.add("Demographic Calculus", SOCIAL);
        GADepartments.add("Domain Sociology", SOCIAL);
        GADepartments.add("Domain History", SOCIAL);
        GADepartments.add("Environmental Engineering", INDUSTRIAL);
        GADepartments.add("Exotic Manifold Engineering", INDUSTRIAL, WEIRD);
        GADepartments.add("Gravity Control", INDUSTRIAL, SCIENCE, MILITARY);
        GADepartments.add("Gravity Dynamics", SCIENCE);
        GADepartments.add("Holoart Studies", SOCIAL);
        GADepartments.add("Hyperspace Physics", SCIENCE);
        GADepartments.add("LAMBDA-F Lab", SCIENCE, WEIRD);
        GADepartments.add("Nanotech Engineering", INDUSTRIAL);
        GADepartments.add("Nanorobotics Lab", INDUSTRIAL, SCIENCE, WEIRD);
        GADepartments.add("Nonlinear Mathematics", SCIENCE, WEIRD);
        GADepartments.add("Orbital Architecture", SOCIAL, INDUSTRIAL, MILITARY);
        GADepartments.add("Post-Expansion Philosophy", SOCIAL);
        GADepartments.add("Persean Sociology", SOCIAL);
        GADepartments.add("Phase Physics", SCIENCE);
        GADepartments.add("Quantum Chemistry", SCIENCE, WEIRD);
        GADepartments.add("N-Space Resonance Lab", SCIENCE, WEIRD);
        GADepartments.add("Special Collections Library", SOCIAL, INDUSTRIAL, SCIENCE, WEIRD, MILITARY);
        GADepartments.add("Tau Hyperphysics", SCIENCE, WEIRD);
        GADepartments.add("Templeman Hyperwave Theory", WEIRD);
        GADepartments.add("Terran Biology", SCIENCE);
        GADepartments.add("Xenobiology", SCIENCE);
    }

    public static void add(String name, String ... tags) {
        departments.add(new Department(name, tags));
    }

    public static String pick(Random random, ReqMode mode, String ... tags) {
        Department d2;
        WeightedRandomPicker<Department> picker = new WeightedRandomPicker<Department>(random);
        HashSet<String> tagSet = new HashSet<String>();
        tagSet.addAll(Arrays.asList(tags));
        for (Department d2 : departments) {
            if (!GADepartments.matchesTags(mode, tagSet, d2.tags)) continue;
            picker.add(d2);
            break;
        }
        d2 = (Department)picker.pick();
        if (d2 == null) {
            d2 = departments.get(0);
        }
        return d2.name;
    }

    protected static boolean matchesTags(ReqMode mode, Collection<String> tags, Collection<String> set) {
        switch (mode) {
            case ALL: {
                for (String tag : tags) {
                    if (set.contains(tag)) continue;
                    return false;
                }
                return true;
            }
            case ANY: {
                for (String tag : tags) {
                    if (!set.contains(tag)) continue;
                    return true;
                }
                return false;
            }
            case NOT_ALL: {
                for (String tag : tags) {
                    if (set.contains(tag)) continue;
                    return true;
                }
                return false;
            }
            case NOT_ANY: {
                for (String tag : tags) {
                    if (!set.contains(tag)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static String pick(Random random, String ... tags) {
        Department d2;
        WeightedRandomPicker<Department> picker = new WeightedRandomPicker<Department>(random);
        block0: for (Department d2 : departments) {
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (d2.tags.contains(tag)) {
                    picker.add(d2);
                    continue block0;
                }
                ++n2;
            }
        }
        d2 = (Department)picker.pick();
        if (d2 == null) {
            d2 = departments.get(0);
        }
        return d2.name;
    }

    public static String pickWithAllTags(Random random, String ... tags) {
        Department d2;
        WeightedRandomPicker<Department> picker = new WeightedRandomPicker<Department>(random);
        block0: for (Department d2 : departments) {
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (!d2.tags.contains(tag)) continue block0;
                ++n2;
            }
            picker.add(d2);
        }
        d2 = (Department)picker.pick();
        if (d2 == null) {
            d2 = departments.get(0);
        }
        return d2.name;
    }

    public static class Department {
        public String name;
        public Set<String> tags = new HashSet<String>();

        public Department(String name, String ... tags) {
            this.name = name;
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                this.tags.add(tag);
                ++n2;
            }
        }
    }
}

