/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAIntro2
extends GABaseMission {
    protected int gaIntro2_credits;
    protected PersonAPI baird;
    protected PersonAPI sebestyen;
    protected boolean pointAtSebestyen = false;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaIntro2_ref")) {
            System.out.print("aborting because missions is already accepted");
            return false;
        }
        this.baird = this.getImportantPerson(People.BAIRD);
        if (this.baird == null) {
            return false;
        }
        this.sebestyen = this.getImportantPerson(People.SEBESTYEN);
        if (this.sebestyen == null) {
            return false;
        }
        this.setStartingStage((Object)Stage.GO_TO_ACADEMY);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.setStoryMission();
        this.gaIntro2_credits = 18000;
        this.setStartingStage((Object)Stage.GO_TO_ACADEMY);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.setStoryMission();
        this.makeImportant(this.baird.getMarket(), "$gaIntro2_returnHere", Stage.GO_TO_ACADEMY);
        this.setStageOnGlobalFlag((Object)Stage.GO_TO_ACADEMY, "$gaIntro2_started");
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$gaIntro2_completed");
        this.setRepFactionChangesNone();
        this.setRepPersonChangesNone();
        return true;
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("makeSebestyenImportant".equals(action)) {
            if (!this.pointAtSebestyen) {
                this.makeImportant(this.sebestyen, null, Stage.GO_TO_ACADEMY);
                this.makePrimaryObjective(this.sebestyen);
                this.makeUnimportant(this.baird.getMarket());
                this.pointAtSebestyen = true;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$gaIntro2_stage", this.getCurrentStage());
        this.set("$gaIntro2_credits", Misc.getWithDGS(this.gaIntro2_credits));
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        if (this.currentStage == Stage.GO_TO_ACADEMY) {
            if (this.pointAtSebestyen) {
                info.addPara("Return the data core to Academician Sebestyen. He'll get you your reward.", opad);
                this.addStandardMarketDesc("Sebestyen is located " + this.sebestyen.getMarket().getOnOrAt(), this.sebestyen.getMarket(), info, opad);
            } else {
                info.addPara("Return the data core to the Galatia Academy for a reward.", opad);
            }
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        if (this.currentStage == Stage.GO_TO_ACADEMY) {
            if (this.pointAtSebestyen) {
                info.addPara("Return the data core to Academician Sebestyen at the Galatia Academy in the Galatia system", tc, pad);
            } else {
                info.addPara("Go to the Galatia Academy in the Galatia system", tc, pad);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Return the Data Core";
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GO_TO_ACADEMY,
        COMPLETED;

    }
}

