/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GARansomResearcher
extends GABaseMission {
    public static float RAID_DIFFICULTY = 300.0f;
    public static float MISSION_DAYS = 120.0f;
    public static float PROB_PIRATE_VARIATION = 0.5f;
    protected MarketAPI market;
    protected Variation variation;
    protected PersonAPI contact;
    protected PersonAPI researcher;
    protected int costNormal;
    protected int costHigh;
    protected int costVeryLow;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaRR_ref")) {
            return false;
        }
        if (this.getGlobalMemory().contains("$gaRR_playerOwes")) {
            return false;
        }
        this.pickAnyDepartment();
        if (this.rollProbability(PROB_PIRATE_VARIATION)) {
            this.variation = Variation.PIRATE;
            this.setIconName("campaignMissions", "prisoner_pirate");
        } else {
            this.variation = Variation.CHURCH;
            this.setIconName("campaignMissions", "prisoner_luddic");
        }
        this.resetSearch();
        if (this.variation == Variation.PIRATE) {
            this.requireMarketFaction("pirates");
        } else {
            this.requireMarketFaction("luddic_church");
        }
        this.requireMarketNotHidden();
        this.requireMarketNotInHyperspace();
        this.requireMarketLocationNot("galatia");
        this.preferMarketInDirectionOfOtherMissions();
        this.market = this.pickMarket();
        if (this.market == null) {
            return false;
        }
        this.contact = this.variation == Variation.PIRATE ? this.findOrCreateCriminal(this.market, true) : this.findOrCreatePerson("luddic_church", this.market, true, Ranks.KNIGHT_CAPTAIN, Ranks.POST_GENERIC_MILITARY);
        if (this.contact == null) {
            return false;
        }
        this.setStartingStage((Object)Stage.GO_TO_MARKET);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.addNoPenaltyFailureStages(new Object[]{Stage.FAILED_DECIV});
        this.makeImportant(this.contact, "$gaRR_contact", Stage.GO_TO_MARKET);
        this.makeImportant(this.getPerson(), "$gaRR_returnHere", Stage.RETURN_TO_ACADEMY);
        this.connectWithGlobalFlag((Object)Stage.GO_TO_MARKET, (Object)Stage.RETURN_TO_ACADEMY, "$gaRR_needToReturn");
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$gaRR_completed");
        this.setStageOnGlobalFlag((Object)Stage.FAILED, "$gaRR_failed");
        this.connectWithMarketDecivilized((Object)Stage.GO_TO_MARKET, (Object)Stage.FAILED_DECIV, this.market);
        if (WITH_TIME_LIMIT) {
            this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, this.market.getStarSystem(), new Object[]{Stage.RETURN_TO_ACADEMY});
        }
        this.setCreditReward(BaseHubMission.CreditReward.AVERAGE);
        this.setDefaultGARepRewards();
        this.costNormal = this.genRoundNumber(60000, 70000);
        this.costHigh = this.genRoundNumber(90000, 100000);
        this.costVeryLow = this.genRoundNumber(8000, 10000);
        this.researcher = Global.getSector().getFaction("independent").createRandomPerson(this.genRandom);
        this.researcher.setRankId(Ranks.CITIZEN);
        this.researcher.setPostId(Ranks.POST_ACADEMICIAN);
        this.beginStageTrigger(new Object[]{Stage.FAILED, Stage.FAILED_DECIV});
        this.triggerSetGlobalMemoryValuePermanent("$gaRR_playerOwes", true);
        this.triggerSetGlobalMemoryValuePermanent("$gaRR_failedCredits", Misc.getWithDGS(this.costNormal));
        this.endTrigger();
        return true;
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog != null && action.equals("showResearcher")) {
            this.showPersonInfo(this.researcher, dialog, false, false);
            return true;
        }
        return false;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$gaRR_department", this.department);
        this.set("$gaRR_marketName", this.market.getName());
        this.set("$gaRR_onOrAt", this.market.getOnOrAt());
        this.set("$gaRR_contactName", this.contact.getNameString());
        this.set("$gaRR_raidDifficulty", Float.valueOf(RAID_DIFFICULTY));
        this.set("$gaRR_researcherName", this.researcher.getNameString());
        this.set("$gaRR_costVeryLow", Misc.getWithDGS(this.costVeryLow));
        this.set("$gaRR_costNormal", Misc.getWithDGS(this.costNormal));
        this.set("$gaRR_costHigh", Misc.getWithDGS(this.costHigh));
        this.set("$gaRR_systemName", this.market.getStarSystem().getNameWithNoType());
        this.set("$gaRR_dist", this.getDistanceLY(this.market));
        this.set("$gaRR_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$gaRR_variation", (Object)this.variation);
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_MARKET) {
            String adjective = "kidnapped";
            if (this.variation == Variation.CHURCH) {
                adjective = "imprisoned";
            }
            info.addPara(String.valueOf(this.getGoToMarketText(this.market)) + ", and ransom the " + adjective + " researcher from " + this.contact.getNameString() + ".", opad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara(String.valueOf(this.getReturnText("the Galatia Academy")) + ".", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_MARKET) {
            info.addPara(this.getGoToMarketText(this.market), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara(this.getReturnTextShort("the Galatia Academy"), tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Ransom Researcher";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GO_TO_MARKET,
        RETURN_TO_ACADEMY,
        COMPLETED,
        FAILED,
        FAILED_DECIV;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variation {
        PIRATE,
        CHURCH;

    }
}

