/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.cb;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.AICoreOfficerPlugin;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.missions.cb.BaseCustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBStats;
import com.fs.starfarer.api.impl.campaign.missions.cb.CustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.List;

public class CBRemnantPlus
extends BaseCustomBountyCreator {
    public static String ACCEPTED_KEY = "$CBRemnantPlus_accepted";
    public static float PROB_IN_SYSTEM_WITH_BASE = 0.5f;

    public float getBountyDays() {
        return CBStats.REMNANT_PLUS_DAYS;
    }

    public float getFrequency(HubMissionWithBarEvent mission, int difficulty) {
        boolean wasEverAccepted = Global.getSector().getMemoryWithoutUpdate().getBoolean(ACCEPTED_KEY);
        if (wasEverAccepted) {
            return 0.0f;
        }
        return super.getFrequency(mission, difficulty) * CBStats.REMNANT_PLUS_FREQ;
    }

    public void notifyAccepted(MarketAPI createdAt, HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        Global.getSector().getMemoryWithoutUpdate().set(ACCEPTED_KEY, true);
    }

    protected boolean isRepeatableGlobally() {
        return false;
    }

    public String getBountyNamePostfix(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        return " - Unusual Remnant Fleet";
    }

    public String getIconName() {
        return Global.getSettings().getSpriteName("campaignMissions", "remnant_bounty");
    }

    public CustomBountyCreator.CustomBountyData createBounty(MarketAPI createdAt, HubMissionWithBarEvent mission, int difficulty, Object bountyStage) {
        StarSystemAPI system;
        CustomBountyCreator.CustomBountyData data = new CustomBountyCreator.CustomBountyData();
        data.difficulty = difficulty;
        mission.requireSystemTags(ReqMode.NOT_ANY, "theme_core");
        mission.preferSystemTags(ReqMode.ANY, "has_coronal_tap");
        mission.preferSystemUnexplored();
        mission.preferSystemInteresting();
        mission.requireSystemNotHasPulsar();
        mission.preferSystemBlackHoleOrNebula();
        mission.preferSystemOnFringeOfSector();
        data.system = system = mission.pickSystem();
        HubMissionWithTriggers.FleetSize size = HubMissionWithTriggers.FleetSize.HUGE;
        HubMissionWithTriggers.FleetQuality quality = HubMissionWithTriggers.FleetQuality.SMOD_3;
        HubMissionWithTriggers.OfficerQuality oQuality = HubMissionWithTriggers.OfficerQuality.AI_ALPHA;
        HubMissionWithTriggers.OfficerNum oNum = HubMissionWithTriggers.OfficerNum.ALL_SHIPS;
        String type = "patrolLarge";
        this.beginFleet(mission, data);
        mission.triggerCreateFleet(size, quality, "remnant", type, data.system);
        mission.triggerSetFleetOfficers(oNum, oQuality);
        mission.triggerAutoAdjustFleetSize(size, size.next());
        mission.triggerSetRemnantConfigActive();
        mission.triggerSetFleetNoCommanderSkills();
        mission.triggerFleetAddCommanderSkill("flux_regulation", 1);
        mission.triggerFleetAddCommanderSkill("electronic_warfare", 1);
        mission.triggerFleetAddCommanderSkill("coordinated_maneuvers", 1);
        mission.triggerFleetAddCommanderSkill("navigation", 1);
        mission.triggerFleetSetAllWeapons();
        mission.triggerMakeHostileAndAggressive();
        mission.triggerFleetAllowLongPursuit();
        mission.triggerPickLocationAtInSystemJumpPoint(data.system);
        mission.triggerSpawnFleetAtPickedLocation(null, null);
        mission.triggerFleetSetPatrolActionText("sending hyperwave signals");
        mission.triggerOrderFleetPatrol(data.system, true, "jump_point", "neutrino", "neutrino_high", "station", "salvageable", "gas_giant");
        data.fleet = this.createFleet(mission, data);
        if (data.fleet == null) {
            return null;
        }
        CampaignFleetAPI fleet = Global.getFactory().createEmptyFleet("omega", "", true);
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(mission.getGenRandom());
        picker.add("tesseract_Attack");
        picker.add("tesseract_Attack2");
        picker.add("tesseract_Strike");
        picker.add("tesseract_Disruptor");
        fleet.getFleetData().addFleetMember((String)picker.pick());
        FleetMemberAPI member = fleet.getFlagship();
        AICoreOfficerPlugin plugin = Misc.getAICoreOfficerPlugin("omega_core");
        PersonAPI person = plugin.createPerson("omega_core", "omega", mission.getGenRandom());
        member.setCaptain(person);
        int i = data.fleet.getFleetData().getMembersListCopy().size() - 1;
        FleetMemberAPI last = data.fleet.getFleetData().getMembersListCopy().get(i);
        data.fleet.getFleetData().removeFleetMember(last);
        data.fleet.setCommander(person);
        data.fleet.getFleetData().addFleetMember(member);
        data.fleet.getFleetData().sort();
        List<FleetMemberAPI> members = data.fleet.getFleetData().getMembersListCopy();
        for (FleetMemberAPI curr : members) {
            curr.getRepairTracker().setCR(curr.getRepairTracker().getMaxCR());
        }
        member.setVariant(member.getVariant().clone(), false, false);
        member.getVariant().setSource(VariantSource.REFIT);
        member.getVariant().addTag("ship_limited_tooltip");
        member.getVariant().addTag("consistent_weapon_drops");
        data.fleet.getMemoryWithoutUpdate().set("$ignorePlayerCommRequests", true);
        this.setRepChangesBasedOnDifficulty(data, difficulty);
        data.baseReward = CBStats.getBaseBounty(difficulty, CBStats.REMNANT_PLUS_MULT, mission);
        return data;
    }

    public int getMaxDifficulty() {
        return super.getMaxDifficulty();
    }

    public int getMinDifficulty() {
        return super.getMaxDifficulty();
    }
}

