/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.luddic;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.econ.RecentUnrest;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithSearch;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuddicKnightErrant
extends HubMissionWithSearch {
    protected PersonAPI bornanew;
    protected PersonAPI jaspis;
    protected PersonAPI nile_virens;
    protected MarketAPI chalcedon;
    protected MarketAPI mazalot;
    protected MarketAPI gilead;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$lke_ref", "$lke_inProgress")) {
            return false;
        }
        this.chalcedon = Global.getSector().getEconomy().getMarket("chalcedon");
        if (this.chalcedon == null) {
            return false;
        }
        if (!this.chalcedon.getFactionId().equals("luddic_path")) {
            return false;
        }
        this.gilead = Global.getSector().getEconomy().getMarket("gilead");
        if (this.gilead == null) {
            return false;
        }
        if (!this.gilead.getFactionId().equals("luddic_church")) {
            return false;
        }
        this.mazalot = Global.getSector().getEconomy().getMarket("mazalot");
        if (this.mazalot == null) {
            return false;
        }
        if (!this.mazalot.getFactionId().equals("persean")) {
            return false;
        }
        this.bornanew = this.getImportantPerson(People.BORNANEW);
        if (this.bornanew == null) {
            return false;
        }
        this.jaspis = this.getImportantPerson(People.JASPIS);
        if (this.bornanew == null) {
            return false;
        }
        this.nile_virens = this.getImportantPerson(People.VIRENS);
        if (this.nile_virens == null) {
            return false;
        }
        this.setStoryMission();
        this.setStartingStage((Object)Stage.GO_TO_CHALCEDON);
        this.makeImportant(this.chalcedon, "$lke_searchForBornanew", Stage.GO_TO_CHALCEDON);
        this.setStageOnGlobalFlag((Object)Stage.CONTACT_RECRUITER, "$lke_contactRecruiter");
        this.makeImportant(this.chalcedon, "$lke_contactRecruiter", Stage.CONTACT_RECRUITER);
        this.setStageOnGlobalFlag((Object)Stage.GO_TO_MAZALOT, "$lke_gotBornanewLead");
        this.makeImportant(this.mazalot, "$lke_searchForBornanew2", Stage.GO_TO_MAZALOT);
        this.setStageOnGlobalFlag((Object)Stage.CONTACT_VIRENS, "$lke_contactVirens");
        this.makeImportant(this.mazalot, "$lke_contactVirens", Stage.CONTACT_VIRENS);
        this.setStageOnGlobalFlag((Object)Stage.CONTACT_BORNANEW, "$lke_contactBornanew");
        this.makeImportant(this.mazalot, "$lke_contactBornanew", Stage.CONTACT_BORNANEW);
        this.setStageOnGlobalFlag((Object)Stage.RETURN_TO_GILEAD, "$lke_foundBornanew");
        this.makeImportant(this.gilead, "$lke_returnWithBornanew", Stage.RETURN_TO_GILEAD);
        this.makeImportant(this.jaspis, "$lke_returnWithBornanew", Stage.RETURN_TO_GILEAD);
        this.setStageOnGlobalFlag((Object)Stage.RETURN_TO_GILEAD2, "$lke_foundBornanew2");
        this.makeImportant(this.gilead, "$lke_returnWithBornanewNews", Stage.RETURN_TO_GILEAD2);
        this.makeImportant(this.jaspis, "$lke_returnWithBornanewNews", Stage.RETURN_TO_GILEAD2);
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$lke_completed");
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.setName("Knight Errant");
        this.setRepFactionChangesNone();
        this.setRepPersonChangesNone();
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerMakeNonStoryCritical("chalcedon", "mazalot", "gilead");
        this.triggerSetGlobalMemoryValue("$lke_completed", true);
        this.endTrigger();
        this.beginWithinHyperspaceRangeTrigger(this.chalcedon.getPlanetEntity(), 1.0f, false, new Object[]{Stage.GO_TO_CHALCEDON});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "luddic_path", "patrolLarge", this.chalcedon.getPlanetEntity());
        this.triggerSetFleetFaction("luddic_path");
        this.triggerPickLocationAroundEntity(this.chalcedon.getPlanetEntity(), 800.0f);
        this.triggerOrderFleetPatrol(this.chalcedon.getPlanetEntity());
        this.triggerSpawnFleetAtPickedLocation("$lke_patherGoblins", null);
        this.triggerSetFleetMissionRef("$lke_ref");
        this.endTrigger();
        this.beginWithinHyperspaceRangeTrigger(this.chalcedon, 3.0f, true, new Object[]{Stage.GO_TO_MAZALOT});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGER, HubMissionWithTriggers.FleetQuality.HIGHER, "luddic_path", "patrolLarge", this.mazalot.getLocationInHyperspace());
        this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        this.triggerMakeHostileAndAggressive();
        this.triggerMakeLowRepImpact();
        this.triggerFleetMakeFaster(true, 2, true);
        this.triggerSetFleetAlwaysPursue();
        this.triggerPickLocationTowardsEntity(this.chalcedon.getStarSystem().getHyperspaceAnchor(), 30.0f, LuddicKnightErrant.getUnits(1.5f));
        this.triggerSpawnFleetAtPickedLocation("$lke_patherIntercept", null);
        this.triggerOrderFleetInterceptPlayer();
        this.triggerOrderFleetEBurn(1.0f);
        this.triggerSetFleetMissionRef("$lke_ref");
        this.triggerFleetMakeImportant(null, Stage.GO_TO_MAZALOT);
        this.endTrigger();
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$lke_stage", this.getCurrentStage());
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("postMissionCleanup".equals(action)) {
            Global.getSector().getMemoryWithoutUpdate().unset("$global.lke_foundBornanew");
            this.mazalot.getMemoryWithoutUpdate().unset("$market.dardanWontTalkLKE");
            return true;
        }
        if ("shootEm".equals(action)) {
            Global.getSoundPlayer().playSound("storyevent_diktat_execution", 1.0f, 1.0f, Global.getSoundPlayer().getListenerPos(), new Vector2f());
            return true;
        }
        if ("resumeMusic".equals(action)) {
            Global.getSoundPlayer().setSuspendDefaultMusicPlayback(false);
            Global.getSoundPlayer().restartCurrentMusic();
            return true;
        }
        if ("endMusic".equals(action)) {
            Global.getSoundPlayer().setSuspendDefaultMusicPlayback(true);
            Global.getSoundPlayer().pauseMusic();
            return true;
        }
        if ("playMusicCombat".equals(action)) {
            Global.getSoundPlayer().playCustomMusic(1, 1, "music_combat", true);
            return true;
        }
        if ("playMusicSedge".equals(action)) {
            Global.getSoundPlayer().playCustomMusic(1, 1, "music_luddite_encounter_hostile", true);
            return true;
        }
        if ("playMusicVirens".equals(action)) {
            Global.getSoundPlayer().playCustomMusic(1, 1, "music_luddite_market_hostile", true);
            return true;
        }
        if ("playMusicJethro".equals(action)) {
            Global.getSoundPlayer().playCustomMusic(1, 1, "music_luddite_market_friendly", true);
            return true;
        }
        if ("playMusicDardan".equals(action)) {
            Global.getSoundPlayer().playCustomMusic(1, 1, "music_persean_league_market_hostile", true);
            return true;
        }
        if ("didMazalotRaid".equals(action)) {
            RecentUnrest.get(this.mazalot).add(10, "Raided Mazalot and caused a Luddic uprising");
            return true;
        }
        if ("doCleanup".equals(action)) {
            Global.getSector().getMemoryWithoutUpdate().unset("$lke_gotVirensContactFreebie");
            Global.getSector().getMemoryWithoutUpdate().unset("$lke_didMazBarAgentEncounter");
            this.chalcedon.getMemoryWithoutUpdate().unset("$lkeBuggedVIPs");
            this.mazalot.getMemoryWithoutUpdate().unset("$lke_wontTellLied");
            this.mazalot.getMemoryWithoutUpdate().unset("$lke_askedPMChurch");
            this.mazalot.getMemoryWithoutUpdate().unset("$lkeSetUpVirensMeeting");
            this.mazalot.getMemoryWithoutUpdate().unset("$dardanWontTalkLKE");
            return true;
        }
        return super.callAction(action, ruleId, dialog, params, memoryMap);
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        if (this.currentStage == Stage.GO_TO_CHALCEDON) {
            info.addPara("Find Bornanew. His last mission was the infiltration of a Pather cell; someone must known something about where he is.", opad);
            this.addStandardMarketDesc("Go to " + this.chalcedon.getOnOrAt(), this.chalcedon, info, opad);
        } else if (this.currentStage == Stage.CONTACT_RECRUITER) {
            info.addPara("You have been told to meet with someone in a spacer bar on the surface of Chalcedon, presumably a recruiter for the Luddic Path.", opad);
            this.addStandardMarketDesc("Go to " + this.chalcedon.getOnOrAt(), this.chalcedon, info, opad);
        } else if (this.currentStage == Stage.GO_TO_MAZALOT) {
            info.addPara("A Pather, Sedge, claims that Jethro Bornanew travelled to Mazalot. Find him, or find where he has gone from there.", opad);
            this.addStandardMarketDesc("Go to " + this.mazalot.getOnOrAt(), this.mazalot, info, opad);
        } else if (this.currentStage == Stage.CONTACT_VIRENS) {
            info.addPara("Nile Virens runs the Luddic Path on Mazalot. If anyone knows where Bornanew is, it would be him or his organization. He might be persuaded to help by force or diplomacy.", opad);
            this.addStandardMarketDesc("Contact Nile Virens " + this.mazalot.getOnOrAt(), this.mazalot, info, opad);
            info.addImage(this.nile_virens.getPortraitSprite(), width, 128.0f, opad);
            info.addImage(this.nile_virens.getFaction().getCrest(), width, 128.0f, opad);
        } else if (this.currentStage == Stage.CONTACT_BORNANEW) {
            info.addPara("Nile Virens has provided you with the location of Jethro Bornanew, or so he claims. This consists of coordinates for a location on the surface of Mazalot, outside of a Luddic-majority settlement.", opad);
            this.addStandardMarketDesc("Contact Jethro Bornanew " + this.mazalot.getOnOrAt(), this.mazalot, info, opad);
        } else if (this.currentStage == Stage.RETURN_TO_GILEAD) {
            info.addPara("Return with Jethro Bornanew to the office of Archcurate Jaspis.", opad);
            this.addStandardMarketDesc("Go to " + this.gilead.getOnOrAt(), this.gilead, info, opad);
        } else if (this.currentStage == Stage.RETURN_TO_GILEAD2) {
            info.addPara("Return to the office of Archcurate Jaspis with news of Jethro Bornanew's 'death'.", opad);
            this.addStandardMarketDesc("Go to " + this.gilead.getOnOrAt(), this.gilead, info, opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        if (this.currentStage == Stage.GO_TO_CHALCEDON) {
            info.addPara("Go to Chalcedon and find Jethro Bornanew", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.CONTACT_RECRUITER) {
            info.addPara("Go to the spacer bar on Chalcedon and speak with the Luddic Path recruiter", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.GO_TO_MAZALOT) {
            info.addPara("Go to Mazalot and find Jethro Bornanew", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.CONTACT_VIRENS) {
            info.addPara("Talk to or raid Nile Virens on Mazalot", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.CONTACT_BORNANEW) {
            info.addPara("Go to the alleged location of Jethro Bornanew on Mazalot", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN_TO_GILEAD) {
            info.addPara("Return to Gilead with Bornanew", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN_TO_GILEAD2) {
            info.addPara("Return to Gilead with news of Bornanew's 'death'.", tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Knight Errant";
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GO_TO_CHALCEDON,
        CONTACT_RECRUITER,
        GO_TO_MAZALOT,
        CONTACT_VIRENS,
        CONTACT_BORNANEW,
        RETURN_TO_GILEAD,
        RETURN_TO_GILEAD2,
        COMPLETED;

    }
}

