/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.ProcgenUsedNames;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constellation {
    protected StarAge age;
    protected transient Map<SectorEntityToken, PlanetAPI> lagrangeParentMap = new HashMap<SectorEntityToken, PlanetAPI>();
    protected transient Map<SectorEntityToken, List<SectorEntityToken>> allEntitiesAdded = new HashMap<SectorEntityToken, List<SectorEntityToken>>();
    protected ProcgenUsedNames.NamePick namePick;
    protected List<StarSystemAPI> systems = new ArrayList<StarSystemAPI>();
    protected ConstellationType type = ConstellationType.NORMAL;
    protected String nameOverride = null;
    protected transient boolean leavePickedNameUnused = false;

    public Constellation(ConstellationType type, StarAge age) {
        this.type = type;
        this.age = age;
    }

    public boolean isLeavePickedNameUnused() {
        return this.leavePickedNameUnused;
    }

    public void setLeavePickedNameUnused(boolean leavePickedNameUnused) {
        this.leavePickedNameUnused = leavePickedNameUnused;
    }

    public StarAge getAge() {
        return this.age;
    }

    public void setAge(StarAge age) {
        this.age = age;
    }

    public Vector2f getLocation() {
        Vector2f loc = new Vector2f();
        if (this.systems.isEmpty()) {
            return loc;
        }
        for (StarSystemAPI system : this.systems) {
            Vector2f.add((Vector2f)loc, (Vector2f)system.getLocation(), (Vector2f)loc);
        }
        loc.scale(1.0f / (float)this.systems.size());
        return loc;
    }

    public ConstellationType getType() {
        return this.type;
    }

    public void setType(ConstellationType type) {
        this.type = type;
    }

    public String getNameOverride() {
        return this.nameOverride;
    }

    public void setNameOverride(String nameOverride) {
        this.nameOverride = nameOverride;
    }

    public String getName() {
        if (this.nameOverride != null) {
            return this.nameOverride;
        }
        return this.namePick.nameWithRomanSuffixIfAny;
    }

    public String getNameWithType() {
        if (this.nameOverride != null) {
            return this.nameOverride;
        }
        String constellationText = String.valueOf(this.getName()) + " Constellation";
        if (this.getType() == ConstellationType.NEBULA) {
            constellationText = String.valueOf(this.getName()) + " Nebula";
        }
        return constellationText;
    }

    public String getNameWithLowercaseType() {
        if (this.nameOverride != null) {
            return this.nameOverride;
        }
        String name = this.getNameWithType();
        name = name.replaceAll("Constellation", "constellation");
        name = name.replaceAll("Nebula", "nebula");
        return name;
    }

    public ProcgenUsedNames.NamePick getNamePick() {
        return this.namePick;
    }

    public void setNamePick(ProcgenUsedNames.NamePick namePick) {
        this.namePick = namePick;
    }

    public List<StarSystemAPI> getSystems() {
        return this.systems;
    }

    public Map<SectorEntityToken, PlanetAPI> getLagrangeParentMap() {
        return this.lagrangeParentMap;
    }

    public void setLagrangeParentMap(Map<SectorEntityToken, PlanetAPI> lagrangeParentMap) {
        this.lagrangeParentMap = lagrangeParentMap;
    }

    public Map<SectorEntityToken, List<SectorEntityToken>> getAllEntitiesAdded() {
        return this.allEntitiesAdded;
    }

    public void setAllEntitiesAdded(Map<SectorEntityToken, List<SectorEntityToken>> allEntitiesAdded) {
        this.allEntitiesAdded = allEntitiesAdded;
    }

    public StarSystemAPI getSystemWithMostPlanets() {
        int most = -1;
        StarSystemAPI result = null;
        for (StarSystemAPI curr : this.systems) {
            int count = curr.getPlanets().size();
            if (count <= most) continue;
            most = count;
            result = curr;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConstellationType {
        NORMAL,
        NEBULA;

    }
}

