/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.impl.campaign.procgen.PlanetConditionGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GravityConditionGenerator
implements PlanetConditionGenerator.ConditionGenerator {
    @Override
    public void addConditions(Set<String> conditionsSoFar, StarSystemGenerator.GenContext context, PlanetAPI planet) {
        if (conditionsSoFar.contains("low_gravity")) {
            return;
        }
        if (conditionsSoFar.contains("high_gravity")) {
            return;
        }
        float radius = planet.getRadius();
        float min = 60.0f;
        float max = 250.0f;
        if (radius < min) {
            radius = min;
        }
        if (radius > max) {
            radius = max;
        }
        if (radius < 100.0f && PlanetConditionGenerator.preconditionsMet("low_gravity", conditionsSoFar)) {
            float range = 100.0f - min;
            float chance = 0.0f;
            if (range > 0.0f) {
                chance = 0.2f + 0.8f * ((100.0f - radius) / range);
            }
            if (StarSystemGenerator.random.nextFloat() < chance) {
                conditionsSoFar.add("low_gravity");
            }
            return;
        }
        if (radius > 140.0f && PlanetConditionGenerator.preconditionsMet("high_gravity", conditionsSoFar)) {
            float range = max - 140.0f;
            float chance = 0.0f;
            if (range > 0.0f) {
                chance = 0.1f + 0.9f * (1.0f - (max - radius) / range);
            }
            if (StarSystemGenerator.random.nextFloat() < chance) {
                conditionsSoFar.add("high_gravity");
            }
            return;
        }
    }
}

