/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.impl.campaign.procgen.PlanetConditionGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightConditionGenerator
implements PlanetConditionGenerator.ConditionGenerator {
    @Override
    public void addConditions(Set<String> conditionsSoFar, StarSystemGenerator.GenContext context, PlanetAPI planet) {
        boolean matchEither;
        int orbitIndex = context.orbitIndex;
        if (context.parent != null) {
            orbitIndex = context.parentOrbitIndex;
        }
        float hab = context.starData.getHabZoneStart();
        float normalIndex = hab + 4.0f;
        float veryIndex = hab + 8.0f;
        float eitherIndex = hab + 5.0f;
        boolean matchVery = (float)orbitIndex >= veryIndex;
        boolean matchNormal = !matchVery && (float)orbitIndex >= normalIndex;
        boolean bl = matchEither = (float)orbitIndex == eitherIndex;
        if (matchEither) {
            matchNormal = StarSystemGenerator.random.nextFloat() < 0.5f;
            matchVery = !matchNormal;
        }
        boolean hasNormal = conditionsSoFar.contains("poor_light");
        boolean hasVery = conditionsSoFar.contains("dark");
        if (matchNormal && !hasVery && !hasNormal && PlanetConditionGenerator.preconditionsMet("poor_light", conditionsSoFar)) {
            conditionsSoFar.add("poor_light");
            return;
        }
        if (matchVery && !hasVery && PlanetConditionGenerator.preconditionsMet("dark", conditionsSoFar)) {
            conditionsSoFar.remove("poor_light");
            conditionsSoFar.add("dark");
            return;
        }
    }
}

