/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.impl.campaign.procgen.AgeGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.ColdConditionGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.ConditionGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.GravityConditionGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.HotConditionGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.LightConditionGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.PlanetGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.RadiationConditionGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanetConditionGenerator {
    public static Map<String, ConditionGenerator> generators = new HashMap<String, ConditionGenerator>();

    static {
        generators.put("gravity", new GravityConditionGenerator());
        generators.put("cold", new ColdConditionGenerator());
        generators.put("hot", new HotConditionGenerator());
        generators.put("light", new LightConditionGenerator());
        generators.put("radiation", new RadiationConditionGenerator());
    }

    public static void generateConditionsForPlanet(StarSystemGenerator.GenContext context, PlanetAPI planet) {
        PlanetConditionGenerator.generateConditionsForPlanet(context, planet, null);
    }

    public static void generateConditionsForPlanet(PlanetAPI planet, StarAge age) {
        PlanetConditionGenerator.generateConditionsForPlanet(null, planet, age);
    }

    public static void generateConditionsForPlanet(StarSystemGenerator.GenContext context, PlanetAPI planet, StarAge age) {
        if (context == null) {
            context = PlanetConditionGenerator.createContext(planet, age);
        }
        Collection<ConditionGenDataSpec> all = Global.getSettings().getAllSpecs(ConditionGenDataSpec.class);
        ArrayList<ConditionGenDataSpec> specs = new ArrayList<ConditionGenDataSpec>();
        for (ConditionGenDataSpec spec : all) {
            specs.add(spec);
        }
        Collections.sort(specs, new Comparator<ConditionGenDataSpec>(){

            @Override
            public int compare(ConditionGenDataSpec o1, ConditionGenDataSpec o2) {
                return (int)Math.signum(o1.getOrder() - o2.getOrder());
            }
        });
        LinkedHashMap groupsInOrder = new LinkedHashMap();
        float prevGroup = -100000.0f;
        ArrayList<String> currList = null;
        for (ConditionGenDataSpec spec : specs) {
            float currGroup = spec.getOrder();
            if (prevGroup != currGroup) {
                currList = new ArrayList<String>();
                groupsInOrder.put(spec.getGroup(), currList);
            }
            prevGroup = currGroup;
            if (currList.contains(spec.getGroup())) continue;
            currList.add(spec.getGroup());
        }
        HashSet<String> conditionsSoFar = new HashSet<String>();
        for (String key : groupsInOrder.keySet()) {
            List groups = (List)groupsInOrder.get(key);
            for (String group : groups) {
                WeightedRandomPicker<String> picker = PlanetConditionGenerator.getGroupPicker(group, conditionsSoFar, context, planet);
                String pick = picker.pick();
                if (pick == null) continue;
                conditionsSoFar.add(pick);
            }
            for (String group : groups) {
                ConditionGenerator generator = generators.get(group);
                if (generator == null) continue;
                generator.addConditions(conditionsSoFar, context, planet);
            }
        }
        MarketAPI market = planet.getMarket();
        if (market == null) {
            market = Global.getFactory().createMarket("market_" + planet.getId(), planet.getName(), 1);
            market.setPlanetConditionMarketOnly(true);
            market.setPrimaryEntity(planet);
            market.setFactionId("neutral");
            planet.setMarket(market);
        }
        for (String cid : conditionsSoFar) {
            if (cid.endsWith(ConditionGenDataSpec.NO_PICK_SUFFIX)) continue;
            MarketConditionAPI mc = market.getSpecificCondition(market.addCondition(cid));
            ConditionGenDataSpec spec = (ConditionGenDataSpec)Global.getSettings().getSpec(ConditionGenDataSpec.class, cid, true);
            mc.setSurveyed(!spec.isRequiresSurvey());
        }
        market.reapplyConditions();
    }

    public static WeightedRandomPicker<String> getGroupPicker(String group, Set<String> conditionsSoFar, StarSystemGenerator.GenContext context, PlanetAPI planet) {
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(StarSystemGenerator.random);
        List<ConditionGenDataSpec> groupData = PlanetConditionGenerator.getDataForGroup(group);
        String planetType = planet.getSpec().getPlanetType();
        PlanetGenDataSpec planetData = (PlanetGenDataSpec)Global.getSettings().getSpec(PlanetGenDataSpec.class, planetType, false);
        String category = planetData.getCategory();
        for (ConditionGenDataSpec data : groupData) {
            float weight = 1.0f;
            if (data.hasMultiplier(planetType)) {
                weight = data.getMultiplier(planetType);
            } else {
                if (!data.hasMultiplier(category)) continue;
                weight = data.getMultiplier(category);
            }
            for (String cid : conditionsSoFar) {
                if (!data.hasMultiplier(cid)) continue;
                weight *= data.getMultiplier(cid);
            }
            if (weight <= 0.0f || !PlanetConditionGenerator.preconditionsMet(data.getId(), conditionsSoFar)) continue;
            picker.add(data.getId(), weight);
        }
        return picker;
    }

    public static boolean preconditionsMet(String conditionId, Set<String> conditionsSoFar) {
        ConditionGenDataSpec data = (ConditionGenDataSpec)Global.getSettings().getSpec(ConditionGenDataSpec.class, conditionId, true);
        boolean foundAll = true;
        for (String cid : data.getRequiresAll()) {
            if (conditionsSoFar.contains(cid)) continue;
            foundAll = false;
            break;
        }
        if (!foundAll) {
            return false;
        }
        boolean foundOne = false;
        for (String cid : data.getRequiresAny()) {
            if (!conditionsSoFar.contains(cid)) continue;
            foundOne = true;
            break;
        }
        if (!foundOne && !data.getRequiresAny().isEmpty()) {
            return false;
        }
        foundOne = false;
        for (String cid : data.getRequiresNotAny()) {
            if (!conditionsSoFar.contains(cid)) continue;
            foundOne = true;
            break;
        }
        return !foundOne;
    }

    public static List<ConditionGenDataSpec> getDataForGroup(String group) {
        ArrayList<ConditionGenDataSpec> result = new ArrayList<ConditionGenDataSpec>();
        Collection<ConditionGenDataSpec> all = Global.getSettings().getAllSpecs(ConditionGenDataSpec.class);
        for (ConditionGenDataSpec spec : all) {
            if (!group.equals(spec.getGroup())) continue;
            result.add(spec);
        }
        return result;
    }

    public static StarSystemGenerator.GenContext createContext(PlanetAPI planet, StarAge age) {
        float dist;
        if (!(planet.getContainingLocation() instanceof StarSystemAPI)) {
            return null;
        }
        StarSystemAPI system = (StarSystemAPI)planet.getContainingLocation();
        StarSystemGenerator.CustomConstellationParams p = new StarSystemGenerator.CustomConstellationParams(age);
        StarSystemGenerator gen = new StarSystemGenerator(p);
        gen.system = system;
        gen.starData = (StarGenDataSpec)Global.getSettings().getSpec(StarGenDataSpec.class, system.getStar().getSpec().getPlanetType(), false);
        gen.starAge = age;
        gen.constellationAge = age;
        gen.starAgeData = (AgeGenDataSpec)Global.getSettings().getSpec(AgeGenDataSpec.class, age.name(), true);
        gen.star = system.getStar();
        gen.pickNebulaAndBackground();
        gen.systemCenter = system.getCenter();
        PlanetAPI parentPlanet = null;
        PlanetAPI parentStar = null;
        if (planet.getOrbitFocus() instanceof PlanetAPI) {
            PlanetAPI p1 = (PlanetAPI)planet.getOrbitFocus();
            PlanetAPI p2 = null;
            if (p1.getOrbitFocus() instanceof PlanetAPI) {
                p2 = (PlanetAPI)p1.getOrbitFocus();
            }
            if (p1.isStar()) {
                parentStar = p1;
            } else {
                parentPlanet = p1;
                parentStar = p2 != null && p2.isStar() ? p2 : system.getStar();
            }
        } else {
            parentStar = system.getStar();
        }
        StarGenDataSpec starData = gen.starData;
        PlanetGenDataSpec planetData = null;
        if (parentStar != null) {
            starData = (StarGenDataSpec)Global.getSettings().getSpec(StarGenDataSpec.class, parentStar.getSpec().getPlanetType(), false);
        }
        if (parentPlanet != null) {
            planetData = (PlanetGenDataSpec)Global.getSettings().getSpec(PlanetGenDataSpec.class, parentPlanet.getSpec().getPlanetType(), false);
        }
        int parentOrbitIndex = -1;
        int orbitIndex = 0;
        float fromStar = 0.0f;
        if (parentPlanet == null) {
            orbitIndex = Misc.getEstimatedOrbitIndex(planet);
            parentOrbitIndex = -1;
            fromStar = dist = Misc.getDistance(parentStar.getLocation(), planet.getLocation());
        } else {
            parentOrbitIndex = Misc.getEstimatedOrbitIndex(planet);
            dist = 0.0f;
            if (parentPlanet.getOrbitFocus() != null) {
                fromStar = dist = Misc.getDistance(parentPlanet.getLocation(), parentPlanet.getOrbitFocus().getLocation());
            }
            orbitIndex = 1;
        }
        StarSystemGenerator.GenContext context = new StarSystemGenerator.GenContext(gen, system, gen.systemCenter, starData, parentPlanet, orbitIndex, age.name(), fromStar, 20000.0f, planetData != null ? planetData.getCategory() : null, parentOrbitIndex);
        context.orbitIndex = orbitIndex;
        return context;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ConditionGenerator {
        public void addConditions(Set<String> var1, StarSystemGenerator.GenContext var2, PlanetAPI var3);
    }
}

